/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.container.tomcat;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.jboss.modcluster.container.ContainerEventHandler;
import org.jboss.modcluster.container.tomcat.ConfigurableProxyConnectorProvider;
import org.jboss.modcluster.container.tomcat.JMXServerProvider;
import org.jboss.modcluster.container.tomcat.ProxyConnectorProvider;
import org.jboss.modcluster.container.tomcat.ServerProvider;
import org.jboss.modcluster.container.tomcat.ServiceLoaderTomcatFactory;
import org.jboss.modcluster.container.tomcat.SimpleProxyConnectorProvider;
import org.jboss.modcluster.container.tomcat.SimpleServerProvider;
import org.jboss.modcluster.container.tomcat.TomcatConnectorConfiguration;
import org.jboss.modcluster.container.tomcat.TomcatEventHandler;
import org.jboss.modcluster.container.tomcat.TomcatFactory;

public class TomcatEventHandlerAdapter
implements TomcatEventHandler {
    private static final int STATUS_FREQUENCY = Integer.parseInt(System.getProperty("org.jboss.modcluster.container.catalina.status-frequency", "1"));
    protected final ContainerEventHandler eventHandler;
    protected final ServerProvider serverProvider;
    protected final TomcatFactory factory;
    protected final AtomicBoolean init = new AtomicBoolean(false);
    protected final AtomicBoolean start = new AtomicBoolean(false);
    private volatile int statusCount = 0;

    public TomcatEventHandlerAdapter(ContainerEventHandler eventHandler, TomcatConnectorConfiguration connectorConfiguration) {
        this(eventHandler, (ServerProvider)new JMXServerProvider(ManagementFactory.getPlatformMBeanServer(), TomcatEventHandlerAdapter.toObjectName("Catalina:type=Server")), new ConfigurableProxyConnectorProvider(connectorConfiguration));
    }

    public TomcatEventHandlerAdapter(ContainerEventHandler eventHandler, Server server, Connector connector) {
        this(eventHandler, (ServerProvider)new SimpleServerProvider(server), new SimpleProxyConnectorProvider(connector));
    }

    public TomcatEventHandlerAdapter(ContainerEventHandler eventHandler, ServerProvider serverProvider, ProxyConnectorProvider connectorProvider) {
        this(eventHandler, serverProvider, new ServiceLoaderTomcatFactory(connectorProvider));
    }

    public TomcatEventHandlerAdapter(ContainerEventHandler eventHandler, ServerProvider serverProvider, TomcatFactory factory) {
        this.eventHandler = eventHandler;
        this.serverProvider = serverProvider;
        this.factory = factory;
    }

    @Override
    public void start() {
        Server server = this.serverProvider.getServer();
        if (server == null) {
            throw new IllegalStateException();
        }
        if (!this.containsListener((Lifecycle)server)) {
            server.addLifecycleListener((LifecycleListener)this);
        }
        if (this.init.compareAndSet(false, true)) {
            this.init(server);
        }
        if (this.start.compareAndSet(false, true)) {
            this.eventHandler.start(this.factory.createServer(server));
        }
    }

    @Override
    public void stop() {
        Server server = this.serverProvider.getServer();
        if (server == null) {
            throw new IllegalStateException();
        }
        server.removeLifecycleListener((LifecycleListener)this);
        if (this.init.get() && this.start.compareAndSet(true, false)) {
            this.eventHandler.stop(this.factory.createServer(server));
        }
        if (this.init.compareAndSet(true, false)) {
            this.destroy(server);
        }
    }

    private boolean containsListener(Lifecycle lifecycle) {
        for (LifecycleListener listener : lifecycle.findLifecycleListeners()) {
            if (!listener.equals(this)) continue;
            return true;
        }
        return false;
    }

    public void containerEvent(ContainerEvent event) {
        Container container = event.getContainer();
        Object child = event.getData();
        String type = event.getType();
        if (type.equals("addChild")) {
            if (container instanceof Host) {
                ((Lifecycle)child).addLifecycleListener((LifecycleListener)this);
                ((Container)child).addPropertyChangeListener((PropertyChangeListener)this);
                if (this.start.get()) {
                    this.eventHandler.add(this.factory.createContext((Context)child));
                }
            } else if (container instanceof Engine) {
                container.addContainerListener((ContainerListener)this);
                if (child != null) {
                    ((Host)child).addContainerListener((ContainerListener)this);
                }
            }
        } else if (type.equals("removeChild")) {
            if (container instanceof Host) {
                ((Lifecycle)child).removeLifecycleListener((LifecycleListener)this);
                ((Container)child).removePropertyChangeListener((PropertyChangeListener)this);
                if (this.start.get()) {
                    this.eventHandler.remove(this.factory.createContext((Context)child));
                }
            } else if (container instanceof Engine) {
                if (child != null) {
                    ((Host)child).removeContainerListener((ContainerListener)this);
                }
                container.removeContainerListener((ContainerListener)this);
            }
        }
    }

    public void lifecycleEvent(LifecycleEvent event) {
        Lifecycle source = event.getLifecycle();
        String type = event.getType();
        if (this.isAfterInit(event)) {
            if (source instanceof Server && this.init.compareAndSet(false, true)) {
                Server server = (Server)source;
                this.init(server);
            }
        } else if (type.equals("start")) {
            if (source instanceof Server && this.init.compareAndSet(false, true)) {
                Server server = (Server)source;
                this.init(server);
            }
        } else if (type.equals("after_start")) {
            if (source instanceof Server) {
                if (this.init.get() && this.start.compareAndSet(false, true)) {
                    this.eventHandler.start(this.factory.createServer((Server)source));
                }
            } else if (source instanceof Context) {
                this.eventHandler.start(this.factory.createContext((Context)source));
            }
        } else if (type.equals("before_stop")) {
            if (source instanceof Context) {
                if (this.start.get()) {
                    this.eventHandler.stop(this.factory.createContext((Context)source));
                }
            } else if (source instanceof Server && this.init.get() && this.start.compareAndSet(true, false)) {
                this.eventHandler.stop(this.factory.createServer((Server)source));
            }
        } else if (this.isBeforeDestroy(event)) {
            if (source instanceof Server && this.init.compareAndSet(true, false)) {
                this.destroy((Server)source);
            }
        } else if (type.equals("periodic") && source instanceof Engine) {
            Engine engine = (Engine)source;
            this.statusCount = (this.statusCount + 1) % STATUS_FREQUENCY;
            if (this.statusCount == 0 && this.start.get()) {
                this.eventHandler.status(this.factory.createEngine(engine));
            }
        }
    }

    protected boolean isAfterInit(LifecycleEvent event) {
        return event.getType().equals("after_init");
    }

    protected boolean isBeforeDestroy(LifecycleEvent event) {
        return event.getType().equals("before_destroy");
    }

    protected void init(Server server) {
        this.eventHandler.init(this.factory.createServer(server));
        this.addListeners(server);
    }

    protected void destroy(Server server) {
        this.removeListeners(server);
        this.eventHandler.shutdown();
    }

    protected void addListeners(Server server) {
        for (Service service : server.findServices()) {
            Container engine = service.getContainer();
            engine.addContainerListener((ContainerListener)this);
            engine.addLifecycleListener((LifecycleListener)this);
            for (Container host : engine.findChildren()) {
                host.addContainerListener((ContainerListener)this);
                for (Container context : host.findChildren()) {
                    context.addLifecycleListener((LifecycleListener)this);
                    context.addPropertyChangeListener((PropertyChangeListener)this);
                }
            }
        }
    }

    protected void removeListeners(Server server) {
        for (Service service : server.findServices()) {
            Container engine = service.getContainer();
            engine.removeContainerListener((ContainerListener)this);
            engine.removeLifecycleListener((LifecycleListener)this);
            for (Container host : engine.findChildren()) {
                host.removeContainerListener((ContainerListener)this);
                for (Container context : host.findChildren()) {
                    context.removeLifecycleListener((LifecycleListener)this);
                    context.removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
        }
    }

    protected static ObjectName toObjectName(String name) {
        try {
            return ObjectName.getInstance(name);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() instanceof Context && "available".equals(event.getPropertyName()) && Boolean.FALSE.equals(event.getOldValue()) && Boolean.TRUE.equals(event.getNewValue())) {
            this.eventHandler.start(this.factory.createContext((Context)event.getSource()));
        }
    }
}

