/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.demo.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class RequestDriver {
    private Client[] clients;
    private final ConcurrentMap<String, AtomicInteger> requestCounts = new ConcurrentHashMap<String, AtomicInteger>();
    private final ConcurrentMap<String, AtomicInteger> sessionCounts = new ConcurrentHashMap<String, AtomicInteger>();
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private Thread startThread;

    public void start(final URL request_url, final URL destroy_url, int num_threads, final int session_life, final int sleep_time, int startup_time) {
        this.requestCounts.clear();
        this.sessionCounts.clear();
        this.clients = new Client[num_threads];
        this.stopped.set(false);
        final int startupPause = startup_time > 0 ? startup_time * 1000 / num_threads : 0;
        System.out.println("Request URL is " + request_url);
        System.out.println("Terminal URL is " + destroy_url);
        System.out.println("Starting " + num_threads + " clients");
        Runnable r = new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < RequestDriver.this.clients.length & !RequestDriver.this.stopped.get()) {
                    Client client;
                    ((RequestDriver)RequestDriver.this).clients[i] = client = new Client(request_url, destroy_url, session_life, sleep_time, RequestDriver.this.requestCounts, RequestDriver.this.sessionCounts, RequestDriver.this.stopped);
                    client.start();
                    try {
                        Thread.sleep(startupPause);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace(System.err);
                        return;
                    }
                    ++i;
                }
            }
        };
        this.startThread = new Thread(r, "RequestDriverStartThread");
        this.startThread.start();
    }

    public void stop() {
        this.stopped.set(true);
        if (this.startThread != null && this.startThread.isAlive()) {
            try {
                this.startThread.join(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.startThread.isAlive()) {
                this.startThread.interrupt();
            }
        }
        if (this.clients != null) {
            for (Client client : this.clients) {
                if (client == null || !client.isAlive()) continue;
                client.terminate();
            }
        }
    }

    public ConcurrentMap<String, AtomicInteger> getRequestCounts() {
        return this.requestCounts;
    }

    public ConcurrentMap<String, AtomicInteger> getSessionCounts() {
        return this.sessionCounts;
    }

    public ClientStatus getClientStatus() {
        ClientStatus result = new ClientStatus();
        if (this.clients != null) {
            for (Client client : this.clients) {
                if (client == null) continue;
                ++result.clientCount;
                if (client.isAlive()) {
                    ++result.liveClientCount;
                }
                if (!client.isSuccessful()) continue;
                ++result.successfulClientCount;
            }
        }
        return result;
    }

    private static class Client
    extends Thread {
        private final URL request_url;
        private final URL destroy_url;
        private final long sessionLife;
        private final long sleepTime;
        private boolean successful = true;
        private final byte[] buffer = new byte[1024];
        private String cookie = null;
        private String lastHandler = null;
        private final AtomicBoolean stopped;
        private final ConcurrentMap<String, AtomicInteger> requests;
        private final ConcurrentMap<String, AtomicInteger> sessions;

        private Client(URL request_url, URL destroy_url, long sessionLife, int sleepTime, ConcurrentMap<String, AtomicInteger> requests, ConcurrentMap<String, AtomicInteger> sessions, AtomicBoolean stopped) {
            this.request_url = request_url;
            this.destroy_url = request_url.equals(destroy_url) ? null : destroy_url;
            this.sessionLife = sessionLife * 1000L;
            this.sleepTime = sleepTime;
            this.requests = requests;
            this.sessions = sessions;
            this.stopped = stopped;
            this.setDaemon(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.loop();
            }
            catch (Exception e) {
                Client.error("failure", e);
                this.successful = false;
            }
            finally {
                try {
                    if (this.cookie != null && this.destroy_url != null) {
                        this.executeRequest(this.destroy_url);
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    this.handleSessionTermination();
                }
            }
        }

        public boolean isSuccessful() {
            return this.successful;
        }

        private void terminate() {
            if (this.isAlive()) {
                try {
                    this.join(5000L);
                    if (this.isAlive()) {
                        this.interrupt();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        private void loop() throws IOException {
            while (!this.stopped.get()) {
                long sessionStart = System.currentTimeMillis();
                long elapsed = 0L;
                boolean failed = false;
                while (elapsed < this.sessionLife && !this.stopped.get()) {
                    try {
                        Thread.sleep(this.sleepTime);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    int rc = this.executeRequest(this.request_url);
                    if (rc == 200) {
                        elapsed = System.currentTimeMillis() - sessionStart;
                        continue;
                    }
                    failed = true;
                    break;
                }
                if (!failed && this.destroy_url != null) {
                    this.executeRequest(this.destroy_url);
                }
                this.handleSessionTermination();
            }
        }

        private int executeRequest(URL url) throws IOException {
            InputStream input = null;
            HttpURLConnection conn = null;
            try {
                conn = (HttpURLConnection)url.openConnection();
                if (this.cookie != null) {
                    conn.setRequestProperty("Cookie", this.cookie);
                }
                input = conn.getInputStream();
                while (input.read(this.buffer) > 0) {
                }
                input.close();
                String handlerNode = conn.getHeaderField("X-ClusterNode");
                Client.modifyCount(handlerNode, this.requests, true);
                String tmp_cookie = conn.getHeaderField("set-cookie");
                if (tmp_cookie != null && this.cookie == null) {
                    this.cookie = tmp_cookie;
                    Client.modifyCount(handlerNode, this.sessions, true);
                    this.lastHandler = handlerNode;
                } else if (this.lastHandler != null && !this.lastHandler.equals(handlerNode)) {
                    Client.modifyCount(this.lastHandler, this.sessions, false);
                    this.lastHandler = null;
                }
                int n = conn.getResponseCode();
                return n;
            }
            catch (Exception e) {
                this.handleSessionTermination();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw (RuntimeException)e;
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }

        private void handleSessionTermination() {
            this.cookie = null;
            String last = this.lastHandler;
            this.lastHandler = null;
            if (last != null) {
                Client.modifyCount(last, this.sessions, false);
            }
        }

        private static void modifyCount(String handlerNode, ConcurrentMap<String, AtomicInteger> map, boolean increment) {
            if (handlerNode != null) {
                AtomicInteger existing;
                AtomicInteger count = (AtomicInteger)map.get(handlerNode);
                if (count == null && (existing = map.putIfAbsent(handlerNode, count = new AtomicInteger())) != null) {
                    count = existing;
                }
                if (increment) {
                    count.incrementAndGet();
                } else {
                    count.decrementAndGet();
                }
            }
        }

        private static void error(String msg, Throwable th) {
            String tmp = "[thread-" + Thread.currentThread().getId() + "]: " + msg;
            if (th != null) {
                tmp = tmp + ", ex: " + th + "\n";
                StringWriter writer = new StringWriter();
                PrintWriter pw = new PrintWriter(writer);
                th.printStackTrace(pw);
                pw.flush();
                tmp = tmp + writer.toString();
            }
            System.err.println(tmp);
        }
    }

    public static class ClientStatus {
        public int clientCount;
        public int liveClientCount;
        public int successfulClientCount;
    }
}

