/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.demo.servlet;

import java.io.IOException;
import java.util.Collections;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.jboss.modcluster.demo.servlet.LoadServlet;

public class SendTrafficLoadServlet
extends LoadServlet {
    private static final long serialVersionUID = -8586013739155819909L;
    private static final String SIZE = "size";

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int size = Integer.parseInt(request.getParameter(SIZE)) * 1024;
        this.log("Writing " + size / 1024 + "KB blob to response for: " + request.getRequestURL().toString());
        response.getOutputStream().write(new byte[size]);
        response.flushBuffer();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        int duration = Integer.parseInt(this.getParameter(request, "duration", "15"));
        String size = this.getParameter(request, SIZE, "100");
        String url = this.createLocalURL(request, Collections.singletonMap(SIZE, size));
        HttpClient client = new HttpClient();
        PostMethod method = new PostMethod(url);
        for (int i = 0; i < duration; ++i) {
            this.log("Sending send traffic load request to: " + url);
            long start = System.currentTimeMillis();
            client.executeMethod((HttpMethod)method);
            long ms = 1000L - (System.currentTimeMillis() - start);
            if (ms <= 0L) continue;
            try {
                Thread.sleep(ms);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.writeLocalName(request, response);
    }
}

