/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.demo.servlet;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.modcluster.demo.servlet.LoadServlet;

public class HeapMemoryLoadServlet
extends LoadServlet {
    private static final long serialVersionUID = -8183119455180366670L;
    private static final String RATIO = "ratio";
    private static final String DEFAULT_RATIO = "0.9";
    private static final int MB = 0x100000;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        int duration = Integer.parseInt(this.getParameter(request, "duration", "15")) * 1000;
        float ratio = Float.parseFloat(this.getParameter(request, RATIO, DEFAULT_RATIO));
        System.gc();
        MemoryUsage usage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        long max = usage.getMax();
        long total = max >= 0L ? max : usage.getCommitted();
        long free = total - usage.getUsed();
        long reserve = (long)((float)free * ratio);
        this.log(total / 0x100000L + "MB total memory");
        this.log(free / 0x100000L + "MB free memory");
        this.log("Reserving " + reserve / 0x100000L + "MB (" + (int)(ratio * 100.0f) + "%) of memory");
        ArrayList<Object> list = new ArrayList<Object>(2);
        if (free > Integer.MAX_VALUE) {
            list.add(new byte[(int)(reserve / Integer.MAX_VALUE)][Integer.MAX_VALUE]);
        }
        list.add(new byte[(int)(reserve % Integer.MAX_VALUE)]);
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.log("Freeing " + reserve / 0x100000L + "MB of memory");
        list.clear();
        System.gc();
        this.writeLocalName(request, response);
    }
}

