/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.demo.servlet;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.impl.client.DefaultHttpClient;
import org.jboss.modcluster.demo.servlet.LoadServlet;

public class SendTrafficLoadServlet
extends LoadServlet {
    private static final long serialVersionUID = -8586013739155819909L;
    private static final String SIZE = "size";

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int size = Integer.parseInt(request.getParameter(SIZE)) * 1024;
        this.log("Writing " + size / 1024 + "KB blob to response for: " + request.getRequestURL().toString());
        response.getOutputStream().write(new byte[size]);
        response.flushBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        int duration = Integer.parseInt(this.getParameter(request, "duration", "15"));
        String size = this.getParameter(request, SIZE, "100");
        URI uri = this.createLocalURI(request, Collections.singletonMap(SIZE, size));
        DefaultHttpClient client = new DefaultHttpClient();
        try {
            for (int i = 0; i < duration; ++i) {
                this.log("Sending send traffic load request to: " + uri);
                long start = System.currentTimeMillis();
                HttpClientUtils.closeQuietly((HttpResponse)client.execute((HttpUriRequest)new HttpPost(uri)));
                long ms = 1000L - (System.currentTimeMillis() - start);
                if (ms <= 0L) continue;
                try {
                    Thread.sleep(ms);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        finally {
            HttpClientUtils.closeQuietly((HttpClient)client);
        }
        this.writeLocalName(request, response);
    }
}

