/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mod_cluster;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.apache.catalina.Service;
import org.apache.catalina.core.StandardServer;
import org.jboss.mod_cluster.JBossWeb;
import org.jboss.mod_cluster.Maintest;
import org.jboss.mod_cluster.ServerThread;
import org.jboss.modcluster.ModClusterService;

public class ProcJBossWeb {
    StandardServer server = null;
    JBossWeb service = null;
    ModClusterService cluster = null;
    static InputStreamReader input;
    static BufferedReader bufferedreader;

    public static void main(String[] args) {
        input = new InputStreamReader(System.in);
        bufferedreader = new BufferedReader(input);
        ProcJBossWeb proc = new ProcJBossWeb();
        proc.start();
    }

    public void start() {
        this.server = new StandardServer();
        System.setProperty("org.apache.catalina.core.StandardService.DELAY_CONNECTOR_STARTUP", "false");
        ServerThread wait = null;
        try {
            String line;
            while ((line = bufferedreader.readLine()) != null) {
                String[] cmd = line.split(" ");
                if (cmd[0].compareToIgnoreCase("exit") == 0) {
                    System.out.println("OK");
                    System.out.flush();
                    System.exit(0);
                } else if (cmd[0].compareToIgnoreCase("new") == 0) {
                    this.service = new JBossWeb(cmd[1], cmd[2]);
                } else if (cmd[0].compareToIgnoreCase("addConnector") == 0) {
                    this.service.addConnector(Integer.parseInt(cmd[1]));
                } else if (cmd[0].compareToIgnoreCase("addService") == 0) {
                    this.server.addService((Service)this.service);
                } else if (cmd[0].compareToIgnoreCase("addLifecycleListener") == 0) {
                    this.cluster = Maintest.createClusterListener(this.server, cmd[1], Integer.parseInt(cmd[2]), false, null, true, false, true, "secret");
                } else if (cmd[0].compareToIgnoreCase("start") == 0) {
                    wait = new ServerThread(3000, this.server);
                    wait.start();
                } else if (cmd[0].compareToIgnoreCase("stop") == 0) {
                    wait.stopit();
                    wait.join();
                    this.server.removeService((Service)this.service);
                } else {
                    String result;
                    if (cmd[0].compareToIgnoreCase("getProxyInfo") == 0) {
                        result = Maintest.getProxyInfo(this.cluster);
                        if (result == null) {
                            System.out.println("0");
                            System.out.println();
                        } else {
                            System.out.println(result.length());
                            System.out.println(result);
                        }
                        System.out.flush();
                        continue;
                    }
                    if (cmd[0].compareToIgnoreCase("getProxyAddress") == 0) {
                        result = Maintest.getProxyAddress(this.cluster);
                        if (result == null) {
                            System.out.println("0");
                            System.out.println();
                        } else {
                            System.out.println(result.length());
                            System.out.println(result);
                        }
                        System.out.flush();
                        continue;
                    }
                    System.out.println("FAILED: wrong command");
                    System.out.flush();
                    continue;
                }
                System.out.println("OK");
                System.out.flush();
            }
        }
        catch (Exception ex) {
            System.out.println("FAILED " + ex);
            ex.printStackTrace(System.out);
            System.out.flush();
            System.exit(1);
        }
    }
}

