/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mod_cluster;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class ControlJBossWeb {
    private BufferedReader bufferedreader;
    private BufferedReader errorreader;
    private PrintStream out;

    public ControlJBossWeb() throws Exception {
        Runtime runtime = Runtime.getRuntime();
        String classpath = System.getProperty("java.class.path");
        Process proc = null;
        proc = System.getProperty("os.name").startsWith("Windows") ? runtime.exec("java -cp \"" + classpath + "\"" + " org.jboss.mod_cluster.ProcJBossWeb") : runtime.exec("java -cp " + classpath + " org.jboss.mod_cluster.ProcJBossWeb");
        InputStreamReader input = new InputStreamReader(proc.getInputStream());
        this.bufferedreader = new BufferedReader(input);
        this.out = new PrintStream(proc.getOutputStream());
        InputStreamReader err = new InputStreamReader(proc.getErrorStream());
        this.errorreader = new BufferedReader(err);
        if (this.errorreader.ready()) {
            String line;
            while ((line = this.errorreader.readLine()) != null) {
                System.out.println(line);
            }
        }
    }

    private boolean isResponseOK() {
        try {
            String line;
            while ((line = this.bufferedreader.readLine()) != null) {
                if (line.compareToIgnoreCase("OK") == 0) {
                    return true;
                }
                if (line.startsWith("FAILED")) {
                    System.out.println(line);
                    while ((line = this.bufferedreader.readLine()) != null) {
                        System.out.println(line);
                    }
                    return false;
                }
                System.out.println(line);
            }
        }
        catch (IOException ex) {
            System.out.println("isResponseOK: " + ex);
            return false;
        }
        System.out.println("isResponseOK: false");
        return false;
    }

    public void stop() throws IOException {
        this.out.println("stop");
        this.out.flush();
        if (!this.isResponseOK()) {
            throw new IOException("response is not OK");
        }
    }

    public void start() throws IOException {
        this.out.println("start");
        this.out.flush();
        if (!this.isResponseOK()) {
            throw new IOException("response is not OK");
        }
    }

    public void exit() throws IOException {
        this.out.println("exit");
        this.out.flush();
        if (!this.isResponseOK()) {
            throw new IOException("response is not OK");
        }
    }

    public void newJBossWeb(String node, String host) throws IOException {
        this.out.println("new " + node + " " + host);
        this.out.flush();
        if (!this.isResponseOK()) {
            throw new IOException("response is not OK");
        }
    }

    public void addConnector(int port) throws IOException {
        this.out.println("addConnector " + port);
        this.out.flush();
        if (!this.isResponseOK()) {
            throw new IOException("response is not OK");
        }
    }

    public void addService() throws IOException {
        this.out.println("addService");
        this.out.flush();
        if (!this.isResponseOK()) {
            throw new IOException("response is not OK");
        }
    }

    public void addLifecycleListener(String ip, int port) throws IOException {
        this.out.println("addLifecycleListener " + ip + " " + port);
        this.out.flush();
        if (!this.isResponseOK()) {
            throw new IOException("response is not OK");
        }
    }

    public String getProxyInfo() throws IOException {
        this.out.println("getProxyInfo");
        this.out.flush();
        return this.readProxyCommandResponse(true);
    }

    public String getProxyAddress() throws IOException {
        this.out.println("getProxyAddress");
        this.out.flush();
        return this.readProxyCommandResponse(false);
    }

    public String readProxyCommandResponse(boolean concat) throws IOException {
        String line = this.bufferedreader.readLine();
        int l = -1;
        while (l == -1) {
            if (line.startsWith("FAILED")) {
                l = 1024;
                break;
            }
            try {
                l = Integer.parseInt(line);
            }
            catch (Exception e) {
                l = -1;
                System.out.println(line);
            }
            if (l >= 0) break;
            line = this.bufferedreader.readLine();
        }
        String result = "";
        int len = l;
        if (!concat) {
            len = l - 2;
        }
        while (result.length() < len && (line = this.bufferedreader.readLine()) != null) {
            result = result.concat(line);
            if (!concat) continue;
            result = result.concat("\n");
        }
        if (l == 0) {
            return null;
        }
        return result;
    }
}

