/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mod_cluster;

import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import junit.framework.Assert;
import org.apache.catalina.Engine;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardServer;
import org.jboss.mod_cluster.JBossWeb;
import org.jboss.mod_cluster.ServerThread;
import org.jboss.modcluster.ModClusterService;
import org.jboss.modcluster.config.SessionDrainingStrategy;
import org.jboss.modcluster.config.impl.ModClusterConfig;
import org.jboss.modcluster.config.impl.SessionDrainingStrategyEnum;
import org.jboss.modcluster.container.ContainerEventHandler;
import org.jboss.modcluster.container.catalina.CatalinaEventHandlerAdapter;
import org.jboss.modcluster.load.LoadBalanceFactorProvider;
import org.jboss.modcluster.load.impl.SimpleLoadBalanceFactorProvider;

public class Maintest {
    static CatalinaEventHandlerAdapter adapter = null;

    static void listServices(StandardServer server) {
        Service[] services = server.findServices();
        for (int i = 0; i < services.length; ++i) {
            System.out.println("service[" + i + "]: " + services[i]);
            Engine engine = (Engine)services[i].getContainer();
            System.out.println("engine: " + engine);
            System.out.println("connectors: " + services[i].findConnectors());
            Connector[] connectors = services[i].findConnectors();
            for (int j = 0; j < connectors.length; ++j) {
                System.out.println("connector: " + connectors[j]);
            }
        }
    }

    static ModClusterService createClusterListener(StandardServer server, String groupa, int groupp, boolean ssl, String domain, boolean stickySession, boolean stickySessionRemove, boolean stickySessionForce, String advertiseSecurityKey, String balancer, String loadBalancingGroup) {
        ModClusterConfig config = new ModClusterConfig();
        config.setAdvertiseGroupAddress(groupa);
        config.setAdvertisePort(groupp);
        config.setSsl(ssl);
        config.setLoadBalancingGroup(domain);
        config.setStickySession(stickySession);
        config.setStickySessionRemove(stickySessionRemove);
        config.setStickySessionForce(stickySessionForce);
        config.setNodeTimeout(20000);
        config.setSessionDrainingStrategy((SessionDrainingStrategy)SessionDrainingStrategyEnum.NEVER);
        if (balancer != null) {
            config.setBalancer(balancer);
        }
        if (loadBalancingGroup != null) {
            config.setLoadBalancingGroup(loadBalancingGroup);
        }
        if (advertiseSecurityKey != null) {
            config.setAdvertiseSecurityKey(advertiseSecurityKey);
        }
        SimpleLoadBalanceFactorProvider load = new SimpleLoadBalanceFactorProvider();
        load.setLoadBalanceFactor(1);
        ModClusterService service = new ModClusterService(config, (LoadBalanceFactorProvider)load);
        adapter = new CatalinaEventHandlerAdapter((ContainerEventHandler)service, (Server)server);
        adapter.start();
        return service;
    }

    static ModClusterService createClusterListener(StandardServer server, String groupa, int groupp, boolean ssl, String domain, boolean stickySession, boolean stickySessionRemove, boolean stickySessionForce, String advertiseSecurityKey) {
        return Maintest.createClusterListener(server, groupa, groupp, ssl, domain, stickySession, stickySessionRemove, stickySessionForce, advertiseSecurityKey, null, null);
    }

    static void StopClusterListener() {
        if (adapter != null) {
            try {
                adapter.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        adapter = null;
    }

    static String doProxyPing(ModClusterService pcluster) {
        String result = null;
        Map map = pcluster.ping();
        if (map.isEmpty()) {
            return null;
        }
        Object[] results = map.values().toArray();
        result = (String)results[0];
        return result;
    }

    static String doProxyPing(ModClusterService pcluster, String JvmRoute) {
        String result = null;
        Map map = pcluster.ping(JvmRoute);
        if (map.isEmpty()) {
            return null;
        }
        Object[] results = map.values().toArray();
        for (int i = 0; i < results.length && (result = (String)results[i]).indexOf("PING-RSP") <= 0; ++i) {
        }
        return result;
    }

    static String doProxyPing(ModClusterService pcluster, String scheme, String host, int port) {
        String result = null;
        Map map = pcluster.ping(scheme, host, port);
        if (map.isEmpty()) {
            return null;
        }
        Object[] results = map.values().toArray();
        for (int i = 0; i < results.length && (result = (String)results[i]).indexOf("PING-RSP") <= 0; ++i) {
        }
        return result;
    }

    static boolean checkProxyPing(String result) {
        String[] records = result.split("\n");
        String[] results = null;
        results = records.length == 3 ? records[1].split("&") : result.split("&");
        int ret = 0;
        for (int j = 0; j < results.length; ++j) {
            String[] data = results[j].split("=");
            if (data[0].compareToIgnoreCase("Type") == 0 && data[1].compareToIgnoreCase("PING-RSP") == 0) {
                ++ret;
            }
            if (data[0].compareToIgnoreCase("State") != 0 || data[1].compareToIgnoreCase("OK") != 0) continue;
            ++ret;
        }
        return ret == 2;
    }

    static String getProxyInfo(ModClusterService pcluster) {
        String result = null;
        Map map = pcluster.getProxyInfo();
        if (map.isEmpty()) {
            return null;
        }
        Object[] results = map.values().toArray();
        result = (String)results[0];
        return result;
    }

    static String getProxyAddress(ModClusterService pcluster) {
        String proxy = null;
        Map map = pcluster.getProxyInfo();
        if (!map.isEmpty()) {
            Object[] results = map.keySet().toArray();
            InetSocketAddress result = (InetSocketAddress)results[0];
            proxy = result.getHostName() + ":" + result.getPort();
        }
        return proxy;
    }

    static boolean checkProxyInfo(ModClusterService pcluster, String[] nodes) {
        String result = Maintest.getProxyInfo(pcluster);
        return Maintest.checkProxyInfo(result, nodes);
    }

    static boolean checkProxyInfo(String result, String[] nodes) {
        if (result == null) {
            return nodes == null;
        }
        boolean[] n = null;
        if (nodes != null && nodes.length > 0) {
            n = new boolean[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                n[i] = false;
            }
        }
        String[] records = result.split("\n");
        boolean l = false;
        for (int i = 0; i < records.length; ++i) {
            int j;
            String[] results = records[i].split(",");
            String[] data = results[0].split(": ");
            if (!"Node".equals(data[0])) continue;
            if (n == null) {
                return false;
            }
            boolean nodeok = false;
            for (j = 0; j < results.length; ++j) {
                String res;
                int id = results[j].indexOf("Load: ");
                if (id < 0 || Integer.parseInt(res = results[j].substring(6)) <= 0) continue;
                nodeok = true;
                break;
            }
            data = results[1].split(": ");
            for (j = 0; j < nodes.length; ++j) {
                if (!nodes[j].equals(data[1])) continue;
                n[j] = nodeok;
            }
        }
        if (n == null) {
            return true;
        }
        for (int j = 0; j < nodes.length; ++j) {
            if (n[j]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testPort(int port) {
        boolean ret = true;
        Socket s = null;
        try {
            s = new Socket("localhost", port);
            s.setSoLinger(true, 0);
        }
        catch (Exception e) {
            System.out.println("Can't connect to " + port);
            ret = false;
        }
        finally {
            if (s != null) {
                System.out.println("Was connected to " + port);
                try {
                    s.close();
                }
                catch (Exception exception) {}
            }
        }
        return ret;
    }

    static boolean TestForNodes(ModClusterService pcluster, String[] nodes) {
        int countinfo;
        for (countinfo = 0; !Maintest.checkProxyInfo(pcluster, nodes) && countinfo < 80; ++countinfo) {
            try {
                Thread.sleep(3000L);
                continue;
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (countinfo == 80) {
            System.out.println("TestForNodes failed: " + Maintest.getProxyInfo(pcluster));
            return false;
        }
        return true;
    }

    static boolean WaitForNodes(ModClusterService pcluster, String[] nodes) {
        if (Maintest.WaitForHttpd(pcluster, 60) == -1) {
            System.out.println("can't find PING-RSP in proxy response");
            return false;
        }
        return Maintest.TestForNodes(pcluster, nodes);
    }

    static int WaitForHttpd(ModClusterService pcluster, int maxtries) {
        String result = null;
        int tries = 0;
        while (result == null && tries < maxtries) {
            result = Maintest.doProxyPing(pcluster);
            if (result != null) {
                if (Maintest.checkProxyPing(result)) break;
                System.out.println("WaitForHttpd (not a ping) failed: " + result);
                return -1;
            }
            try {
                Thread me = Thread.currentThread();
                Thread.sleep(5000L);
                ++tries;
            }
            catch (Exception exception) {}
        }
        if (tries == maxtries) {
            System.out.println("WaitForHttpd (max) failed: " + result);
        }
        return tries;
    }

    static void waitn() {
        try {
            Thread.sleep(35000L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    static void waitForFreePorts(int start, int numbnodes) {
        int count = 0;
        do {
            int i;
            for (i = 0; i < numbnodes; ++i) {
                try {
                    ServerSocket s = new ServerSocket(start + i);
                    s.close();
                    continue;
                }
                catch (Exception e) {
                    System.out.println("port: " + (start + i) + " " + e.getMessage());
                    break;
                }
            }
            if (i == numbnodes) break;
            try {
                System.gc();
                Thread.sleep(60000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (++count != 10);
    }

    static void stop(int MAXSTOPCOUNT, ServerThread wait, StandardServer server, JBossWeb service, ModClusterService cluster) {
        int countinfo;
        try {
            wait.stopit();
            wait.join();
            server.removeService((Service)service);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            Assert.fail((String)"can't stop service");
        }
        String[] nodes = null;
        for (countinfo = 0; !Maintest.checkProxyInfo(cluster, nodes) && countinfo < MAXSTOPCOUNT; ++countinfo) {
            try {
                Thread.sleep(3000L);
                continue;
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        Maintest.StopClusterListener();
        if (countinfo == MAXSTOPCOUNT) {
            Assert.fail((String)"node doesn't dispair");
        }
    }
}

