/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InstanceHandle;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;

class InstanceHandleImpl<T>
implements InstanceHandle<T> {
    static final InstanceHandleImpl<Object> UNAVAILABLE = new InstanceHandleImpl<Object>(null, null, null, null);
    private final InjectableBean<T> bean;
    private final T instance;
    private final CreationalContext<T> creationalContext;
    private final CreationalContext<?> parentCreationalContext;
    private final AtomicBoolean destroyed;

    public static final <T> InstanceHandle<T> unavailable() {
        return UNAVAILABLE;
    }

    InstanceHandleImpl(InjectableBean<T> bean, T instance, CreationalContext<T> creationalContext) {
        this(bean, instance, creationalContext, null);
    }

    InstanceHandleImpl(InjectableBean<T> bean, T instance, CreationalContext<T> creationalContext, CreationalContext<?> parentCreationalContext) {
        this.bean = bean;
        this.instance = instance;
        this.creationalContext = creationalContext;
        this.parentCreationalContext = parentCreationalContext;
        this.destroyed = new AtomicBoolean(false);
    }

    @Override
    public T get() {
        if (this.destroyed.get()) {
            throw new IllegalStateException("Instance already destroyed");
        }
        return this.instance;
    }

    @Override
    public InjectableBean<T> getBean() {
        return this.bean;
    }

    @Override
    public void destroy() {
        if (this.instance != null && this.destroyed.compareAndSet(false, true)) {
            if (this.bean.getScope().equals(Dependent.class)) {
                this.destroyInternal();
            } else {
                Arc.container().getActiveContext(this.bean.getScope()).destroy(this.bean);
            }
        }
    }

    protected void destroyInternal() {
        if (this.parentCreationalContext != null) {
            this.parentCreationalContext.release();
        } else {
            this.bean.destroy(this.instance, this.creationalContext);
        }
    }

    public String toString() {
        return "InstanceHandleImpl [bean=" + this.bean + ", instance=" + this.instance + ", creationalContext=" + this.creationalContext + ", parentCreationalContext=" + this.parentCreationalContext + ", destroyed=" + this.destroyed + "]";
    }
}

