/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ClientProxy;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.impl.ArcContainerImpl;
import io.quarkus.arc.impl.CreationalContextImpl;
import io.quarkus.arc.impl.CurrentInjectionPointProvider;
import io.quarkus.arc.impl.InjectionPointProvider;
import io.quarkus.arc.impl.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Provider;

class InstanceImpl<T>
implements Instance<T> {
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private final CreationalContextImpl<?> creationalContext;
    private final Set<InjectableBean<?>> resolvedBeans;
    private final Type injectionPointType;
    private final Type requiredType;
    private final Set<Annotation> requiredQualifiers;
    private final InjectableBean<?> targetBean;
    private final Set<Annotation> annotations;
    private final Member javaMember;
    private final int position;

    InstanceImpl(InjectableBean<?> targetBean, Type type, Set<Annotation> qualifiers, CreationalContextImpl<?> creationalContext, Set<Annotation> annotations, Member javaMember, int position) {
        this(targetBean, type, InstanceImpl.getRequiredType(type), qualifiers, creationalContext, annotations, javaMember, position);
    }

    InstanceImpl(InstanceImpl<?> parent, Type requiredType, Set<Annotation> requiredQualifiers) {
        this(parent.targetBean, parent.injectionPointType, requiredType, requiredQualifiers, parent.creationalContext, parent.annotations, parent.javaMember, parent.position);
    }

    InstanceImpl(InjectableBean<?> targetBean, Type injectionPointType, Type requiredType, Set<Annotation> requiredQualifiers, CreationalContextImpl<?> creationalContext, Set<Annotation> annotations, Member javaMember, int position) {
        this.injectionPointType = injectionPointType;
        this.requiredType = requiredType;
        this.requiredQualifiers = requiredQualifiers != null ? requiredQualifiers : Collections.emptySet();
        this.creationalContext = creationalContext;
        this.resolvedBeans = this.requiredQualifiers.isEmpty() && Object.class.equals((Object)requiredType) ? null : this.resolve();
        this.targetBean = targetBean;
        this.annotations = annotations;
        this.javaMember = javaMember;
        this.position = position;
    }

    @Override
    public Iterator<T> iterator() {
        return new InstanceIterator(this.beans());
    }

    @Override
    public T get() {
        Set<InjectableBean<?>> beans = this.beans();
        if (beans.isEmpty()) {
            throw new UnsatisfiedResolutionException("No bean found for required type [" + this.requiredType + "] and qualifiers [" + this.requiredQualifiers + "]");
        }
        if (beans.size() > 1) {
            throw new AmbiguousResolutionException("Beans: " + beans.toString());
        }
        return (T)this.getBeanInstance(beans.iterator().next());
    }

    @Override
    public Instance<T> select(Annotation ... qualifiers) {
        HashSet<Annotation> newQualifiers = new HashSet<Annotation>(this.requiredQualifiers);
        Collections.addAll(newQualifiers, qualifiers);
        return new InstanceImpl<T>(this, this.requiredType, newQualifiers);
    }

    @Override
    public <U extends T> Instance<U> select(Class<U> subtype, Annotation ... qualifiers) {
        HashSet<Annotation> newQualifiers = new HashSet<Annotation>(this.requiredQualifiers);
        Collections.addAll(newQualifiers, qualifiers);
        return new InstanceImpl<T>(this, subtype, newQualifiers);
    }

    @Override
    public <U extends T> Instance<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        HashSet<Annotation> newQualifiers = new HashSet<Annotation>(this.requiredQualifiers);
        Collections.addAll(newQualifiers, qualifiers);
        return new InstanceImpl<T>(this, subtype.getType(), newQualifiers);
    }

    @Override
    public boolean isUnsatisfied() {
        return this.beans().isEmpty();
    }

    @Override
    public boolean isAmbiguous() {
        return this.beans().size() > 1;
    }

    @Override
    public void destroy(T instance) {
        Objects.requireNonNull(instance);
        if (instance instanceof ClientProxy) {
            ClientProxy proxy = (ClientProxy)instance;
            InjectableContext context = Arc.container().getActiveContext(proxy.arc_bean().getScope());
            if (context == null) {
                throw new ContextNotActiveException("No active context found for: " + proxy.arc_bean().getScope());
            }
            context.destroy(proxy.arc_bean());
        } else {
            this.creationalContext.destroyDependentInstance(instance);
        }
    }

    void destroy() {
        this.creationalContext.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T getBeanInstance(InjectableBean<T> bean) {
        T instance;
        CreationalContextImpl<T> ctx = this.creationalContext.child(bean);
        InjectionPoint prev = InjectionPointProvider.set(new CurrentInjectionPointProvider.InjectionPointImpl(this.injectionPointType, this.requiredType, this.requiredQualifiers, this.targetBean, this.annotations, this.javaMember, this.position));
        try {
            instance = bean.get(ctx);
        }
        finally {
            InjectionPointProvider.set(prev);
        }
        return instance;
    }

    private Set<InjectableBean<?>> beans() {
        return this.resolvedBeans != null ? this.resolvedBeans : this.resolve();
    }

    private Set<InjectableBean<?>> resolve() {
        return ArcContainerImpl.instance().getResolvedBeans(this.requiredType, this.requiredQualifiers.toArray(EMPTY_ANNOTATION_ARRAY));
    }

    private static Type getRequiredType(Type type) {
        ParameterizedType parameterizedType;
        if (type instanceof ParameterizedType && Provider.class.isAssignableFrom(Types.getRawType((parameterizedType = (ParameterizedType)type).getRawType()))) {
            return parameterizedType.getActualTypeArguments()[0];
        }
        throw new IllegalArgumentException("Not a valid type: " + type);
    }

    class InstanceIterator
    implements Iterator<T> {
        protected final Iterator<InjectableBean<?>> delegate;

        private InstanceIterator(Collection<InjectableBean<?>> beans) {
            this.delegate = beans.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T next() {
            return InstanceImpl.this.getBeanInstance(this.delegate.next());
        }
    }
}

