/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.runtime.context;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.ManagedContext;
import java.util.Map;
import org.eclipse.microprofile.context.spi.ThreadContextController;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;
import org.eclipse.microprofile.context.spi.ThreadContextSnapshot;

public class ArcContextProvider
implements ThreadContextProvider {
    @Override
    public ThreadContextSnapshot currentContext(Map<String, String> map) {
        ArcContainer arc = Arc.container();
        if (arc == null || !arc.isRunning()) {
            return null;
        }
        InjectableContext.ContextState state = this.isContextActiveOnThisThread(arc) ? arc.requestContext().getState() : null;
        return () -> {
            ThreadContextController controller;
            ArcContainer arcContainer = Arc.container();
            if (arcContainer == null || !arcContainer.isRunning()) {
                throw new IllegalStateException("Arc context propagation was attempted but the container is not running.");
            }
            ManagedContext requestContext = arcContainer.requestContext();
            if (this.isContextActiveOnThisThread(arcContainer)) {
                InjectableContext.ContextState stateToRestore = requestContext.getState();
                requestContext.deactivate();
                if (state != null) {
                    requestContext.activate(state);
                }
                controller = () -> {
                    if (state != null) {
                        requestContext.deactivate();
                    }
                    requestContext.activate(stateToRestore);
                };
            } else {
                if (state != null) {
                    requestContext.activate(state);
                }
                controller = () -> {
                    if (state != null) {
                        requestContext.deactivate();
                    }
                };
            }
            return controller;
        };
    }

    @Override
    public ThreadContextSnapshot clearedContext(Map<String, String> map) {
        ArcContainer arc = Arc.container();
        if (arc == null || !arc.isRunning()) {
            return null;
        }
        return () -> {
            ThreadContextController controller;
            ArcContainer arcContainer = Arc.container();
            if (arcContainer == null || !arcContainer.isRunning()) {
                throw new IllegalStateException("Arc context propagation was attempted but the container is not running.");
            }
            ManagedContext requestContext = arcContainer.requestContext();
            if (this.isContextActiveOnThisThread(arcContainer)) {
                InjectableContext.ContextState stateToRestore = requestContext.getState();
                requestContext.deactivate();
                requestContext.activate();
                controller = () -> {
                    requestContext.deactivate();
                    requestContext.activate(stateToRestore);
                };
            } else {
                requestContext.activate();
                controller = () -> requestContext.deactivate();
            }
            return controller;
        };
    }

    @Override
    public String getThreadContextType() {
        return "CDI";
    }

    private boolean isContextActiveOnThisThread(ArcContainer arc) {
        return arc.requestContext().isActive();
    }
}

