/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import com.oracle.svm.core.annotate.RecomputeFieldValue;
import io.quarkus.runtime.configuration.NameIterator;
import java.util.NoSuchElementException;
import org.graalvm.nativeimage.ImageInfo;
import org.jboss.logging.Logger;

public final class ConfigDiagnostic {
    private static final Logger log = Logger.getLogger("io.quarkus.config");
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private static volatile boolean error = false;

    private ConfigDiagnostic() {
    }

    public static void invalidValue(String name, IllegalArgumentException ex) {
        String message = ex.getMessage();
        log.errorf("An invalid value was given for configuration key \"%s\": %s", (Object)name, (Object)(message == null ? ex.toString() : message));
        error = true;
    }

    public static void missingValue(String name, NoSuchElementException ex) {
        String message = ex.getMessage();
        log.errorf("Configuration key \"%s\" is required, but its value is empty/missing: %s", (Object)name, (Object)(message == null ? ex.toString() : message));
        error = true;
    }

    public static void duplicate(String name) {
        log.errorf("Configuration key \"%s\" was specified more than once", (Object)name);
        error = true;
    }

    public static void deprecated(String name) {
        log.warnf("Configuration key \"%s\" is deprecated", (Object)name);
    }

    public static void unknown(String name) {
        log.warnf("Unrecognized configuration key \"%s\" was provided; it will be ignored", (Object)name);
    }

    public static void unknown(NameIterator name) {
        ConfigDiagnostic.unknown(name.getName());
    }

    public static void unknownRunTime(String name) {
        if (ImageInfo.inImageRuntimeCode()) {
            log.warnf("Unrecognized configuration key \"%s\" was provided; it will be ignored", (Object)name);
        }
    }

    public static void unknownRunTime(NameIterator name) {
        ConfigDiagnostic.unknownRunTime(name.getName());
    }

    public static boolean isError() {
        return error;
    }

    public static void resetError() {
        error = false;
    }
}

