/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.health.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.smallrye.health.runtime.RequestScopeHelper;
import io.smallrye.health.SmallRyeHealth;
import io.smallrye.health.SmallRyeHealthReporter;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.io.ByteArrayOutputStream;
import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.CDI;

public class SmallRyeLivenessHandler
implements Handler<RoutingContext> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(RoutingContext event) {
        boolean activated = RequestScopeHelper.activeRequestScope();
        try {
            SmallRyeHealthReporter reporter = (SmallRyeHealthReporter)CDI.current().select(SmallRyeHealthReporter.class, new Annotation[0]).get();
            SmallRyeHealth health = reporter.getLiveness();
            HttpServerResponse resp = event.response();
            if (health.isDown()) {
                resp.setStatusCode(503);
            }
            resp.headers().set(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json; charset=UTF-8");
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            reporter.reportHealth(outputStream, health);
            resp.end(Buffer.buffer(outputStream.toByteArray()));
        }
        finally {
            if (activated) {
                Arc.container().requestContext().terminate();
            }
        }
    }
}

