/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.quarkus.arc.Arc;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.netty.runtime.virtual.VirtualAddress;
import io.quarkus.netty.runtime.virtual.VirtualChannel;
import io.quarkus.netty.runtime.virtual.VirtualServerChannel;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.Timing;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigInstantiator;
import io.quarkus.runtime.configuration.MemorySize;
import io.quarkus.vertx.core.runtime.VertxCoreRecorder;
import io.quarkus.vertx.core.runtime.config.VertxConfiguration;
import io.quarkus.vertx.http.runtime.BodyConfig;
import io.quarkus.vertx.http.runtime.HandlerType;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.quarkus.vertx.http.runtime.QuarkusErrorHandler;
import io.quarkus.vertx.http.runtime.ResumeHandler;
import io.quarkus.vertx.http.runtime.ResumingRouter;
import io.quarkus.vertx.http.runtime.RouterProducer;
import io.quarkus.vertx.http.runtime.ServerSslConfig;
import io.quarkus.vertx.http.runtime.filters.Filter;
import io.quarkus.vertx.http.runtime.filters.Filters;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.impl.Http1xServerConnection;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.enterprise.event.Event;
import org.jboss.logging.Logger;
import org.wildfly.common.cpu.ProcessorInfo;

@Recorder
public class VertxHttpRecorder {
    private static final Logger LOGGER = Logger.getLogger(VertxHttpRecorder.class.getName());
    private static volatile Handler<RoutingContext> hotReplacementHandler;
    private static volatile Runnable closeTask;
    private static volatile Handler<HttpServerRequest> rootHandler;
    private static final Handler<HttpServerRequest> ACTUAL_ROOT;
    protected static ServerBootstrap virtualBootstrap;
    public static VirtualAddress VIRTUAL_HTTP;

    public static void setHotReplacement(Handler<RoutingContext> handler) {
        hotReplacementHandler = handler;
    }

    public static void shutDownDevMode() {
        closeTask.run();
        closeTask = null;
        rootHandler = null;
        hotReplacementHandler = null;
    }

    public static void startServerAfterFailedStart() {
        if (closeTask != null) {
            Handler<RoutingContext> prevHotReplacementHandler = hotReplacementHandler;
            VertxHttpRecorder.shutDownDevMode();
            hotReplacementHandler = prevHotReplacementHandler;
        }
        VertxConfiguration vertxConfiguration = new VertxConfiguration();
        ConfigInstantiator.handleObject(vertxConfiguration);
        VertxCoreRecorder.initializeWeb(vertxConfiguration);
        try {
            HttpConfiguration config = new HttpConfiguration();
            ConfigInstantiator.handleObject(config);
            Router router = Router.router(VertxCoreRecorder.getWebVertx());
            if (hotReplacementHandler != null) {
                router.route().order(Integer.MIN_VALUE).blockingHandler(hotReplacementHandler);
            }
            rootHandler = router;
            VertxHttpRecorder.doServerStart(VertxCoreRecorder.getWebVertx(), config, LaunchMode.DEVELOPMENT, new Supplier<Integer>(){

                @Override
                public Integer get() {
                    return ProcessorInfo.availableProcessors() * 2;
                }
            }, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RuntimeValue<Router> initializeRouter(RuntimeValue<Vertx> vertxRuntimeValue, LaunchMode launchMode, ShutdownContext shutdownContext) {
        Vertx vertx = vertxRuntimeValue.getValue();
        Router router = Router.router(vertx);
        if (hotReplacementHandler != null) {
            router.route().order(Integer.MIN_VALUE).handler(hotReplacementHandler);
        }
        return new RuntimeValue<Router>(router);
    }

    public void startServer(RuntimeValue<Vertx> vertxRuntimeValue, ShutdownContext shutdown, HttpConfiguration httpConfiguration, LaunchMode launchMode, boolean startVirtual, boolean startSocket, Supplier<Integer> ioThreads, String websocketSubProtocols) throws IOException {
        Vertx vertx = vertxRuntimeValue.getValue();
        if (startVirtual) {
            VertxHttpRecorder.initializeVirtual(vertx);
        }
        if (startSocket && closeTask == null) {
            VertxHttpRecorder.doServerStart(vertx, httpConfiguration, launchMode, ioThreads, websocketSubProtocols);
            if (launchMode != LaunchMode.DEVELOPMENT) {
                shutdown.addShutdownTask(closeTask);
            }
        }
    }

    public void finalizeRouter(BeanContainer container, Consumer<Route> defaultRouteHandler, List<Filter> filterList, RuntimeValue<Vertx> vertx, RuntimeValue<Router> runtimeValue, String rootPath, LaunchMode launchMode, boolean requireBodyHandler, final Handler<RoutingContext> bodyHandler) {
        Router router = runtimeValue.getValue();
        Event<Object> event = Arc.container().beanManager().getEvent();
        Filters filters = new Filters();
        event.select(Filters.class, new Annotation[0]).fire(filters);
        filterList.addAll(filters.getFilters());
        ResumingRouter resumingRouter = new ResumingRouter(router);
        event.select(Router.class, new Annotation[0]).fire(resumingRouter);
        for (Filter filter : filterList) {
            if (filter.getHandler() == null) continue;
            router.route().order(-1 * filter.getPriority()).handler(filter.getHandler());
        }
        if (defaultRouteHandler != null) {
            defaultRouteHandler.accept(router.route().order(10000));
        }
        container.instance(RouterProducer.class, new Annotation[0]).initialize(resumingRouter);
        router.route().last().failureHandler(new QuarkusErrorHandler(launchMode.isDevOrTest()));
        if (requireBodyHandler) {
            router.route().order(Integer.MIN_VALUE).handler(new Handler<RoutingContext>(){

                @Override
                public void handle(RoutingContext routingContext) {
                    routingContext.request().resume();
                    bodyHandler.handle(routingContext);
                }
            });
        }
        if (rootPath.equals("/")) {
            if (hotReplacementHandler != null) {
                router.route().order(-1).handler(hotReplacementHandler);
            }
            rootHandler = router;
        } else {
            Router mainRouter = Router.router(vertx.getValue());
            mainRouter.mountSubRouter(rootPath, router);
            if (hotReplacementHandler != null) {
                mainRouter.route().order(-1).handler(hotReplacementHandler);
            }
            rootHandler = mainRouter;
        }
    }

    private static void doServerStart(final Vertx vertx, final HttpConfiguration httpConfiguration, final LaunchMode launchMode, Supplier<Integer> eventLoops, String websocketSubProtocols) throws IOException {
        final HttpServerOptions httpServerOptions = VertxHttpRecorder.createHttpServerOptions(httpConfiguration, launchMode, websocketSubProtocols);
        final HttpServerOptions sslConfig = VertxHttpRecorder.createSslOptions(httpConfiguration, launchMode);
        int eventLoopCount = eventLoops.get();
        int ioThreads = httpConfiguration.ioThreads.isPresent() ? Math.min(httpConfiguration.ioThreads.getAsInt(), eventLoopCount) : eventLoopCount;
        final CompletableFuture futureResult = new CompletableFuture();
        vertx.deployVerticle(new Supplier<Verticle>(){

            @Override
            public Verticle get() {
                return new WebDeploymentVerticle(httpConfiguration.determinePort(launchMode), httpConfiguration.determineSslPort(launchMode), httpConfiguration.host, httpServerOptions, sslConfig, launchMode);
            }
        }, new DeploymentOptions().setInstances(ioThreads), new Handler<AsyncResult<String>>(){

            @Override
            public void handle(AsyncResult<String> event) {
                if (event.failed()) {
                    futureResult.completeExceptionally(event.cause());
                } else {
                    futureResult.complete(event.result());
                }
            }
        });
        try {
            final String deploymentId = (String)futureResult.get();
            closeTask = new Runnable(){

                @Override
                public synchronized void run() {
                    if (closeTask == this) {
                        if (vertx.deploymentIDs().contains(deploymentId)) {
                            final CountDownLatch latch = new CountDownLatch(1);
                            try {
                                vertx.undeploy(deploymentId, new Handler<AsyncResult<Void>>(){

                                    @Override
                                    public void handle(AsyncResult<Void> event) {
                                        latch.countDown();
                                    }
                                });
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            try {
                                latch.await();
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        closeTask = null;
                    }
                }
            };
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Unable to start HTTP server", e);
        }
        Timing.setHttpServer(String.format("Listening on: http://%s:%s", httpServerOptions.getHost(), httpServerOptions.getPort()));
    }

    private static HttpServerOptions createSslOptions(HttpConfiguration httpConfiguration, LaunchMode launchMode) throws IOException {
        ServerSslConfig sslConfig = httpConfiguration.ssl;
        Optional<Path> certFile = sslConfig.certificate.file;
        Optional<Path> keyFile = sslConfig.certificate.keyFile;
        Optional<Path> keyStoreFile = sslConfig.certificate.keyStoreFile;
        String keystorePassword = sslConfig.certificate.keyStorePassword;
        Optional<Path> trustStoreFile = sslConfig.certificate.trustStoreFile;
        Optional<String> trustStorePassword = sslConfig.certificate.trustStorePassword;
        HttpServerOptions serverOptions = new HttpServerOptions();
        serverOptions.setMaxHeaderSize(httpConfiguration.limits.maxHeaderSize.asBigInteger().intValueExact());
        VertxHttpRecorder.setIdleTimeout(httpConfiguration, serverOptions);
        if (certFile.isPresent() && keyFile.isPresent()) {
            VertxHttpRecorder.createPemKeyCertOptions(certFile.get(), keyFile.get(), serverOptions);
        } else if (keyStoreFile.isPresent()) {
            Path keyStorePath = keyStoreFile.get();
            Optional<String> keyStoreFileType = sslConfig.certificate.keyStoreFileType;
            String type = keyStoreFileType.isPresent() ? keyStoreFileType.get().toLowerCase() : VertxHttpRecorder.findKeystoreFileType(keyStorePath);
            byte[] data = VertxHttpRecorder.getFileContent(keyStorePath);
            switch (type) {
                case "pkcs12": {
                    TrustOptions options = new PfxOptions().setPassword(keystorePassword).setValue(Buffer.buffer(data));
                    serverOptions.setPfxKeyCertOptions((PfxOptions)options);
                    break;
                }
                case "jks": {
                    TrustOptions options = new JksOptions().setPassword(keystorePassword).setValue(Buffer.buffer(data));
                    serverOptions.setKeyStoreOptions((JksOptions)options);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown keystore type: " + type + " valid types are jks or pkcs12");
                }
            }
        } else {
            return null;
        }
        if (trustStoreFile.isPresent()) {
            if (!trustStorePassword.isPresent()) {
                throw new IllegalArgumentException("No trust store password provided");
            }
            Optional<String> trustStoreFileType = sslConfig.certificate.trustStoreFileType;
            Path trustStoreFilePath = trustStoreFile.get();
            String type = trustStoreFileType.isPresent() ? trustStoreFileType.get().toLowerCase() : VertxHttpRecorder.findKeystoreFileType(trustStoreFilePath);
            VertxHttpRecorder.createTrustStoreOptions(trustStoreFilePath, trustStorePassword.get(), type, serverOptions);
        }
        for (String cipher : sslConfig.cipherSuites.orElse(Collections.emptyList())) {
            serverOptions.addEnabledCipherSuite(cipher);
        }
        for (String protocol : sslConfig.protocols) {
            if (protocol.isEmpty()) continue;
            serverOptions.addEnabledSecureTransportProtocol(protocol);
        }
        serverOptions.setSsl(true);
        serverOptions.setHost(httpConfiguration.host);
        serverOptions.setPort(httpConfiguration.determineSslPort(launchMode));
        serverOptions.setClientAuth(sslConfig.clientAuth);
        return serverOptions;
    }

    private static byte[] getFileContent(Path path) throws IOException {
        byte[] data;
        InputStream resource = Thread.currentThread().getContextClassLoader().getResourceAsStream(path.toString());
        if (resource != null) {
            try (InputStream is = resource;){
                data = VertxHttpRecorder.doRead(is);
            }
        }
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            data = VertxHttpRecorder.doRead(is);
        }
        return data;
    }

    private static void createPemKeyCertOptions(Path certFile, Path keyFile, HttpServerOptions serverOptions) throws IOException {
        byte[] cert = VertxHttpRecorder.getFileContent(certFile);
        byte[] key = VertxHttpRecorder.getFileContent(keyFile);
        PemKeyCertOptions pemKeyCertOptions = new PemKeyCertOptions().setCertValue(Buffer.buffer(cert)).setKeyValue(Buffer.buffer(key));
        serverOptions.setPemKeyCertOptions(pemKeyCertOptions);
    }

    private static void createTrustStoreOptions(Path trustStoreFile, String trustStorePassword, String trustStoreFileType, HttpServerOptions serverOptions) throws IOException {
        byte[] data = VertxHttpRecorder.getFileContent(trustStoreFile);
        switch (trustStoreFileType) {
            case "pkcs12": {
                PfxOptions options = new PfxOptions().setPassword(trustStorePassword).setValue(Buffer.buffer(data));
                serverOptions.setPfxTrustOptions(options);
                break;
            }
            case "jks": {
                JksOptions options = new JksOptions().setPassword(trustStorePassword).setValue(Buffer.buffer(data));
                serverOptions.setTrustStoreOptions(options);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown truststore type: " + trustStoreFileType + " valid types are jks or pkcs12");
            }
        }
    }

    private static String findKeystoreFileType(Path storePath) {
        String pathName = storePath.toString();
        if (pathName.endsWith(".p12") || pathName.endsWith(".pkcs12") || pathName.endsWith(".pfx")) {
            return "pkcs12";
        }
        return "jks";
    }

    private static byte[] doRead(InputStream is) throws IOException {
        int r;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((r = is.read(buf)) > 0) {
            out.write(buf, 0, r);
        }
        return out.toByteArray();
    }

    private static HttpServerOptions createHttpServerOptions(HttpConfiguration httpConfiguration, LaunchMode launchMode, String websocketSubProtocols) {
        HttpServerOptions options = new HttpServerOptions();
        options.setHost(httpConfiguration.host);
        options.setPort(httpConfiguration.determinePort(launchMode));
        VertxHttpRecorder.setIdleTimeout(httpConfiguration, options);
        options.setMaxHeaderSize(httpConfiguration.limits.maxHeaderSize.asBigInteger().intValueExact());
        options.setWebsocketSubProtocols(websocketSubProtocols);
        return options;
    }

    private static void setIdleTimeout(HttpConfiguration httpConfiguration, HttpServerOptions options) {
        int idleTimeout = (int)httpConfiguration.idleTimeout.toMillis();
        options.setIdleTimeout(idleTimeout);
        options.setIdleTimeoutUnit(TimeUnit.MILLISECONDS);
    }

    public void warnIfPortChanged(HttpConfiguration config, int port) {
        if (config.port != port) {
            LOGGER.errorf("quarkus.http.port was specified at build time as %s however run time value is %s, Kubernetes metadata will be incorrect.", (Object)port, (Object)config.port);
        }
    }

    public void addRoute(RuntimeValue<Router> router, Function<Router, Route> route, Handler<RoutingContext> handler, HandlerType blocking, boolean resume) {
        Route vr = route.apply(router.getValue());
        ResumeHandler requestHandler = handler;
        if (resume) {
            requestHandler = new ResumeHandler(handler);
        }
        if (blocking == HandlerType.BLOCKING) {
            vr.blockingHandler(requestHandler);
        } else if (blocking == HandlerType.FAILURE) {
            vr.failureHandler(requestHandler);
        } else {
            vr.handler(requestHandler);
        }
    }

    private static void initializeVirtual(Vertx vertxRuntime) {
        if (virtualBootstrap != null) {
            return;
        }
        final VertxInternal vertx = (VertxInternal)vertxRuntime;
        virtualBootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)virtualBootstrap.group(vertx.getEventLoopGroup()).channel(VirtualServerChannel.class)).handler(new ChannelInitializer<VirtualServerChannel>(){

            @Override
            public void initChannel(VirtualServerChannel ch) throws Exception {
            }
        })).childHandler(new ChannelInitializer<VirtualChannel>(){

            @Override
            public void initChannel(VirtualChannel ch) throws Exception {
                ContextInternal context = vertx.createEventLoopContext(null, null, new JsonObject(), Thread.currentThread().getContextClassLoader());
                VertxHandler<Http1xServerConnection> handler = VertxHandler.create(context, chctx -> {
                    Http1xServerConnection conn = new Http1xServerConnection(context.owner(), null, new HttpServerOptions(), (ChannelHandlerContext)chctx, context, "localhost", null);
                    conn.handler(ACTUAL_ROOT);
                    return conn;
                });
                ch.pipeline().addLast("handler", handler);
            }
        });
        try {
            virtualBootstrap.bind(VIRTUAL_HTTP).sync();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("failed to bind virtual http");
        }
    }

    public static Handler<HttpServerRequest> getRootHandler() {
        return ACTUAL_ROOT;
    }

    public Handler<RoutingContext> createBodyHandler(HttpConfiguration httpConfiguration) {
        final BodyHandler bodyHandler = BodyHandler.create();
        Optional<MemorySize> maxBodySize = httpConfiguration.limits.maxBodySize;
        if (maxBodySize.isPresent()) {
            bodyHandler.setBodyLimit(maxBodySize.get().asLongValue());
        }
        BodyConfig bodyConfig = httpConfiguration.body;
        bodyHandler.setHandleFileUploads(bodyConfig.handleFileUploads);
        bodyHandler.setUploadsDirectory(bodyConfig.uploadsDirectory);
        bodyHandler.setDeleteUploadedFilesOnEnd(bodyConfig.deleteUploadedFilesOnEnd);
        bodyHandler.setMergeFormAttributes(bodyConfig.mergeFormAttributes);
        bodyHandler.setPreallocateBodyBuffer(bodyConfig.preallocateBodyBuffer);
        return new Handler<RoutingContext>(){

            @Override
            public void handle(RoutingContext event) {
                event.request().resume();
                bodyHandler.handle(event);
            }
        };
    }

    static {
        ACTUAL_ROOT = new Handler<HttpServerRequest>(){

            @Override
            public void handle(HttpServerRequest httpServerRequest) {
                httpServerRequest.pause();
                rootHandler.handle(httpServerRequest);
            }
        };
        VIRTUAL_HTTP = new VirtualAddress("netty-virtual-http");
    }

    private static class WebDeploymentVerticle
    extends AbstractVerticle {
        private final int port;
        private final int httpsPort;
        private final String host;
        private HttpServer httpServer;
        private HttpServer httpsServer;
        private final HttpServerOptions httpOptions;
        private final HttpServerOptions httpsOptions;
        private final LaunchMode launchMode;

        public WebDeploymentVerticle(int port, int httpsPort, String host, HttpServerOptions httpOptions, HttpServerOptions httpsOptions, LaunchMode launchMode) {
            this.port = port;
            this.httpsPort = httpsPort;
            this.host = host;
            this.httpOptions = httpOptions;
            this.httpsOptions = httpsOptions;
            this.launchMode = launchMode;
        }

        @Override
        public void start(Future<Void> startFuture) {
            AtomicInteger remainingCount = new AtomicInteger(this.httpsOptions != null ? 2 : 1);
            this.httpServer = this.vertx.createHttpServer(this.httpOptions);
            this.httpServer.requestHandler(ACTUAL_ROOT);
            this.httpServer.listen(this.port, this.host, event -> {
                if (event.cause() != null) {
                    startFuture.fail(event.cause());
                } else {
                    int actualPort = ((HttpServer)event.result()).actualPort();
                    if (actualPort != this.port) {
                        System.setProperty(this.launchMode == LaunchMode.TEST ? "quarkus.http.test-port" : "quarkus.http.port", String.valueOf(actualPort));
                        this.httpOptions.setPort(actualPort);
                    }
                    if (remainingCount.decrementAndGet() == 0) {
                        startFuture.complete(null);
                    }
                }
            });
            if (this.httpsOptions != null) {
                this.httpsServer = this.vertx.createHttpServer(this.httpsOptions);
                this.httpsServer.requestHandler(ACTUAL_ROOT);
                this.httpsServer.listen(this.httpsPort, this.host, event -> {
                    if (event.cause() != null) {
                        startFuture.fail(event.cause());
                    } else {
                        int actualPort = ((HttpServer)event.result()).actualPort();
                        if (actualPort != this.httpsPort) {
                            System.setProperty(this.launchMode == LaunchMode.TEST ? "quarkus.https.test-port" : "quarkus.https.port", String.valueOf(actualPort));
                            this.httpsOptions.setPort(actualPort);
                        }
                        if (remainingCount.decrementAndGet() == 0) {
                            startFuture.complete();
                        }
                    }
                });
            }
        }

        @Override
        public void stop(final Future<Void> stopFuture) {
            this.httpServer.close(new Handler<AsyncResult<Void>>(){

                @Override
                public void handle(AsyncResult<Void> event) {
                    if (httpsServer != null) {
                        httpsServer.close(new Handler<AsyncResult<Void>>(){

                            @Override
                            public void handle(AsyncResult<Void> event) {
                                stopFuture.complete();
                            }
                        });
                    } else {
                        stopFuture.complete();
                    }
                }
            });
        }
    }
}

