/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.SocketAddress;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class AsyncResolveConnectHelper {
    private static void checkPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port " + port);
        }
    }

    public static Future<Channel> doBind(VertxInternal vertx, SocketAddress socketAddress, ServerBootstrap bootstrap) {
        Promise<Channel> promise = vertx.getAcceptorEventLoopGroup().next().newPromise();
        bootstrap.channelFactory(vertx.transport().serverChannelFactory(socketAddress.path() != null));
        if (socketAddress.path() != null) {
            java.net.SocketAddress converted = vertx.transport().convert(socketAddress, true);
            ChannelFuture future = bootstrap.bind(converted);
            future.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
                if (f.isSuccess()) {
                    promise.setSuccess(future.channel());
                } else {
                    promise.setFailure(f.cause());
                }
            }));
        } else {
            AsyncResolveConnectHelper.checkPort(socketAddress.port());
            vertx.resolveAddress(socketAddress.host(), res -> {
                if (res.succeeded()) {
                    InetSocketAddress t = new InetSocketAddress((InetAddress)res.result(), socketAddress.port());
                    ChannelFuture future = bootstrap.bind(t);
                    future.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
                        if (f.isSuccess()) {
                            promise.setSuccess(future.channel());
                        } else {
                            promise.setFailure(f.cause());
                        }
                    }));
                } else {
                    promise.setFailure(res.cause());
                }
            });
        }
        return promise;
    }
}

