/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.WindowedSerializer;
import org.apache.kafka.streams.state.internals.WindowKeySchema;

public class TimeWindowedSerializer<T>
implements WindowedSerializer<T> {
    private Serializer<T> inner;

    public TimeWindowedSerializer() {
    }

    public TimeWindowedSerializer(Serializer<T> inner) {
        this.inner = inner;
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        if (this.inner == null) {
            String propertyName = isKey ? "default.windowed.key.serde.inner" : "default.windowed.value.serde.inner";
            String value = (String)configs.get(propertyName);
            try {
                this.inner = Utils.newInstance(value, Serde.class).serializer();
                this.inner.configure(configs, isKey);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigException(propertyName, value, "Serde class " + value + " could not be found.");
            }
        }
    }

    @Override
    public byte[] serialize(String topic, Windowed<T> data) {
        if (data == null) {
            return null;
        }
        return WindowKeySchema.toBinary(data, this.inner, topic);
    }

    @Override
    public void close() {
        this.inner.close();
    }

    @Override
    public byte[] serializeBaseKey(String topic, Windowed<T> data) {
        return this.inner.serialize(topic, data.key());
    }

    Serializer<T> innerSerializer() {
        return this.inner;
    }
}

