/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.kstream.internals.Change;

public final class FullChangeSerde<T>
implements Serde<Change<T>> {
    private final Serde<T> inner;

    public static <T> FullChangeSerde<T> castOrWrap(Serde<T> serde) {
        if (serde == null) {
            return null;
        }
        if (serde instanceof FullChangeSerde) {
            return (FullChangeSerde)serde;
        }
        return new FullChangeSerde<T>(serde);
    }

    private FullChangeSerde(Serde<T> inner) {
        this.inner = Objects.requireNonNull(inner);
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        this.inner.configure(configs, isKey);
    }

    @Override
    public void close() {
        this.inner.close();
    }

    @Override
    public Serializer<Change<T>> serializer() {
        final Serializer<T> innerSerializer = this.inner.serializer();
        return new Serializer<Change<T>>(){

            @Override
            public void configure(Map<String, ?> configs, boolean isKey) {
                innerSerializer.configure(configs, isKey);
            }

            @Override
            public byte[] serialize(String topic, Change<T> data) {
                if (data == null) {
                    return null;
                }
                byte[] oldBytes = data.oldValue == null ? null : innerSerializer.serialize(topic, data.oldValue);
                int oldSize = oldBytes == null ? -1 : oldBytes.length;
                byte[] newBytes = data.newValue == null ? null : innerSerializer.serialize(topic, data.newValue);
                int newSize = newBytes == null ? -1 : newBytes.length;
                ByteBuffer buffer = ByteBuffer.wrap(new byte[4 + (oldSize == -1 ? 0 : oldSize) + 4 + (newSize == -1 ? 0 : newSize)]);
                buffer.putInt(oldSize);
                if (oldBytes != null) {
                    buffer.put(oldBytes);
                }
                buffer.putInt(newSize);
                if (newBytes != null) {
                    buffer.put(newBytes);
                }
                return buffer.array();
            }

            @Override
            public void close() {
                innerSerializer.close();
            }
        };
    }

    @Override
    public Deserializer<Change<T>> deserializer() {
        final Deserializer<T> innerDeserializer = this.inner.deserializer();
        return new Deserializer<Change<T>>(){

            @Override
            public void configure(Map<String, ?> configs, boolean isKey) {
                innerDeserializer.configure(configs, isKey);
            }

            @Override
            public Change<T> deserialize(String topic, byte[] data) {
                byte[] newBytes;
                byte[] oldBytes;
                if (data == null) {
                    return null;
                }
                ByteBuffer buffer = ByteBuffer.wrap(data);
                int oldSize = buffer.getInt();
                byte[] byArray = oldBytes = oldSize == -1 ? null : new byte[oldSize];
                if (oldBytes != null) {
                    buffer.get(oldBytes);
                }
                Object oldValue = oldBytes == null ? null : (Object)innerDeserializer.deserialize(topic, oldBytes);
                int newSize = buffer.getInt();
                byte[] byArray2 = newBytes = newSize == -1 ? null : new byte[newSize];
                if (newBytes != null) {
                    buffer.get(newBytes);
                }
                Object newValue = newBytes == null ? null : (Object)innerDeserializer.deserialize(topic, newBytes);
                return new Change<Object>(newValue, oldValue);
            }

            @Override
            public void close() {
                innerDeserializer.close();
            }
        };
    }
}

