/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Map;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.kstream.internals.ForwardingCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.KStreamAggProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.TupleForwarder;
import org.apache.kafka.streams.kstream.internals.metrics.Sensors;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.WindowStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KStreamWindowAggregate<K, V, Agg, W extends Window>
implements KStreamAggProcessorSupplier<K, Windowed<K>, V, Agg> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String storeName;
    private final Windows<W> windows;
    private final Initializer<Agg> initializer;
    private final Aggregator<? super K, ? super V, Agg> aggregator;
    private boolean sendOldValues = false;

    public KStreamWindowAggregate(Windows<W> windows, String storeName, Initializer<Agg> initializer, Aggregator<? super K, ? super V, Agg> aggregator) {
        this.windows = windows;
        this.storeName = storeName;
        this.initializer = initializer;
        this.aggregator = aggregator;
    }

    @Override
    public Processor<K, V> get() {
        return new KStreamWindowAggregateProcessor();
    }

    public Windows<W> windows() {
        return this.windows;
    }

    @Override
    public void enableSendingOldValues() {
        this.sendOldValues = true;
    }

    @Override
    public KTableValueGetterSupplier<Windowed<K>, Agg> view() {
        return new KTableValueGetterSupplier<Windowed<K>, Agg>(){

            @Override
            public KTableValueGetter<Windowed<K>, Agg> get() {
                return new KStreamWindowAggregateValueGetter();
            }

            @Override
            public String[] storeNames() {
                return new String[]{KStreamWindowAggregate.this.storeName};
            }
        };
    }

    private class KStreamWindowAggregateValueGetter
    implements KTableValueGetter<Windowed<K>, Agg> {
        private WindowStore<K, Agg> windowStore;

        private KStreamWindowAggregateValueGetter() {
        }

        @Override
        public void init(ProcessorContext context) {
            this.windowStore = (WindowStore)context.getStateStore(KStreamWindowAggregate.this.storeName);
        }

        @Override
        public Agg get(Windowed<K> windowedKey) {
            Object key = windowedKey.key();
            Window window = windowedKey.window();
            return this.windowStore.fetch(key, window.start());
        }

        @Override
        public void close() {
        }
    }

    private class KStreamWindowAggregateProcessor
    extends AbstractProcessor<K, V> {
        private WindowStore<K, Agg> windowStore;
        private TupleForwarder<Windowed<K>, Agg> tupleForwarder;
        private StreamsMetricsImpl metrics;
        private InternalProcessorContext internalProcessorContext;
        private Sensor lateRecordDropSensor;
        private long observedStreamTime = -1L;

        private KStreamWindowAggregateProcessor() {
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            this.internalProcessorContext = (InternalProcessorContext)context;
            this.metrics = (StreamsMetricsImpl)context.metrics();
            this.lateRecordDropSensor = Sensors.lateRecordDropSensor(this.internalProcessorContext);
            this.windowStore = (WindowStore)context.getStateStore(KStreamWindowAggregate.this.storeName);
            this.tupleForwarder = new TupleForwarder(this.windowStore, context, new ForwardingCacheFlushListener(context), KStreamWindowAggregate.this.sendOldValues);
        }

        @Override
        public void process(K key, V value) {
            if (key == null) {
                KStreamWindowAggregate.this.log.warn("Skipping record due to null key. value=[{}] topic=[{}] partition=[{}] offset=[{}]", value, this.context().topic(), this.context().partition(), this.context().offset());
                this.metrics.skippedRecordsSensor().record();
                return;
            }
            long timestamp = this.context().timestamp();
            this.observedStreamTime = Math.max(this.observedStreamTime, timestamp);
            long closeTime = this.observedStreamTime - KStreamWindowAggregate.this.windows.gracePeriodMs();
            Map matchedWindows = KStreamWindowAggregate.this.windows.windowsFor(timestamp);
            for (Map.Entry entry : matchedWindows.entrySet()) {
                Long windowStart = entry.getKey();
                long windowEnd = ((Window)entry.getValue()).end();
                if (windowEnd > closeTime) {
                    Object oldAgg = this.windowStore.fetch(key, windowStart);
                    if (oldAgg == null) {
                        oldAgg = KStreamWindowAggregate.this.initializer.apply();
                    }
                    Object newAgg = KStreamWindowAggregate.this.aggregator.apply(key, value, oldAgg);
                    this.windowStore.put(key, newAgg, windowStart);
                    this.tupleForwarder.maybeForward(new Windowed(key, (Window)entry.getValue()), newAgg, KStreamWindowAggregate.this.sendOldValues ? oldAgg : null);
                    continue;
                }
                KStreamWindowAggregate.this.log.debug("Skipping record for expired window. key=[{}] topic=[{}] partition=[{}] offset=[{}] timestamp=[{}] window=[{},{}) expiration=[{}] streamTime=[{}]", key, this.context().topic(), this.context().partition(), this.context().offset(), this.context().timestamp(), windowStart, windowEnd, closeTime, this.observedStreamTime);
                this.lateRecordDropSensor.record();
            }
        }
    }
}

