/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.metrics;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.Sum;
import org.apache.kafka.common.metrics.stats.Total;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;

public class Sensors {
    private Sensors() {
    }

    public static Sensor lateRecordDropSensor(InternalProcessorContext context) {
        StreamsMetricsImpl metrics = context.metrics();
        Sensor sensor = metrics.nodeLevelSensor(context.taskId().toString(), context.currentNode().name(), "late-record-drop", Sensor.RecordingLevel.INFO, new Sensor[0]);
        StreamsMetricsImpl.addInvocationRateAndCount(sensor, "stream-processor-node-metrics", metrics.tagMap("task-id", context.taskId().toString(), "processor-node-id", context.currentNode().name()), "late-record-drop");
        return sensor;
    }

    public static Sensor recordLatenessSensor(InternalProcessorContext context) {
        StreamsMetricsImpl metrics = context.metrics();
        Sensor sensor = metrics.taskLevelSensor(context.taskId().toString(), "record-lateness", Sensor.RecordingLevel.DEBUG, new Sensor[0]);
        Map<String, String> tags = metrics.tagMap("task-id", context.taskId().toString());
        sensor.add(new MetricName("record-lateness-avg", "stream-task-metrics", "The average observed lateness of records.", tags), new Avg());
        sensor.add(new MetricName("record-lateness-max", "stream-task-metrics", "The max observed lateness of records.", tags), new Max());
        return sensor;
    }

    public static Sensor suppressionEmitSensor(InternalProcessorContext context) {
        StreamsMetricsImpl metrics = context.metrics();
        Sensor sensor = metrics.nodeLevelSensor(context.taskId().toString(), context.currentNode().name(), "suppression-emit", Sensor.RecordingLevel.DEBUG, new Sensor[0]);
        Map<String, String> tags = metrics.tagMap("task-id", context.taskId().toString(), "processor-node-id", context.currentNode().name());
        sensor.add(new MetricName("suppression-emit-rate", "stream-processor-node-metrics", "The average number of occurrence of suppression-emit operation per second.", tags), new Rate(TimeUnit.SECONDS, new Sum()));
        sensor.add(new MetricName("suppression-emit-total", "stream-processor-node-metrics", "The total number of occurrence of suppression-emit operations.", tags), new Total());
        return sensor;
    }
}

