/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.metrics;

import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Count;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.Total;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.processor.internals.metrics.CumulativeCount;

public class StreamsMetricsImpl
implements StreamsMetrics {
    private final Metrics metrics;
    private final Map<Sensor, Sensor> parentSensors;
    private final Sensor skippedRecordsSensor;
    private final String threadName;
    private final Deque<String> threadLevelSensors = new LinkedList<String>();
    private final Map<String, Deque<String>> taskLevelSensors = new HashMap<String, Deque<String>>();
    private final Map<String, Deque<String>> nodeLevelSensors = new HashMap<String, Deque<String>>();
    private final Map<String, Deque<String>> cacheLevelSensors = new HashMap<String, Deque<String>>();
    private final Map<String, Deque<String>> storeLevelSensors = new HashMap<String, Deque<String>>();
    private static final String SENSOR_PREFIX_DELIMITER = ".";
    private static final String SENSOR_NAME_DELIMITER = ".s.";
    public static final String PROCESSOR_NODE_METRICS_GROUP = "stream-processor-node-metrics";
    public static final String PROCESSOR_NODE_ID_TAG = "processor-node-id";

    public StreamsMetricsImpl(Metrics metrics, String threadName) {
        Objects.requireNonNull(metrics, "Metrics cannot be null");
        this.threadName = threadName;
        this.metrics = metrics;
        this.parentSensors = new HashMap<Sensor, Sensor>();
        String group = "stream-metrics";
        this.skippedRecordsSensor = this.threadLevelSensor("skipped-records", Sensor.RecordingLevel.INFO, new Sensor[0]);
        this.skippedRecordsSensor.add(new MetricName("skipped-records-rate", "stream-metrics", "The average per-second number of skipped records", this.tagMap(new String[0])), new Rate(TimeUnit.SECONDS, new Count()));
        this.skippedRecordsSensor.add(new MetricName("skipped-records-total", "stream-metrics", "The total number of skipped records", this.tagMap(new String[0])), new Total());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Sensor threadLevelSensor(String sensorName, Sensor.RecordingLevel recordingLevel, Sensor ... parents) {
        Deque<String> deque = this.threadLevelSensors;
        synchronized (deque) {
            String fullSensorName = this.threadSensorPrefix() + SENSOR_NAME_DELIMITER + sensorName;
            Sensor sensor = this.metrics.sensor(fullSensorName, recordingLevel, parents);
            this.threadLevelSensors.push(fullSensorName);
            return sensor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeAllThreadLevelSensors() {
        Deque<String> deque = this.threadLevelSensors;
        synchronized (deque) {
            while (!this.threadLevelSensors.isEmpty()) {
                this.metrics.removeSensor(this.threadLevelSensors.pop());
            }
        }
    }

    private String threadSensorPrefix() {
        return "internal." + this.threadName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Sensor taskLevelSensor(String taskName, String sensorName, Sensor.RecordingLevel recordingLevel, Sensor ... parents) {
        String key = this.taskSensorPrefix(taskName);
        Map<String, Deque<String>> map = this.taskLevelSensors;
        synchronized (map) {
            if (!this.taskLevelSensors.containsKey(key)) {
                this.taskLevelSensors.put(key, new LinkedList());
            }
            String fullSensorName = key + SENSOR_NAME_DELIMITER + sensorName;
            Sensor sensor = this.metrics.sensor(fullSensorName, recordingLevel, parents);
            this.taskLevelSensors.get(key).push(fullSensorName);
            return sensor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeAllTaskLevelSensors(String taskName) {
        String key = this.taskSensorPrefix(taskName);
        Map<String, Deque<String>> map = this.taskLevelSensors;
        synchronized (map) {
            Deque<String> sensors = this.taskLevelSensors.remove(key);
            while (sensors != null && !sensors.isEmpty()) {
                this.metrics.removeSensor(sensors.pop());
            }
        }
    }

    private String taskSensorPrefix(String taskName) {
        return this.threadSensorPrefix() + SENSOR_PREFIX_DELIMITER + "task" + SENSOR_PREFIX_DELIMITER + taskName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sensor nodeLevelSensor(String taskName, String processorNodeName, String sensorName, Sensor.RecordingLevel recordingLevel, Sensor ... parents) {
        String key = this.nodeSensorPrefix(taskName, processorNodeName);
        Map<String, Deque<String>> map = this.nodeLevelSensors;
        synchronized (map) {
            if (!this.nodeLevelSensors.containsKey(key)) {
                this.nodeLevelSensors.put(key, new LinkedList());
            }
            String fullSensorName = key + SENSOR_NAME_DELIMITER + sensorName;
            Sensor sensor = this.metrics.sensor(fullSensorName, recordingLevel, parents);
            this.nodeLevelSensors.get(key).push(fullSensorName);
            return sensor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeAllNodeLevelSensors(String taskName, String processorNodeName) {
        String key = this.nodeSensorPrefix(taskName, processorNodeName);
        Map<String, Deque<String>> map = this.nodeLevelSensors;
        synchronized (map) {
            Deque<String> sensors = this.nodeLevelSensors.remove(key);
            while (sensors != null && !sensors.isEmpty()) {
                this.metrics.removeSensor(sensors.pop());
            }
        }
    }

    private String nodeSensorPrefix(String taskName, String processorNodeName) {
        return this.taskSensorPrefix(taskName) + SENSOR_PREFIX_DELIMITER + "node" + SENSOR_PREFIX_DELIMITER + processorNodeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Sensor cacheLevelSensor(String taskName, String cacheName, String sensorName, Sensor.RecordingLevel recordingLevel, Sensor ... parents) {
        String key = this.cacheSensorPrefix(taskName, cacheName);
        Map<String, Deque<String>> map = this.cacheLevelSensors;
        synchronized (map) {
            if (!this.cacheLevelSensors.containsKey(key)) {
                this.cacheLevelSensors.put(key, new LinkedList());
            }
            String fullSensorName = key + SENSOR_NAME_DELIMITER + sensorName;
            Sensor sensor = this.metrics.sensor(fullSensorName, recordingLevel, parents);
            this.cacheLevelSensors.get(key).push(fullSensorName);
            return sensor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeAllCacheLevelSensors(String taskName, String cacheName) {
        String key = this.cacheSensorPrefix(taskName, cacheName);
        Map<String, Deque<String>> map = this.cacheLevelSensors;
        synchronized (map) {
            Deque<String> strings = this.cacheLevelSensors.remove(key);
            while (strings != null && !strings.isEmpty()) {
                this.metrics.removeSensor(strings.pop());
            }
        }
    }

    private String cacheSensorPrefix(String taskName, String cacheName) {
        return this.taskSensorPrefix(taskName) + SENSOR_PREFIX_DELIMITER + "cache" + SENSOR_PREFIX_DELIMITER + cacheName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Sensor storeLevelSensor(String taskName, String storeName, String sensorName, Sensor.RecordingLevel recordingLevel, Sensor ... parents) {
        String key = this.storeSensorPrefix(taskName, storeName);
        Map<String, Deque<String>> map = this.storeLevelSensors;
        synchronized (map) {
            if (!this.storeLevelSensors.containsKey(key)) {
                this.storeLevelSensors.put(key, new LinkedList());
            }
            String fullSensorName = key + SENSOR_NAME_DELIMITER + sensorName;
            Sensor sensor = this.metrics.sensor(fullSensorName, recordingLevel, parents);
            this.storeLevelSensors.get(key).push(fullSensorName);
            return sensor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeAllStoreLevelSensors(String taskName, String storeName) {
        String key = this.storeSensorPrefix(taskName, storeName);
        Map<String, Deque<String>> map = this.storeLevelSensors;
        synchronized (map) {
            Deque<String> sensors = this.storeLevelSensors.remove(key);
            while (sensors != null && !sensors.isEmpty()) {
                this.metrics.removeSensor(sensors.pop());
            }
        }
    }

    private String storeSensorPrefix(String taskName, String storeName) {
        return this.taskSensorPrefix(taskName) + SENSOR_PREFIX_DELIMITER + "store" + SENSOR_PREFIX_DELIMITER + storeName;
    }

    public final Sensor skippedRecordsSensor() {
        return this.skippedRecordsSensor;
    }

    @Override
    public Sensor addSensor(String name, Sensor.RecordingLevel recordingLevel) {
        return this.metrics.sensor(name, recordingLevel);
    }

    @Override
    public Sensor addSensor(String name, Sensor.RecordingLevel recordingLevel, Sensor ... parents) {
        return this.metrics.sensor(name, recordingLevel, parents);
    }

    @Override
    public Map<MetricName, ? extends Metric> metrics() {
        return Collections.unmodifiableMap(this.metrics.metrics());
    }

    @Override
    public void recordLatency(Sensor sensor, long startNs, long endNs) {
        sensor.record(endNs - startNs);
    }

    @Override
    public void recordThroughput(Sensor sensor, long value) {
        sensor.record(value);
    }

    public final Map<String, String> tagMap(String ... tags) {
        LinkedHashMap<String, String> tagMap = new LinkedHashMap<String, String>();
        tagMap.put("client-id", this.threadName);
        if (tags != null) {
            if (tags.length % 2 != 0) {
                throw new IllegalArgumentException("Tags needs to be specified in key-value pairs");
            }
            for (int i = 0; i < tags.length; i += 2) {
                tagMap.put(tags[i], tags[i + 1]);
            }
        }
        return tagMap;
    }

    private Map<String, String> constructTags(String scopeName, String entityName, String ... tags) {
        String[] updatedTags = Arrays.copyOf(tags, tags.length + 2);
        updatedTags[tags.length] = scopeName + "-id";
        updatedTags[tags.length + 1] = entityName;
        return this.tagMap(updatedTags);
    }

    @Override
    public Sensor addLatencyAndThroughputSensor(String scopeName, String entityName, String operationName, Sensor.RecordingLevel recordingLevel, String ... tags) {
        String group = StreamsMetricsImpl.groupNameFromScope(scopeName);
        Map<String, String> tagMap = this.constructTags(scopeName, entityName, tags);
        Map<String, String> allTagMap = this.constructTags(scopeName, "all", tags);
        Sensor parent = this.metrics.sensor(this.externalParentSensorName(operationName), recordingLevel);
        StreamsMetricsImpl.addAvgMaxLatency(parent, group, allTagMap, operationName);
        StreamsMetricsImpl.addInvocationRateAndCount(parent, group, allTagMap, operationName);
        Sensor sensor = this.metrics.sensor(this.externalChildSensorName(operationName, entityName), recordingLevel, parent);
        StreamsMetricsImpl.addAvgMaxLatency(sensor, group, tagMap, operationName);
        StreamsMetricsImpl.addInvocationRateAndCount(sensor, group, tagMap, operationName);
        this.parentSensors.put(sensor, parent);
        return sensor;
    }

    @Override
    public Sensor addThroughputSensor(String scopeName, String entityName, String operationName, Sensor.RecordingLevel recordingLevel, String ... tags) {
        String group = StreamsMetricsImpl.groupNameFromScope(scopeName);
        Map<String, String> tagMap = this.constructTags(scopeName, entityName, tags);
        Map<String, String> allTagMap = this.constructTags(scopeName, "all", tags);
        Sensor parent = this.metrics.sensor(this.externalParentSensorName(operationName), recordingLevel);
        StreamsMetricsImpl.addInvocationRateAndCount(parent, group, allTagMap, operationName);
        Sensor sensor = this.metrics.sensor(this.externalChildSensorName(operationName, entityName), recordingLevel, parent);
        StreamsMetricsImpl.addInvocationRateAndCount(sensor, group, tagMap, operationName);
        this.parentSensors.put(sensor, parent);
        return sensor;
    }

    private String externalChildSensorName(String operationName, String entityName) {
        return "external." + this.threadName + SENSOR_PREFIX_DELIMITER + "entity" + SENSOR_PREFIX_DELIMITER + entityName + SENSOR_NAME_DELIMITER + operationName;
    }

    private String externalParentSensorName(String operationName) {
        return "external." + this.threadName + SENSOR_NAME_DELIMITER + operationName;
    }

    public static void addAvgMaxLatency(Sensor sensor, String group, Map<String, String> tags, String operation) {
        sensor.add(new MetricName(operation + "-latency-avg", group, "The average latency of " + operation + " operation.", tags), new Avg());
        sensor.add(new MetricName(operation + "-latency-max", group, "The max latency of " + operation + " operation.", tags), new Max());
    }

    public static void addInvocationRateAndCount(Sensor sensor, String group, Map<String, String> tags, String operation) {
        sensor.add(new MetricName(operation + "-rate", group, "The average number of occurrence of " + operation + " operation per second.", tags), new Rate(TimeUnit.SECONDS, new Count()));
        sensor.add(new MetricName(operation + "-total", group, "The total number of occurrence of " + operation + " operations.", tags), new CumulativeCount());
    }

    @Override
    public void removeSensor(Sensor sensor) {
        Objects.requireNonNull(sensor, "Sensor is null");
        this.metrics.removeSensor(sensor.name());
        Sensor parent = this.parentSensors.remove(sensor);
        if (parent != null) {
            this.metrics.removeSensor(parent.name());
        }
    }

    Map<Sensor, Sensor> parentSensors() {
        return Collections.unmodifiableMap(this.parentSensors);
    }

    private static String groupNameFromScope(String scopeName) {
        return "stream-" + scopeName + "-metrics";
    }
}

