/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state;

import java.util.Objects;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.errors.StreamsException;

public final class StateSerdes<K, V> {
    private final String topic;
    private final Serde<K> keySerde;
    private final Serde<V> valueSerde;

    public static <K, V> StateSerdes<K, V> withBuiltinTypes(String topic, Class<K> keyClass, Class<V> valueClass) {
        return new StateSerdes<K, V>(topic, Serdes.serdeFrom(keyClass), Serdes.serdeFrom(valueClass));
    }

    public StateSerdes(String topic, Serde<K> keySerde, Serde<V> valueSerde) {
        Objects.requireNonNull(topic, "topic cannot be null");
        Objects.requireNonNull(keySerde, "key serde cannot be null");
        Objects.requireNonNull(valueSerde, "value serde cannot be null");
        this.topic = topic;
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
    }

    public Serde<K> keySerde() {
        return this.keySerde;
    }

    public Serde<V> valueSerde() {
        return this.valueSerde;
    }

    public Deserializer<K> keyDeserializer() {
        return this.keySerde.deserializer();
    }

    public Serializer<K> keySerializer() {
        return this.keySerde.serializer();
    }

    public Deserializer<V> valueDeserializer() {
        return this.valueSerde.deserializer();
    }

    public Serializer<V> valueSerializer() {
        return this.valueSerde.serializer();
    }

    public String topic() {
        return this.topic;
    }

    public K keyFrom(byte[] rawKey) {
        return this.keySerde.deserializer().deserialize(this.topic, rawKey);
    }

    public V valueFrom(byte[] rawValue) {
        return this.valueSerde.deserializer().deserialize(this.topic, rawValue);
    }

    public byte[] rawKey(K key) {
        try {
            return this.keySerde.serializer().serialize(this.topic, key);
        }
        catch (ClassCastException e) {
            String keyClass = key == null ? "unknown because key is null" : key.getClass().getName();
            throw new StreamsException(String.format("A serializer (key: %s) is not compatible to the actual key type (key type: %s). Change the default Serdes in StreamConfig or provide correct Serdes via method parameters.", this.keySerializer().getClass().getName(), keyClass), e);
        }
    }

    public byte[] rawValue(V value) {
        try {
            return this.valueSerde.serializer().serialize(this.topic, value);
        }
        catch (ClassCastException e) {
            String valueClass = value == null ? "unknown because value is null" : value.getClass().getName();
            throw new StreamsException(String.format("A serializer (value: %s) is not compatible to the actual value type (value type: %s). Change the default Serdes in StreamConfig or provide correct Serdes via method parameters.", this.valueSerializer().getClass().getName(), valueClass), e);
        }
    }
}

