/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.NoSuchElementException;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.PeekingKeyValueIterator;

abstract class AbstractMergedSortedCacheStoreIterator<K, KS, V, VS>
implements KeyValueIterator<K, V> {
    private final PeekingKeyValueIterator<Bytes, LRUCacheEntry> cacheIterator;
    private final KeyValueIterator<KS, VS> storeIterator;

    AbstractMergedSortedCacheStoreIterator(PeekingKeyValueIterator<Bytes, LRUCacheEntry> cacheIterator, KeyValueIterator<KS, VS> storeIterator) {
        this.cacheIterator = cacheIterator;
        this.storeIterator = storeIterator;
    }

    abstract int compare(Bytes var1, KS var2);

    abstract K deserializeStoreKey(KS var1);

    abstract KeyValue<K, V> deserializeStorePair(KeyValue<KS, VS> var1);

    abstract K deserializeCacheKey(Bytes var1);

    abstract V deserializeCacheValue(LRUCacheEntry var1);

    private boolean isDeletedCacheEntry(KeyValue<Bytes, LRUCacheEntry> nextFromCache) {
        return ((LRUCacheEntry)nextFromCache.value).value() == null;
    }

    @Override
    public boolean hasNext() {
        while (this.cacheIterator.hasNext() && this.isDeletedCacheEntry(this.cacheIterator.peekNext())) {
            if (this.storeIterator.hasNext()) {
                KS nextStoreKey = this.storeIterator.peekNextKey();
                if (this.compare((Bytes)this.cacheIterator.peekNextKey(), nextStoreKey) == 0) {
                    this.storeIterator.next();
                }
            }
            this.cacheIterator.next();
        }
        return this.cacheIterator.hasNext() || this.storeIterator.hasNext();
    }

    @Override
    public KeyValue<K, V> next() {
        KS nextStoreKey;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Bytes nextCacheKey = this.cacheIterator.hasNext() ? (Bytes)this.cacheIterator.peekNextKey() : null;
        KS KS = nextStoreKey = this.storeIterator.hasNext() ? (KS)this.storeIterator.peekNextKey() : null;
        if (nextCacheKey == null) {
            return this.nextStoreValue(nextStoreKey);
        }
        if (nextStoreKey == null) {
            return this.nextCacheValue(nextCacheKey);
        }
        int comparison = this.compare(nextCacheKey, nextStoreKey);
        if (comparison > 0) {
            return this.nextStoreValue(nextStoreKey);
        }
        if (comparison < 0) {
            return this.nextCacheValue(nextCacheKey);
        }
        this.storeIterator.next();
        return this.nextCacheValue(nextCacheKey);
    }

    private KeyValue<K, V> nextStoreValue(KS nextStoreKey) {
        KeyValue next = (KeyValue)this.storeIterator.next();
        if (!next.key.equals(nextStoreKey)) {
            throw new IllegalStateException("Next record key is not the peeked key value; this should not happen");
        }
        return this.deserializeStorePair(next);
    }

    private KeyValue<K, V> nextCacheValue(Bytes nextCacheKey) {
        KeyValue next = (KeyValue)this.cacheIterator.next();
        if (!((Bytes)next.key).equals(nextCacheKey)) {
            throw new IllegalStateException("Next record key is not the peeked key value; this should not happen");
        }
        return KeyValue.pair(this.deserializeCacheKey((Bytes)next.key), this.deserializeCacheValue((LRUCacheEntry)next.value));
    }

    @Override
    public K peekNextKey() {
        KS nextStoreKey;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Bytes nextCacheKey = this.cacheIterator.hasNext() ? (Bytes)this.cacheIterator.peekNextKey() : null;
        KS KS = nextStoreKey = this.storeIterator.hasNext() ? (KS)this.storeIterator.peekNextKey() : null;
        if (nextCacheKey == null) {
            return this.deserializeStoreKey(nextStoreKey);
        }
        if (nextStoreKey == null) {
            return this.deserializeCacheKey(nextCacheKey);
        }
        int comparison = this.compare(nextCacheKey, nextStoreKey);
        if (comparison > 0) {
            return this.deserializeStoreKey(nextStoreKey);
        }
        if (comparison < 0) {
            return this.deserializeCacheKey(nextCacheKey);
        }
        this.storeIterator.next();
        return this.deserializeCacheKey(nextCacheKey);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() is not supported in " + this.getClass().getName());
    }

    @Override
    public void close() {
        this.cacheIterator.close();
        this.storeIterator.close();
    }
}

