/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Objects;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.CacheFlushListener;
import org.apache.kafka.streams.state.internals.CachedStateStore;
import org.apache.kafka.streams.state.internals.FilteredCacheIterator;
import org.apache.kafka.streams.state.internals.HasNextCondition;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.MergedSortedCacheSessionStoreIterator;
import org.apache.kafka.streams.state.internals.SegmentedCacheFunction;
import org.apache.kafka.streams.state.internals.SessionKeySchema;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

class CachingSessionStore<K, AGG>
extends WrappedStateStore<SessionStore<Bytes, byte[]>>
implements SessionStore<Bytes, byte[]>,
CachedStateStore<Windowed<K>, AGG> {
    private final SessionKeySchema keySchema;
    private final Serde<K> keySerde;
    private final Serde<AGG> aggSerde;
    private final SegmentedCacheFunction cacheFunction;
    private String cacheName;
    private ThreadCache cache;
    private StateSerdes<K, AGG> serdes;
    private InternalProcessorContext context;
    private CacheFlushListener<Windowed<K>, AGG> flushListener;
    private boolean sendOldValues;
    private String topic;

    CachingSessionStore(SessionStore<Bytes, byte[]> bytesStore, Serde<K> keySerde, Serde<AGG> aggSerde, long segmentInterval) {
        super(bytesStore);
        this.keySerde = keySerde;
        this.aggSerde = aggSerde;
        this.keySchema = new SessionKeySchema();
        this.cacheFunction = new SegmentedCacheFunction(this.keySchema, segmentInterval);
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        this.topic = ProcessorStateManager.storeChangelogTopic(context.applicationId(), root.name());
        this.initInternal((InternalProcessorContext)context);
        super.init(context, root);
    }

    private void initInternal(InternalProcessorContext context) {
        this.context = context;
        this.serdes = new StateSerdes(this.topic, this.keySerde == null ? context.keySerde() : this.keySerde, this.aggSerde == null ? context.valueSerde() : this.aggSerde);
        this.cacheName = context.taskId() + "-" + this.name();
        this.cache = context.getCache();
        this.cache.addDirtyEntryFlushListener(this.cacheName, entries -> {
            for (ThreadCache.DirtyEntry entry : entries) {
                this.putAndMaybeForward(entry, context);
            }
        });
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> findSessions(Bytes key, long earliestSessionEndTime, long latestSessionStartTime) {
        this.validateStoreOpen();
        Bytes cacheKeyFrom = this.cacheFunction.cacheKey(this.keySchema.lowerRangeFixedSize(key, earliestSessionEndTime));
        Bytes cacheKeyTo = this.cacheFunction.cacheKey(this.keySchema.upperRangeFixedSize(key, latestSessionStartTime));
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = this.cache.range(this.cacheName, cacheKeyFrom, cacheKeyTo);
        KeyValueIterator<Windowed<Bytes>, byte[]> storeIterator = ((SessionStore)this.wrapped()).findSessions(key, earliestSessionEndTime, latestSessionStartTime);
        HasNextCondition hasNextCondition = this.keySchema.hasNextCondition(key, key, earliestSessionEndTime, latestSessionStartTime);
        FilteredCacheIterator filteredCacheIterator = new FilteredCacheIterator(cacheIterator, hasNextCondition, this.cacheFunction);
        return new MergedSortedCacheSessionStoreIterator(filteredCacheIterator, storeIterator, this.cacheFunction);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> findSessions(Bytes keyFrom, Bytes keyTo, long earliestSessionEndTime, long latestSessionStartTime) {
        this.validateStoreOpen();
        Bytes cacheKeyFrom = this.cacheFunction.cacheKey(this.keySchema.lowerRange(keyFrom, earliestSessionEndTime));
        Bytes cacheKeyTo = this.cacheFunction.cacheKey(this.keySchema.upperRange(keyTo, latestSessionStartTime));
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = this.cache.range(this.cacheName, cacheKeyFrom, cacheKeyTo);
        KeyValueIterator<Windowed<Bytes>, byte[]> storeIterator = ((SessionStore)this.wrapped()).findSessions(keyFrom, keyTo, earliestSessionEndTime, latestSessionStartTime);
        HasNextCondition hasNextCondition = this.keySchema.hasNextCondition(keyFrom, keyTo, earliestSessionEndTime, latestSessionStartTime);
        FilteredCacheIterator filteredCacheIterator = new FilteredCacheIterator(cacheIterator, hasNextCondition, this.cacheFunction);
        return new MergedSortedCacheSessionStoreIterator(filteredCacheIterator, storeIterator, this.cacheFunction);
    }

    @Override
    public void remove(Windowed<Bytes> sessionKey) {
        this.validateStoreOpen();
        this.put(sessionKey, null);
    }

    @Override
    public void put(Windowed<Bytes> key, byte[] value) {
        this.validateStoreOpen();
        Bytes binaryKey = SessionKeySchema.toBinary(key);
        LRUCacheEntry entry = new LRUCacheEntry(value, this.context.headers(), true, this.context.offset(), this.context.timestamp(), this.context.partition(), this.context.topic());
        this.cache.put(this.cacheName, this.cacheFunction.cacheKey(binaryKey), entry);
    }

    @Override
    public byte[] fetchSession(Bytes key, long startTime, long endTime) {
        Objects.requireNonNull(key, "key cannot be null");
        this.validateStoreOpen();
        if (this.cache == null) {
            return (byte[])((SessionStore)this.wrapped()).fetchSession(key, startTime, endTime);
        }
        Bytes bytesKey = SessionKeySchema.toBinary(key, startTime, endTime);
        Bytes cacheKey = this.cacheFunction.cacheKey(bytesKey);
        LRUCacheEntry entry = this.cache.get(this.cacheName, cacheKey);
        if (entry == null) {
            return (byte[])((SessionStore)this.wrapped()).fetchSession(key, startTime, endTime);
        }
        return entry.value();
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetch(Bytes key) {
        Objects.requireNonNull(key, "key cannot be null");
        return this.findSessions(key, 0L, Long.MAX_VALUE);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetch(Bytes from, Bytes to) {
        Objects.requireNonNull(from, "from cannot be null");
        Objects.requireNonNull(to, "to cannot be null");
        return this.findSessions(from, to, 0L, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putAndMaybeForward(ThreadCache.DirtyEntry entry, InternalProcessorContext context) {
        Bytes binaryKey = this.cacheFunction.key(entry.key());
        Windowed<Bytes> bytesKey = SessionKeySchema.from(binaryKey);
        if (this.flushListener != null) {
            byte[] oldValueBytes;
            byte[] newValueBytes = entry.newValue();
            byte[] byArray = oldValueBytes = newValueBytes == null || this.sendOldValues ? (byte[])((SessionStore)this.wrapped()).fetchSession(bytesKey.key(), bytesKey.window().start(), bytesKey.window().end()) : null;
            if (newValueBytes != null || oldValueBytes != null) {
                Windowed<K> key = SessionKeySchema.from(bytesKey, this.serdes.keyDeserializer(), this.topic);
                Object newValue = newValueBytes != null ? (Object)this.serdes.valueFrom(newValueBytes) : null;
                Object oldValue = this.sendOldValues && oldValueBytes != null ? (Object)this.serdes.valueFrom(oldValueBytes) : null;
                ((SessionStore)this.wrapped()).put(bytesKey, entry.newValue());
                ProcessorRecordContext current = context.recordContext();
                context.setRecordContext(entry.entry().context());
                try {
                    this.flushListener.apply(key, newValue, oldValue, entry.entry().context().timestamp());
                }
                finally {
                    context.setRecordContext(current);
                }
            }
        } else {
            ((SessionStore)this.wrapped()).put(bytesKey, entry.newValue());
        }
    }

    @Override
    public void flush() {
        this.cache.flush(this.cacheName);
        super.flush();
    }

    @Override
    public void close() {
        this.flush();
        this.cache.close(this.cacheName);
        super.close();
    }

    @Override
    public void setFlushListener(CacheFlushListener<Windowed<K>, AGG> flushListener, boolean sendOldValues) {
        this.flushListener = flushListener;
        this.sendOldValues = sendOldValues;
    }
}

