/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.List;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.MemoryLRUCache;
import org.apache.kafka.streams.state.internals.StoreChangeLogger;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

public class ChangeLoggingKeyValueBytesStore
extends WrappedStateStore<KeyValueStore<Bytes, byte[]>>
implements KeyValueStore<Bytes, byte[]> {
    private StoreChangeLogger<Bytes, byte[]> changeLogger;

    ChangeLoggingKeyValueBytesStore(KeyValueStore<Bytes, byte[]> inner) {
        super(inner);
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        super.init(context, root);
        String topic = ProcessorStateManager.storeChangelogTopic(context.applicationId(), this.name());
        this.changeLogger = new StoreChangeLogger<Bytes, byte[]>(this.name(), context, new StateSerdes<Bytes, byte[]>(topic, Serdes.Bytes(), Serdes.ByteArray()));
        if (this.wrapped() instanceof MemoryLRUCache) {
            ((MemoryLRUCache)this.wrapped()).setWhenEldestRemoved((key, value) -> this.changeLogger.logChange((Bytes)key, (byte[])null));
        }
    }

    @Override
    public long approximateNumEntries() {
        return ((KeyValueStore)this.wrapped()).approximateNumEntries();
    }

    @Override
    public void put(Bytes key, byte[] value) {
        ((KeyValueStore)this.wrapped()).put(key, value);
        this.changeLogger.logChange(key, value);
    }

    @Override
    public byte[] putIfAbsent(Bytes key, byte[] value) {
        byte[] previous = this.get(key);
        if (previous == null) {
            this.put(key, value);
        }
        return previous;
    }

    @Override
    public void putAll(List<KeyValue<Bytes, byte[]>> entries) {
        ((KeyValueStore)this.wrapped()).putAll(entries);
        for (KeyValue entry : entries) {
            this.changeLogger.logChange((Bytes)entry.key, (byte[])entry.value);
        }
    }

    @Override
    public byte[] delete(Bytes key) {
        byte[] oldValue = (byte[])((KeyValueStore)this.wrapped()).delete(key);
        this.changeLogger.logChange(key, null);
        return oldValue;
    }

    @Override
    public byte[] get(Bytes key) {
        return (byte[])((KeyValueStore)this.wrapped()).get(key);
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> range(Bytes from, Bytes to) {
        return ((KeyValueStore)this.wrapped()).range(from, to);
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> all() {
        return ((KeyValueStore)this.wrapped()).all();
    }
}

