/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.SessionKeySchema;
import org.apache.kafka.streams.state.internals.StoreChangeLogger;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

class ChangeLoggingSessionBytesStore
extends WrappedStateStore<SessionStore<Bytes, byte[]>>
implements SessionStore<Bytes, byte[]> {
    private StoreChangeLogger<Bytes, byte[]> changeLogger;

    ChangeLoggingSessionBytesStore(SessionStore<Bytes, byte[]> bytesStore) {
        super(bytesStore);
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        super.init(context, root);
        String topic = ProcessorStateManager.storeChangelogTopic(context.applicationId(), this.name());
        this.changeLogger = new StoreChangeLogger<Bytes, byte[]>(this.name(), context, new StateSerdes<Bytes, byte[]>(topic, Serdes.Bytes(), Serdes.ByteArray()));
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> findSessions(Bytes key, long earliestSessionEndTime, long latestSessionStartTime) {
        return ((SessionStore)this.wrapped()).findSessions(key, earliestSessionEndTime, latestSessionStartTime);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> findSessions(Bytes keyFrom, Bytes keyTo, long earliestSessionEndTime, long latestSessionStartTime) {
        return ((SessionStore)this.wrapped()).findSessions(keyFrom, keyTo, earliestSessionEndTime, latestSessionStartTime);
    }

    @Override
    public void remove(Windowed<Bytes> sessionKey) {
        ((SessionStore)this.wrapped()).remove(sessionKey);
        this.changeLogger.logChange(SessionKeySchema.toBinary(sessionKey), null);
    }

    @Override
    public void put(Windowed<Bytes> sessionKey, byte[] aggregate) {
        ((SessionStore)this.wrapped()).put(sessionKey, aggregate);
        this.changeLogger.logChange(SessionKeySchema.toBinary(sessionKey), aggregate);
    }

    @Override
    public byte[] fetchSession(Bytes key, long startTime, long endTime) {
        return (byte[])((SessionStore)this.wrapped()).fetchSession(key, startTime, endTime);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetch(Bytes key) {
        return this.findSessions(key, 0L, Long.MAX_VALUE);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetch(Bytes from, Bytes to) {
        return this.findSessions(from, to, 0L, Long.MAX_VALUE);
    }
}

