/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.kafka.common.utils.AbstractIterator;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.internals.RocksDBStore;
import org.apache.kafka.streams.state.internals.StoreProxyUtils;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBTimestampedStore
extends RocksDBStore {
    private static final Logger log = LoggerFactory.getLogger(RocksDBTimestampedStore.class);

    RocksDBTimestampedStore(String name) {
        super(name);
    }

    @Override
    void openRocksDB(DBOptions dbOptions, ColumnFamilyOptions columnFamilyOptions) {
        List<ColumnFamilyDescriptor> columnFamilyDescriptors = Arrays.asList(new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY, columnFamilyOptions), new ColumnFamilyDescriptor("keyValueWithTimestamp".getBytes(StandardCharsets.UTF_8), columnFamilyOptions));
        ArrayList<ColumnFamilyHandle> columnFamilies = new ArrayList<ColumnFamilyHandle>(columnFamilyDescriptors.size());
        try {
            this.db = RocksDB.open(dbOptions, this.dbDir.getAbsolutePath(), columnFamilyDescriptors, columnFamilies);
            ColumnFamilyHandle noTimestampColumnFamily = (ColumnFamilyHandle)columnFamilies.get(0);
            RocksIterator noTimestampsIter = this.db.newIterator(noTimestampColumnFamily);
            noTimestampsIter.seekToFirst();
            if (noTimestampsIter.isValid()) {
                log.info("Opening store {} in upgrade mode", (Object)this.name);
                this.dbAccessor = new DualColumnFamilyAccessor(noTimestampColumnFamily, (ColumnFamilyHandle)columnFamilies.get(1));
            } else {
                log.info("Opening store {} in regular mode", (Object)this.name);
                this.dbAccessor = new RocksDBStore.SingleColumnFamilyAccessor((ColumnFamilyHandle)columnFamilies.get(1));
            }
            noTimestampsIter.close();
        }
        catch (RocksDBException e) {
            if ("Column family not found: : keyValueWithTimestamp".equals(e.getMessage())) {
                try {
                    this.db = RocksDB.open(dbOptions, this.dbDir.getAbsolutePath(), columnFamilyDescriptors.subList(0, 1), columnFamilies);
                    columnFamilies.add(this.db.createColumnFamily(columnFamilyDescriptors.get(1)));
                }
                catch (RocksDBException fatal) {
                    throw new ProcessorStateException("Error opening store " + this.name + " at location " + this.dbDir.toString(), fatal);
                }
                log.info("Opening store {} in upgrade mode", (Object)this.name);
                this.dbAccessor = new DualColumnFamilyAccessor((ColumnFamilyHandle)columnFamilies.get(0), (ColumnFamilyHandle)columnFamilies.get(1));
            }
            throw new ProcessorStateException("Error opening store " + this.name + " at location " + this.dbDir.toString(), e);
        }
    }

    private class RocksDBDualCFRangeIterator
    extends RocksDBDualCFIterator {
        private final Comparator<byte[]> comparator;
        private final byte[] upperBoundKey;

        RocksDBDualCFRangeIterator(String storeName, RocksIterator iterWithTimestamp, RocksIterator iterNoTimestamp, Bytes from, Bytes to) {
            super(storeName, iterWithTimestamp, iterNoTimestamp);
            this.comparator = Bytes.BYTES_LEXICO_COMPARATOR;
            iterWithTimestamp.seek(from.get());
            iterNoTimestamp.seek(from.get());
            this.upperBoundKey = to.get();
            if (this.upperBoundKey == null) {
                throw new NullPointerException("RocksDBDualCFRangeIterator: upperBoundKey is null for key " + to);
            }
        }

        @Override
        public KeyValue<Bytes, byte[]> makeNext() {
            Object next = super.makeNext();
            if (next == null) {
                return (KeyValue)this.allDone();
            }
            if (this.comparator.compare(((Bytes)((KeyValue)next).key).get(), this.upperBoundKey) <= 0) {
                return next;
            }
            return (KeyValue)this.allDone();
        }
    }

    private class RocksDBDualCFIterator
    extends AbstractIterator<KeyValue<Bytes, byte[]>>
    implements KeyValueIterator<Bytes, byte[]> {
        private final Comparator<byte[]> comparator = Bytes.BYTES_LEXICO_COMPARATOR;
        private final String storeName;
        private final RocksIterator iterWithTimestamp;
        private final RocksIterator iterNoTimestamp;
        private volatile boolean open = true;
        private byte[] nextWithTimestamp;
        private byte[] nextNoTimestamp;
        private KeyValue<Bytes, byte[]> next;

        RocksDBDualCFIterator(String storeName, RocksIterator iterWithTimestamp, RocksIterator iterNoTimestamp) {
            this.iterWithTimestamp = iterWithTimestamp;
            this.iterNoTimestamp = iterNoTimestamp;
            this.storeName = storeName;
        }

        @Override
        public synchronized boolean hasNext() {
            if (!this.open) {
                throw new InvalidStateStoreException(String.format("RocksDB iterator for store %s has closed", this.storeName));
            }
            return super.hasNext();
        }

        @Override
        public synchronized KeyValue<Bytes, byte[]> next() {
            return (KeyValue)super.next();
        }

        @Override
        public KeyValue<Bytes, byte[]> makeNext() {
            if (this.nextNoTimestamp == null && this.iterNoTimestamp.isValid()) {
                this.nextNoTimestamp = this.iterNoTimestamp.key();
            }
            if (this.nextWithTimestamp == null && this.iterWithTimestamp.isValid()) {
                this.nextWithTimestamp = this.iterWithTimestamp.key();
            }
            if (this.nextNoTimestamp == null && !this.iterNoTimestamp.isValid()) {
                if (this.nextWithTimestamp == null && !this.iterWithTimestamp.isValid()) {
                    return (KeyValue)this.allDone();
                }
                this.next = KeyValue.pair(new Bytes(this.nextWithTimestamp), this.iterWithTimestamp.value());
                this.nextWithTimestamp = null;
                this.iterWithTimestamp.next();
            } else if (this.nextWithTimestamp == null) {
                this.next = KeyValue.pair(new Bytes(this.nextNoTimestamp), StoreProxyUtils.getValueWithUnknownTimestamp(this.iterNoTimestamp.value()));
                this.nextNoTimestamp = null;
                this.iterNoTimestamp.next();
            } else if (this.comparator.compare(this.nextNoTimestamp, this.nextWithTimestamp) <= 0) {
                this.next = KeyValue.pair(new Bytes(this.nextNoTimestamp), StoreProxyUtils.getValueWithUnknownTimestamp(this.iterNoTimestamp.value()));
                this.nextNoTimestamp = null;
                this.iterNoTimestamp.next();
            } else {
                this.next = KeyValue.pair(new Bytes(this.nextWithTimestamp), this.iterWithTimestamp.value());
                this.nextWithTimestamp = null;
                this.iterWithTimestamp.next();
            }
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("RocksDB iterator does not support remove()");
        }

        @Override
        public synchronized void close() {
            RocksDBTimestampedStore.this.openIterators.remove(this);
            this.iterNoTimestamp.close();
            this.iterWithTimestamp.close();
            this.open = false;
        }

        @Override
        public Bytes peekNextKey() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (Bytes)this.next.key;
        }
    }

    private class DualColumnFamilyAccessor
    implements RocksDBStore.RocksDBAccessor {
        private final ColumnFamilyHandle oldColumnFamily;
        private final ColumnFamilyHandle newColumnFamily;

        private DualColumnFamilyAccessor(ColumnFamilyHandle oldColumnFamily, ColumnFamilyHandle newColumnFamily) {
            this.oldColumnFamily = oldColumnFamily;
            this.newColumnFamily = newColumnFamily;
        }

        @Override
        public void put(byte[] key, byte[] valueWithTimestamp) {
            if (valueWithTimestamp == null) {
                try {
                    RocksDBTimestampedStore.this.db.delete(this.oldColumnFamily, RocksDBTimestampedStore.this.wOptions, key);
                }
                catch (RocksDBException e) {
                    throw new ProcessorStateException("Error while removing key from store " + RocksDBTimestampedStore.this.name, e);
                }
                try {
                    RocksDBTimestampedStore.this.db.delete(this.newColumnFamily, RocksDBTimestampedStore.this.wOptions, key);
                }
                catch (RocksDBException e) {
                    throw new ProcessorStateException("Error while removing key from store " + RocksDBTimestampedStore.this.name, e);
                }
            }
            try {
                RocksDBTimestampedStore.this.db.delete(this.oldColumnFamily, RocksDBTimestampedStore.this.wOptions, key);
            }
            catch (RocksDBException e) {
                throw new ProcessorStateException("Error while removing key from store " + RocksDBTimestampedStore.this.name, e);
            }
            try {
                RocksDBTimestampedStore.this.db.put(this.newColumnFamily, RocksDBTimestampedStore.this.wOptions, key, valueWithTimestamp);
            }
            catch (RocksDBException e) {
                throw new ProcessorStateException("Error while putting key/value into store " + RocksDBTimestampedStore.this.name, e);
            }
        }

        @Override
        public void prepareBatch(List<KeyValue<Bytes, byte[]>> entries, WriteBatch batch) throws RocksDBException {
            for (KeyValue<Bytes, byte[]> entry : entries) {
                Objects.requireNonNull(entry.key, "key cannot be null");
                if (entry.value == null) {
                    batch.delete(this.oldColumnFamily, ((Bytes)entry.key).get());
                    batch.delete(this.newColumnFamily, ((Bytes)entry.key).get());
                    continue;
                }
                batch.delete(this.oldColumnFamily, ((Bytes)entry.key).get());
                batch.put(this.newColumnFamily, ((Bytes)entry.key).get(), (byte[])entry.value);
            }
        }

        @Override
        public byte[] get(byte[] key) throws RocksDBException {
            byte[] valueWithTimestamp = RocksDBTimestampedStore.this.db.get(this.newColumnFamily, key);
            if (valueWithTimestamp != null) {
                return valueWithTimestamp;
            }
            byte[] plainValue = RocksDBTimestampedStore.this.db.get(this.oldColumnFamily, key);
            if (plainValue != null) {
                byte[] valueWithUnknownTimestamp = StoreProxyUtils.getValueWithUnknownTimestamp(plainValue);
                this.put(key, valueWithUnknownTimestamp);
                return valueWithUnknownTimestamp;
            }
            return null;
        }

        @Override
        public byte[] getOnly(byte[] key) throws RocksDBException {
            byte[] valueWithTimestamp = RocksDBTimestampedStore.this.db.get(this.newColumnFamily, key);
            if (valueWithTimestamp != null) {
                return valueWithTimestamp;
            }
            byte[] plainValue = RocksDBTimestampedStore.this.db.get(this.oldColumnFamily, key);
            if (plainValue != null) {
                return StoreProxyUtils.getValueWithUnknownTimestamp(plainValue);
            }
            return null;
        }

        @Override
        public KeyValueIterator<Bytes, byte[]> range(Bytes from, Bytes to) {
            return new RocksDBDualCFRangeIterator(RocksDBTimestampedStore.this.name, RocksDBTimestampedStore.this.db.newIterator(this.newColumnFamily), RocksDBTimestampedStore.this.db.newIterator(this.oldColumnFamily), from, to);
        }

        @Override
        public KeyValueIterator<Bytes, byte[]> all() {
            RocksIterator innerIterWithTimestamp = RocksDBTimestampedStore.this.db.newIterator(this.newColumnFamily);
            innerIterWithTimestamp.seekToFirst();
            RocksIterator innerIterNoTimestamp = RocksDBTimestampedStore.this.db.newIterator(this.oldColumnFamily);
            innerIterNoTimestamp.seekToFirst();
            return new RocksDBDualCFIterator(RocksDBTimestampedStore.this.name, innerIterWithTimestamp, innerIterNoTimestamp);
        }

        @Override
        public long approximateNumEntries() throws RocksDBException {
            return RocksDBTimestampedStore.this.db.getLongProperty(this.oldColumnFamily, "rocksdb.estimate-num-keys") + RocksDBTimestampedStore.this.db.getLongProperty(this.newColumnFamily, "rocksdb.estimate-num-keys");
        }

        @Override
        public void flush() throws RocksDBException {
            RocksDBTimestampedStore.this.db.flush(RocksDBTimestampedStore.this.fOptions, this.oldColumnFamily);
            RocksDBTimestampedStore.this.db.flush(RocksDBTimestampedStore.this.fOptions, this.newColumnFamily);
        }

        @Override
        public void prepareBatchForRestore(Collection<KeyValue<byte[], byte[]>> records, WriteBatch batch) throws RocksDBException {
            for (KeyValue<byte[], byte[]> record : records) {
                if (record.value == null) {
                    batch.delete(this.oldColumnFamily, (byte[])record.key);
                    batch.delete(this.newColumnFamily, (byte[])record.key);
                    continue;
                }
                batch.delete(this.oldColumnFamily, (byte[])record.key);
                batch.put(this.newColumnFamily, (byte[])record.key, (byte[])record.value);
            }
        }

        @Override
        public void close() {
            this.oldColumnFamily.close();
            this.newColumnFamily.close();
        }

        @Override
        public void toggleDbForBulkLoading() {
            try {
                RocksDBTimestampedStore.this.db.compactRange(this.oldColumnFamily, true, 1, 0);
            }
            catch (RocksDBException e) {
                throw new ProcessorStateException("Error while range compacting during restoring  store " + RocksDBTimestampedStore.this.name, e);
            }
            try {
                RocksDBTimestampedStore.this.db.compactRange(this.newColumnFamily, true, 1, 0);
            }
            catch (RocksDBException e) {
                throw new ProcessorStateException("Error while range compacting during restoring  store " + RocksDBTimestampedStore.this.name, e);
            }
        }
    }
}

