/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.logprocessor.eventduration;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;

public class DateParser {
    public static final DateTimeFormatter DEFAULT_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss.SSSXXX").withZone(ZoneId.systemDefault());

    public static Instant parseTime(String time) {
        DateTimeFormatter[] formatters;
        for (DateTimeFormatter formatter : formatters = new DateTimeFormatter[]{DEFAULT_DATE_TIME_FORMATTER, DateTimeFormatter.ISO_INSTANT, DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss.SSSZ").withZone(ZoneId.systemDefault())}) {
            try {
                TemporalAccessor accessor2 = formatter.parse(time);
                return Instant.from(accessor2);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        throw new DateTimeException("Invalid input datetime format [" + time + "]");
    }
}

