/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.logprocessor.eventduration;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import javax.enterprise.context.ApplicationScoped;
import org.apache.kafka.streams.KafkaStreams;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;
import org.jboss.pnc.logprocessor.eventduration.Application;

@ApplicationScoped
public class InContainerBoot {
    @ConfigProperty(name="kafkaPropertiesPath")
    String kafkaPropertiesPath;
    @ConfigProperty(name="inputTopicName")
    String inputTopicName;
    @ConfigProperty(name="outputTopicName")
    String outputTopicName;
    @ConfigProperty(name="durationsTopicName")
    Optional<String> durationsTopicName;
    Logger logger = Logger.getLogger(InContainerBoot.class);
    private Application application;

    public void init() throws IOException {
        Properties kafkaProperties = new Properties();
        try (FileInputStream kafkaPropertiesStream = new FileInputStream(this.kafkaPropertiesPath);){
            kafkaProperties.load(kafkaPropertiesStream);
        }
        catch (IOException e) {
            this.logger.error((Object)"Cannot read Kafka.properties", e);
            throw e;
        }
        this.application = new Application(kafkaProperties, this.inputTopicName, this.outputTopicName, this.durationsTopicName);
        this.application.start();
    }

    public KafkaStreams.State getStreamState() {
        return this.application.getStreamState();
    }

    public void destroy() {
        this.application.stop();
    }
}

