/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.logprocessor.eventduration;

import java.time.Duration;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Transformer;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.KeyValueStore;
import org.jboss.pnc.logprocessor.eventduration.domain.LogEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MergeTransformer
implements Transformer<String, LogEvent, KeyValue<String, LogEvent>> {
    private static final Logger logger = LoggerFactory.getLogger(MergeTransformer.class);
    private KeyValueStore<String, LogEvent> store;
    private ProcessorContext context;

    MergeTransformer() {
    }

    @Override
    public void init(ProcessorContext context) {
        this.context = context;
        this.store = (KeyValueStore)context.getStateStore("log-store");
    }

    @Override
    public KeyValue<String, LogEvent> transform(String key, LogEvent thisLogEvent) {
        if (thisLogEvent == null) {
            return null;
        }
        if (thisLogEvent.getEventType().isEmpty()) {
            return new KeyValue<String, LogEvent>(key, thisLogEvent);
        }
        String identifier = thisLogEvent.getIdentifier();
        LogEvent firstLogEvent = this.store.delete(identifier);
        if (firstLogEvent != null) {
            logger.debug("Found matching entry by identifier {}.", (Object)identifier);
            Duration duration = Duration.between(firstLogEvent.getTime(), thisLogEvent.getTime()).abs();
            if (firstLogEvent.getEventType().get().equals((Object)LogEvent.EventType.BEGIN)) {
                thisLogEvent.addDuration(duration);
                return new KeyValue<String, LogEvent>(key, thisLogEvent);
            }
            firstLogEvent.addDuration(duration);
            this.context.forward(key, thisLogEvent);
            return new KeyValue<String, LogEvent>(firstLogEvent.getKafkaKey(), firstLogEvent);
        }
        thisLogEvent.setKafkaKey(key);
        logger.debug("Storing entry with identifier {} and key {}.", (Object)identifier, (Object)key);
        this.store.put(identifier, thisLogEvent);
        if (thisLogEvent.getEventType().get().equals((Object)LogEvent.EventType.BEGIN)) {
            return new KeyValue<String, LogEvent>(key, thisLogEvent);
        }
        return null;
    }

    @Override
    public void close() {
    }
}

