/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.logprocessor.eventduration.domain;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.jboss.pnc.logprocessor.eventduration.DateParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogEvent {
    private static final Logger logger = LoggerFactory.getLogger(LogEvent.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    public static final String MDC_KEY = "mdc";
    public static final String MDC_PROCESS_CONTEXT_KEY = "processContext";
    public static final String MDC_EVENT_NAME_KEY = "process_stage_name";
    public static final String MDC_EVENT_TYPE_KEY = "process_stage_step";
    public static final String TIMESTAMP_KEY = "@timestamp";
    public static final String MESSAGE_KEY = "message";
    public static final String DURATION_KEY = "operationTook";
    public static final String KAFKA_KEY = "kafkaKey";
    private Instant time;
    private Map<String, Object> message;

    public String getIdentifier() {
        Map mdc = (Map)this.message.get(MDC_KEY);
        if (mdc != null) {
            String processContext = (String)mdc.get(MDC_PROCESS_CONTEXT_KEY);
            String eventName = (String)mdc.get(MDC_EVENT_NAME_KEY);
            if (processContext == null || processContext.equals("")) {
                logger.warn("Missing processContext for event {}.", (Object)eventName);
            }
            return processContext + "--" + eventName;
        }
        return "";
    }

    public Instant getTime() {
        return this.time;
    }

    public Map<String, Object> getMessage() {
        return this.message;
    }

    public String getKafkaKey() {
        return (String)this.message.get(KAFKA_KEY);
    }

    public void setKafkaKey(String key) {
        this.message.put(KAFKA_KEY, key);
    }

    public LogEvent(byte[] serialized) {
        JsonNode jsonNode = null;
        try {
            jsonNode = objectMapper.readTree(serialized);
        }
        catch (IOException e) {
            throw new SerializationException("Cannot construct object from serialized bytes.", e);
        }
        this.init(jsonNode);
    }

    public LogEvent(String serializedLogEvent) {
        JsonNode jsonNode = null;
        try {
            jsonNode = objectMapper.readTree(serializedLogEvent);
        }
        catch (IOException e) {
            throw new SerializationException("Cannot construct object from serialized string.", e);
        }
        this.init(jsonNode);
    }

    private void init(JsonNode jsonNode) {
        this.message = (Map)objectMapper.convertValue((Object)jsonNode, new TypeReference<Map<String, Object>>(){});
        logger.trace("New log event {}.", (Object)this.message);
        String time = (String)this.message.get(TIMESTAMP_KEY);
        this.time = DateParser.parseTime(time);
    }

    public void addDuration(Duration duration) {
        String logMessage = (String)this.message.get(MESSAGE_KEY);
        long durationMillis = duration.toMillis();
        this.message.put(MESSAGE_KEY, logMessage + " Took " + durationMillis + "ms.");
        this.message.put(DURATION_KEY, durationMillis);
    }

    public Optional<EventType> getEventType() {
        Map mdc = (Map)this.message.get(MDC_KEY);
        if (mdc != null) {
            String eventType = (String)mdc.get(MDC_EVENT_TYPE_KEY);
            if (eventType != null) {
                return Optional.of(EventType.valueOf(eventType));
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public static class JsonDeserializer
    implements Deserializer<LogEvent> {
        @Override
        public void configure(Map<String, ?> configs, boolean isKey) {
        }

        @Override
        public LogEvent deserialize(String topic, byte[] bytes) {
            LogEvent data;
            if (bytes == null || bytes.length == 0) {
                return null;
            }
            try {
                data = new LogEvent(bytes);
            }
            catch (Exception e) {
                throw new SerializationException(e);
            }
            return data;
        }

        @Override
        public void close() {
        }
    }

    public static class JsonSerializer
    implements Serializer<LogEvent> {
        @Override
        public void configure(Map<String, ?> configs, boolean isKey) {
        }

        @Override
        public byte[] serialize(String topic, LogEvent logEvent) {
            if (logEvent == null) {
                return null;
            }
            try {
                return objectMapper.writeValueAsBytes(logEvent.message);
            }
            catch (Exception e) {
                throw new SerializationException("Error serializing JSON message", e);
            }
        }

        @Override
        public void close() {
        }
    }

    public static enum EventType {
        BEGIN,
        END;

    }
}

