package org.jboss.pnc.client;

import java.lang.Boolean;
import java.lang.String;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import org.jboss.pnc.dto.response.Banner;
import org.jboss.pnc.rest.api.endpoints.GenericSettingEndpoint;

public class GenericSettingClient extends ClientBase<GenericSettingEndpoint> {
  public GenericSettingClient(Configuration configuration) {
    super(configuration, GenericSettingEndpoint.class);
  }

  public Banner getAnnouncementBanner() throws RemoteResourceException {
    try {
      return getEndpoint().getAnnouncementBanner();
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setToken(configuration.getBearerTokenSupplier().get());
          return getEndpoint().getAnnouncementBanner();
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public void setAnnouncementBanner(String banner) throws RemoteResourceException,
      RemoteResourceNotFoundException {
    try {
      getEndpoint().setAnnouncementBanner(banner);
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setToken(configuration.getBearerTokenSupplier().get());
          getEndpoint().setAnnouncementBanner(banner);
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public Boolean isInMaintenanceMode() throws RemoteResourceException {
    try {
      return getEndpoint().isInMaintenanceMode();
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setToken(configuration.getBearerTokenSupplier().get());
          return getEndpoint().isInMaintenanceMode();
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public void activateMaintenanceMode(String reason) throws RemoteResourceException,
      RemoteResourceNotFoundException {
    try {
      getEndpoint().activateMaintenanceMode(reason);
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setToken(configuration.getBearerTokenSupplier().get());
          getEndpoint().activateMaintenanceMode(reason);
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public void deactivateMaintenanceMode() throws RemoteResourceException,
      RemoteResourceNotFoundException {
    try {
      getEndpoint().deactivateMaintenanceMode();
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setToken(configuration.getBearerTokenSupplier().get());
          getEndpoint().deactivateMaintenanceMode();
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }
}
