package org.jboss.pnc.client;

import java.lang.String;
import java.util.Set;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import org.jboss.pnc.dto.ProductRelease;
import org.jboss.pnc.enums.SupportLevel;
import org.jboss.pnc.rest.api.endpoints.ProductReleaseEndpoint;

public class ProductReleaseClient extends ClientBase<ProductReleaseEndpoint> {
  public ProductReleaseClient(Configuration configuration) {
    super(configuration, ProductReleaseEndpoint.class);
  }

  public ProductRelease createNew(ProductRelease productRelease) throws RemoteResourceException {
    try {
      return getEndpoint().createNew(productRelease);
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setToken(configuration.getBearerTokenSupplier().get());
          return getEndpoint().createNew(productRelease);
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public ProductRelease getSpecific(String id) throws RemoteResourceException {
    try {
      return getEndpoint().getSpecific(id);
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setToken(configuration.getBearerTokenSupplier().get());
          return getEndpoint().getSpecific(id);
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public void update(String id, ProductRelease productRelease) throws RemoteResourceException,
      RemoteResourceNotFoundException {
    try {
      getEndpoint().update(id, productRelease);
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setToken(configuration.getBearerTokenSupplier().get());
          getEndpoint().update(id, productRelease);
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }

  public Set<SupportLevel> getSupportLevels() throws RemoteResourceException {
    try {
      return getEndpoint().getSupportLevels();
    } catch (NotFoundException e) {
      throw new RemoteResourceNotFoundException(e);
    } catch (NotAuthorizedException e) {
      if (configuration.getBearerTokenSupplier() != null) {
        try {
          bearerAuthentication.setToken(configuration.getBearerTokenSupplier().get());
          return getEndpoint().getSupportLevels();
        } catch (WebApplicationException wae) {
          throw new RemoteResourceException(readErrorResponse(wae), wae);
        }
      } else {
        throw new RemoteResourceException(readErrorResponse(e), e);
      }
    } catch (WebApplicationException e) {
      throw new RemoteResourceException(readErrorResponse(e), e);
    }
  }
}
