/**
 * JBoss, Home of Professional Open Source.
 * Copyright 2014-2020 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.pnc.rest.api.parameters;

import javax.ws.rs.DefaultValue;
import javax.ws.rs.QueryParam;

import io.swagger.v3.oas.annotations.Parameter;
import lombok.Data;
import org.jboss.pnc.enums.RebuildMode;
import org.jboss.pnc.rest.configuration.SwaggerConstants;

/**
 * This class represents a set of options of how a build should be executed.
 * 
 * @author Honza Brázdil &lt;jbrazdil@redhat.com&gt;
 */
@Data
public class BuildParameters {

    /**
     * {@value SwaggerConstants#TEMPORARY_BUILD_DESC} Defaults to false.
     */
    @Parameter(description = SwaggerConstants.TEMPORARY_BUILD_DESC)
    @QueryParam("temporaryBuild")
    @DefaultValue("false")
    boolean temporaryBuild;

    /**
     * {@value SwaggerConstants#REBUILD_MODE_DESC} Defaults to {@value SwaggerConstants#DEFAULT_REBUILD_MODE}.
     * 
     * @see org.jboss.pnc.enums.RebuildMode
     */
    @Parameter(description = SwaggerConstants.REBUILD_MODE_DESC)
    @QueryParam("rebuildMode")
    @DefaultValue(SwaggerConstants.DEFAULT_REBUILD_MODE)
    RebuildMode rebuildMode;

    /**
     * {@value SwaggerConstants#BUILD_DEPENDENCIES_DESC} Defaults to true.
     */
    @Parameter(description = SwaggerConstants.BUILD_DEPENDENCIES_DESC)
    @QueryParam("buildDependencies")
    @DefaultValue("true")
    boolean buildDependencies;

    /**
     * {@value SwaggerConstants#KEEP_POD_ON_FAIL_DESC} Defaults to false.
     */
    @Parameter(description = SwaggerConstants.KEEP_POD_ON_FAIL_DESC)
    @QueryParam("keepPodOnFailure")
    @DefaultValue("false")
    boolean keepPodOnFailure;

    /**
     * {@value SwaggerConstants#TIMESTAMP_ALIGNMENT_DESC} Defaults to false.
     */
    @Parameter(description = SwaggerConstants.TIMESTAMP_ALIGNMENT_DESC)
    @QueryParam("timestampAlignment")
    @DefaultValue("false")
    boolean timestampAlignment;
}
