/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.cache.server;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import org.infinispan.Cache;
import org.jboss.resteasy.plugins.cache.server.HeaderHolder;
import org.jboss.resteasy.plugins.cache.server.ServerCache;
import org.jboss.resteasy.specimpl.MultivaluedTreeMap;

public class InfinispanCache
implements ServerCache {
    protected Cache cache;

    public InfinispanCache(Cache cache) {
        this.cache = cache;
    }

    @Override
    public ServerCache.Entry get(String uri, MediaType accept) {
        Set entries = (Set)this.cache.get((Object)uri);
        if (entries == null) {
            return null;
        }
        for (String entry : entries) {
            CacheEntry cacheEntry = (CacheEntry)this.cache.get((Object)entry);
            if (cacheEntry == null || !accept.isCompatible(cacheEntry.getMediaType())) continue;
            return cacheEntry;
        }
        return null;
    }

    @Override
    public ServerCache.Entry add(String uri, MediaType mediaType, CacheControl cc, MultivaluedMap<String, Object> headers, byte[] entity, String etag) {
        CacheEntry cacheEntry = new CacheEntry(headers, entity, cc.getMaxAge(), etag, mediaType);
        String entryName = uri + "    " + mediaType.toString();
        Set entries = (Set)this.cache.get((Object)uri);
        HashSet<String> newEntries = new HashSet<String>();
        newEntries.add(entryName);
        if (entries != null) {
            newEntries.addAll(entries);
        }
        this.cache.put((Object)uri, newEntries);
        this.cache.put((Object)entryName, (Object)cacheEntry, (long)cc.getMaxAge(), TimeUnit.SECONDS);
        return cacheEntry;
    }

    @Override
    public void remove(String uri) {
        Set entries = (Set)this.cache.remove((Object)uri);
        if (entries == null) {
            return;
        }
        for (String entry : entries) {
            this.cache.remove((Object)entry);
        }
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    protected static MultivaluedMap<String, Object> stringifyHeaders(MultivaluedMap<String, Object> headers) {
        MultivaluedTreeMap holders = new MultivaluedTreeMap();
        for (String key : headers.keySet()) {
            ArrayList<HeaderHolder> outList = new ArrayList<HeaderHolder>();
            holders.put((Object)key, outList);
            List list = (List)headers.get((Object)key);
            for (Object o : list) {
                if (o instanceof CacheControl) {
                    outList.add(new HeaderHolder(HeaderHolder.Type.CACHE_CONTROL, ((CacheControl)CacheControl.class.cast(o)).toString()));
                    continue;
                }
                if (o instanceof Cookie) {
                    outList.add(new HeaderHolder(HeaderHolder.Type.COOKIE, ((Cookie)Cookie.class.cast(o)).toString()));
                    continue;
                }
                if (o instanceof EntityTag) {
                    outList.add(new HeaderHolder(HeaderHolder.Type.ENTITY_TAG, ((EntityTag)EntityTag.class.cast(o)).toString()));
                    continue;
                }
                if (o instanceof NewCookie) {
                    outList.add(new HeaderHolder(HeaderHolder.Type.NEW_COOKIE, ((NewCookie)NewCookie.class.cast(o)).toString()));
                    continue;
                }
                outList.add(new HeaderHolder(HeaderHolder.Type.OTHER, o.toString()));
            }
        }
        return holders;
    }

    protected static MultivaluedMap<String, Object> unstringifyHeaders(MultivaluedMap<String, Object> headers) {
        MultivaluedTreeMap holders = new MultivaluedTreeMap();
        for (String key : headers.keySet()) {
            ArrayList<Object> outList = new ArrayList<Object>();
            holders.put((Object)key, outList);
            List list = (List)headers.get((Object)key);
            Iterator it2 = list.iterator();
            while (it2.hasNext()) {
                HeaderHolder holder = (HeaderHolder)HeaderHolder.class.cast(it2.next());
                if (HeaderHolder.Type.CACHE_CONTROL.equals((Object)holder.getType())) {
                    outList.add(CacheControl.valueOf((String)holder.getValue()));
                    continue;
                }
                if (HeaderHolder.Type.COOKIE.equals((Object)holder.getType())) {
                    outList.add(Cookie.valueOf((String)holder.getValue()));
                    continue;
                }
                if (HeaderHolder.Type.ENTITY_TAG.equals((Object)holder.getType())) {
                    outList.add(EntityTag.valueOf((String)holder.getValue()));
                    continue;
                }
                if (HeaderHolder.Type.NEW_COOKIE.equals((Object)holder.getType())) {
                    outList.add(NewCookie.valueOf((String)holder.getValue()));
                    continue;
                }
                outList.add(holder.getValue());
            }
        }
        return holders;
    }

    public static class CacheEntry
    implements ServerCache.Entry,
    Serializable {
        private static final long serialVersionUID = 2848638331930090578L;
        private byte[] cached;
        private int expires;
        private long timestamp = System.currentTimeMillis();
        private String etag;
        private transient MultivaluedMap<String, Object> headers;
        private transient MediaType mediaType;

        private CacheEntry(MultivaluedMap<String, Object> headers, byte[] cached, int expires, String etag, MediaType mediaType) {
            this.cached = cached;
            this.expires = expires;
            this.headers = headers;
            this.etag = etag;
            this.mediaType = mediaType;
        }

        @Override
        public int getExpirationInSeconds() {
            return this.expires - (int)((System.currentTimeMillis() - this.timestamp) / 1000L);
        }

        @Override
        public boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp >= (long)this.expires * 1000L;
        }

        @Override
        public String getEtag() {
            return this.etag;
        }

        @Override
        public MultivaluedMap<String, Object> getHeaders() {
            return this.headers;
        }

        @Override
        public byte[] getCached() {
            return this.cached;
        }

        public MediaType getMediaType() {
            return this.mediaType;
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
            stream.writeObject(InfinispanCache.stringifyHeaders(this.headers));
            stream.writeUTF(this.mediaType.toString());
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.headers = InfinispanCache.unstringifyHeaders((MultivaluedMap<String, Object>)((MultivaluedMap)MultivaluedMap.class.cast(stream.readObject())));
            this.mediaType = MediaType.valueOf((String)stream.readUTF());
        }
    }
}

