/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.cache.server;

import java.io.IOException;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;
import org.infinispan.manager.DefaultCacheManager;
import org.jboss.resteasy.plugins.cache.server.InfinispanCache;
import org.jboss.resteasy.plugins.cache.server.ServerCache;
import org.jboss.resteasy.plugins.cache.server.ServerCacheHitFilter;
import org.jboss.resteasy.plugins.cache.server.ServerCacheInterceptor;
import org.jboss.resteasy.plugins.cache.server.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyConfiguration;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class ServerCacheFeature
implements Feature {
    protected ServerCache cache;

    public ServerCacheFeature() {
    }

    public ServerCacheFeature(ServerCache cache) {
        this.cache = cache;
    }

    public boolean configure(FeatureContext configurable) {
        ServerCache cache = this.getCache((Configurable)configurable);
        if (cache == null) {
            return false;
        }
        configurable.register((Object)new ServerCacheHitFilter(cache));
        configurable.register((Object)new ServerCacheInterceptor(cache));
        return true;
    }

    protected ResteasyConfiguration getResteasyConfiguration() {
        return (ResteasyConfiguration)ResteasyProviderFactory.getContextData(ResteasyConfiguration.class);
    }

    protected String getConfigProperty(String name) {
        ResteasyConfiguration config = this.getResteasyConfiguration();
        if (config == null) {
            return null;
        }
        return config.getParameter(name);
    }

    protected ServerCache getCache(Configurable configurable) {
        if (this.cache != null) {
            return this.cache;
        }
        ServerCache c = (ServerCache)configurable.getConfiguration().getProperty(ServerCache.class.getName());
        if (c != null) {
            return c;
        }
        c = this.getXmlCache(configurable);
        if (c != null) {
            return c;
        }
        return this.getDefaultCache();
    }

    protected ServerCache getDefaultCache() {
        GlobalConfiguration gconfig = new GlobalConfigurationBuilder().defaultCacheName("resteasy-default-cache").jmx().enable().build();
        Configuration configuration = new ConfigurationBuilder().memory().evictionType(EvictionType.COUNT).evictionStrategy(EvictionStrategy.REMOVE).size(100L).build();
        DefaultCacheManager manager = new DefaultCacheManager(gconfig, configuration);
        Cache c = manager.getCache("resteasy-default-cache");
        return new InfinispanCache(c);
    }

    protected ServerCache getXmlCache(Configurable configurable) {
        String path = (String)configurable.getConfiguration().getProperty("server.request.cache.infinispan.config.file");
        if (path == null) {
            path = this.getConfigProperty("server.request.cache.infinispan.config.file");
        }
        if (path == null) {
            return null;
        }
        String name = (String)configurable.getConfiguration().getProperty("server.request.cache.infinispan.cache.name");
        if (name == null) {
            name = this.getConfigProperty("server.request.cache.infinispan.cache.name");
        }
        if (name == null) {
            throw new RuntimeException(Messages.MESSAGES.needToSpecifyCacheName());
        }
        try {
            Cache c = new DefaultCacheManager(path).getCache(name);
            return new InfinispanCache(c);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

