/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.cache.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.concurrent.CompletionStage;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.jboss.resteasy.plugins.cache.server.ServerCache;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.jboss.resteasy.spi.AsyncWriterInterceptor;
import org.jboss.resteasy.spi.AsyncWriterInterceptorContext;
import org.jboss.resteasy.spi.BlockingAsyncOutputStream;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.NoLogWebApplicationException;

@ConstrainedTo(value=RuntimeType.SERVER)
public class ServerCacheInterceptor
implements WriterInterceptor,
AsyncWriterInterceptor {
    protected ServerCache cache;
    @Context
    protected HttpRequest request;
    @Context
    protected Request validation;
    private static final String[] pseudo = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};

    public ServerCacheInterceptor(ServerCache cache) {
        this.cache = cache;
    }

    public static String byteArrayToHexString(byte[] bytes) {
        byte ch = 0;
        StringBuffer out = new StringBuffer(bytes.length * 2);
        for (byte b : bytes) {
            ch = (byte)(b & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(pseudo[ch]);
            ch = (byte)(b & 0xF);
            out.append(pseudo[ch]);
        }
        String rslt = new String(out);
        return rslt;
    }

    protected String createHash(byte[] entity) {
        try {
            MessageDigest messagedigest = MessageDigest.getInstance("MD5");
            byte[] abyte0 = messagedigest.digest(entity);
            return ServerCacheInterceptor.byteArrayToHexString(abyte0);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private CacheControl getCacheControl(MultivaluedMap<String, Object> headers) {
        if (!this.request.getHttpMethod().equalsIgnoreCase("GET") || this.request.getAttribute("DO NOT CACHE RESPONSE") != null) {
            return null;
        }
        Object occ = headers.getFirst((Object)"Cache-Control");
        if (occ == null) {
            return null;
        }
        CacheControl cc = null;
        cc = occ instanceof CacheControl ? (CacheControl)occ : CacheControl.valueOf((String)occ.toString());
        if (cc.isNoCache()) {
            return null;
        }
        return cc;
    }

    private byte[] handleCaching(ByteArrayOutputStream buffer, CacheControl cc, MultivaluedMap<String, Object> headers, MediaType mediaType) {
        Response.ResponseBuilder validatedResponse;
        byte[] entity = buffer.toByteArray();
        Object etagObject = headers.getFirst((Object)"ETag");
        String etag = null;
        if (etagObject == null) {
            etag = this.createHash(entity);
            headers.putSingle((Object)"ETag", (Object)etag);
        } else {
            etag = etagObject.toString();
        }
        if (!cc.isPrivate() && !cc.isNoStore()) {
            MultivaluedHashMap varyHeaders = new MultivaluedHashMap();
            if (headers.containsKey((Object)"Vary")) {
                for (Object varyHeader : (List)headers.get((Object)"Vary")) {
                    if (!this.request.getMutableHeaders().containsKey(varyHeader)) continue;
                    varyHeaders.addAll((Object)((String)varyHeader), (List)this.request.getMutableHeaders().get(varyHeader));
                }
            }
            this.cache.add(this.request.getUri().getRequestUri().toString(), mediaType, cc, headers, entity, etag, (MultivaluedMap<String, String>)varyHeaders);
        }
        if ((validatedResponse = this.validation.evaluatePreconditions(new EntityTag(etag))) != null) {
            throw new NoLogWebApplicationException(validatedResponse.status(Response.Status.NOT_MODIFIED).cacheControl(cc).header("ETag", (Object)etag).build());
        }
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        LogMessages.LOGGER.debugf("Interceptor : %s,  Method : aroundWriteTo", (Object)this.getClass().getName());
        CacheControl cc = this.getCacheControl((MultivaluedMap<String, Object>)context.getHeaders());
        if (cc == null) {
            context.proceed();
            return;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        OutputStream old = context.getOutputStream();
        try {
            context.setOutputStream((OutputStream)buffer);
            context.proceed();
            byte[] entity = this.handleCaching(buffer, cc, (MultivaluedMap<String, Object>)context.getHeaders(), context.getMediaType());
            old.write(entity);
        }
        finally {
            context.setOutputStream(old);
        }
    }

    public CompletionStage<Void> asyncAroundWriteTo(AsyncWriterInterceptorContext context) {
        LogMessages.LOGGER.debugf("Interceptor : %s,  Method : aroundWriteTo", (Object)this.getClass().getName());
        CacheControl cc = this.getCacheControl((MultivaluedMap<String, Object>)context.getHeaders());
        if (cc == null) {
            return context.asyncProceed();
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        AsyncOutputStream old = context.getAsyncOutputStream();
        context.setAsyncOutputStream((AsyncOutputStream)new BlockingAsyncOutputStream((OutputStream)buffer));
        return context.asyncProceed().thenCompose(v -> {
            byte[] entity = this.handleCaching(buffer, cc, (MultivaluedMap<String, Object>)context.getHeaders(), context.getMediaType());
            return old.asyncWrite(entity);
        }).whenComplete((v, t) -> context.setAsyncOutputStream(old));
    }
}

