/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.cache.server;

import java.io.IOException;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.MemoryConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.manager.DefaultCacheManager;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.plugins.cache.server.InfinispanCache;
import org.jboss.resteasy.plugins.cache.server.ServerCache;
import org.jboss.resteasy.plugins.cache.server.ServerCacheHitFilter;
import org.jboss.resteasy.plugins.cache.server.ServerCacheInterceptor;
import org.jboss.resteasy.plugins.cache.server.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyConfiguration;

public class ServerCacheFeature
implements Feature {
    protected ServerCache cache;

    public ServerCacheFeature() {
    }

    public ServerCacheFeature(ServerCache cache) {
        this.cache = cache;
    }

    public boolean configure(FeatureContext configurable) {
        ServerCache cache = this.getCache((Configurable)configurable);
        if (cache == null) {
            return false;
        }
        configurable.register((Object)new ServerCacheHitFilter(cache));
        configurable.register((Object)new ServerCacheInterceptor(cache));
        return true;
    }

    protected ResteasyConfiguration getResteasyConfiguration() {
        return (ResteasyConfiguration)ResteasyContext.getContextData(ResteasyConfiguration.class);
    }

    protected String getConfigProperty(String name) {
        ResteasyConfiguration config = this.getResteasyConfiguration();
        if (config == null) {
            return null;
        }
        return config.getParameter(name);
    }

    protected ServerCache getCache(Configurable configurable) {
        if (this.cache != null) {
            return this.cache;
        }
        ServerCache c = (ServerCache)configurable.getConfiguration().getProperty(ServerCache.class.getName());
        if (c != null) {
            return c;
        }
        c = this.getXmlCache(configurable);
        if (c != null) {
            return c;
        }
        return this.getDefaultCache();
    }

    protected ServerCache getDefaultCache() {
        String RESTEASY_DEFAULT_CACHE = "resteasy-default-cache";
        ConfigurationBuilderHolder configBuilderHolder = new ConfigurationBuilderHolder();
        configBuilderHolder.getGlobalConfigurationBuilder().defaultCacheName(RESTEASY_DEFAULT_CACHE).jmx().enable().build();
        configBuilderHolder.newConfigurationBuilder(RESTEASY_DEFAULT_CACHE).memory().maxCount(((Long)MemoryConfiguration.MAX_COUNT.getDefaultValue()).longValue()).whenFull(EvictionStrategy.REMOVE).maxCount(100L).build();
        DefaultCacheManager manager = new DefaultCacheManager(configBuilderHolder, true);
        Cache c = manager.getCache(RESTEASY_DEFAULT_CACHE);
        return new InfinispanCache(c);
    }

    protected ServerCache getXmlCache(Configurable configurable) {
        String path = (String)configurable.getConfiguration().getProperty("server.request.cache.infinispan.config.file");
        if (path == null) {
            path = this.getConfigProperty("server.request.cache.infinispan.config.file");
        }
        if (path == null) {
            return null;
        }
        String name = (String)configurable.getConfiguration().getProperty("server.request.cache.infinispan.cache.name");
        if (name == null) {
            name = this.getConfigProperty("server.request.cache.infinispan.cache.name");
        }
        if (name == null) {
            throw new RuntimeException(Messages.MESSAGES.needToSpecifyCacheName());
        }
        try {
            Cache c = new DefaultCacheManager(path).getCache(name);
            return new InfinispanCache(c);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

