/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.sun.http;

import com.sun.net.httpserver.Filter;
import com.sun.net.httpserver.HttpExchange;
import jakarta.ws.rs.core.SecurityContext;
import java.io.IOException;
import java.security.Principal;
import java.util.Base64;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.plugins.server.embedded.SecurityDomain;

public class BasicAuthFilter
extends Filter {
    protected SecurityDomain domain;

    public BasicAuthFilter(SecurityDomain domain) {
        this.domain = domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(HttpExchange exchange, Filter.Chain chain) throws IOException {
        String auth = exchange.getRequestHeaders().getFirst("Authorization");
        if (auth != null && auth.length() > 5) {
            String type = auth.substring(0, 5);
            if ("basic".equals(type = type.toLowerCase())) {
                String cookie = auth.substring(6);
                cookie = new String(Base64.getDecoder().decode(cookie.getBytes()));
                String[] split = cookie.split(":");
                Principal user = null;
                try {
                    user = this.domain.authenticate(split[0], split[1]);
                }
                catch (SecurityException e) {
                    exchange.sendResponseHeaders(401, -1L);
                    return;
                }
                final Principal finalUser = user;
                SecurityContext securityContext = new SecurityContext(){

                    public Principal getUserPrincipal() {
                        return finalUser;
                    }

                    public boolean isUserInRole(String role) {
                        return BasicAuthFilter.this.domain.isUserInRole(this.getUserPrincipal(), role);
                    }

                    public boolean isSecure() {
                        return true;
                    }

                    public String getAuthenticationScheme() {
                        return "BASIC";
                    }
                };
                try {
                    ResteasyContext.pushContext(SecurityContext.class, (Object)securityContext);
                    chain.doFilter(exchange);
                    return;
                }
                finally {
                    ResteasyContext.clearContextData();
                }
            }
        }
        exchange.sendResponseHeaders(401, -1L);
    }

    @Override
    public String description() {
        return "Basic Auth Filter";
    }
}

