/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.skeleton.key.servlet;

import java.io.IOException;
import java.net.URI;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.core.UriBuilder;
import org.jboss.resteasy.plugins.server.servlet.ServletUtil;
import org.jboss.resteasy.skeleton.key.AbstractOAuthClient;
import org.jboss.resteasy.skeleton.key.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyUriInfo;

public class ServletOAuthClient
extends AbstractOAuthClient {
    public void redirectRelative(String relativePath, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ResteasyUriInfo uriInfo = ServletUtil.extractUriInfo((HttpServletRequest)request, null);
        String redirect = uriInfo.getBaseUriBuilder().path(relativePath).toTemplate();
        this.redirect(redirect, request, response);
    }

    public void redirect(String redirectUri, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String state = this.getStateCode();
        URI url = UriBuilder.fromUri((String)this.authUrl).queryParam("client_id", new Object[]{this.clientId}).queryParam("redirect_uri", new Object[]{redirectUri}).queryParam("state", new Object[]{state}).build(new Object[0]);
        String cookiePath = request.getContextPath();
        if (cookiePath.equals("")) {
            cookiePath = "/";
        }
        Cookie cookie = new Cookie(this.stateCookieName, state);
        cookie.setSecure(true);
        cookie.setPath(cookiePath);
        response.addCookie(cookie);
        response.sendRedirect(url.toString());
    }

    protected String getCookieValue(String name, HttpServletRequest request) {
        if (request.getCookies() == null) {
            return null;
        }
        for (Cookie cookie : request.getCookies()) {
            if (!cookie.getName().equals(name)) continue;
            return cookie.getValue();
        }
        return null;
    }

    protected String getCode(HttpServletRequest request) {
        String[] params;
        String query = request.getQueryString();
        if (query == null) {
            return null;
        }
        for (String param : params = query.split("&")) {
            String name;
            int eq = param.indexOf(61);
            if (eq == -1 || !(name = param.substring(0, eq)).equals("code")) continue;
            return param.substring(eq + 1);
        }
        return null;
    }

    public String getBearerToken(HttpServletRequest request) throws BadRequestException, InternalServerErrorException {
        String error = request.getParameter("error");
        if (error != null) {
            throw new BadRequestException((Throwable)new Exception(Messages.MESSAGES.oAuthError(error)));
        }
        String redirectUri = request.getRequestURL().append("?").append(request.getQueryString()).toString();
        String stateCookie = this.getCookieValue(this.stateCookieName, request);
        if (stateCookie == null) {
            throw new BadRequestException((Throwable)new Exception(Messages.MESSAGES.stateCookieNotSet()));
        }
        String state = request.getParameter("state");
        String code = request.getParameter("code");
        if (state == null) {
            throw new BadRequestException((Throwable)new Exception(Messages.MESSAGES.stateParameterWasNull()));
        }
        if (!state.equals(stateCookie)) {
            throw new BadRequestException((Throwable)new Exception(Messages.MESSAGES.stateParameterInvalid()));
        }
        if (code == null) {
            throw new BadRequestException((Throwable)new Exception(Messages.MESSAGES.codeParameterWasNull()));
        }
        return this.resolveBearerToken(redirectUri, code);
    }
}

