/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.transaction.TransactionManager;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.test.persistence.util.PersistenceUtil;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.process.ProcessInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWorkingMemoryDbLoggerTest
extends AbstractBaseTest {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractWorkingMemoryDbLoggerTest.class);
    protected HashMap<String, Object> context;
    protected AuditLogService logService;

    @Before
    public void setUp() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource((String)"org.jbpm.persistence.jpa");
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("org.kie.api.persistence.jpa.EntityManagerFactory", this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory"));
        this.logService = new JPAAuditLogService(env);
    }

    @After
    public void tearDown() throws Exception {
        TransactionManager txm = com.arjuna.ats.jta.TransactionManager.transactionManager();
        Assert.assertTrue((String)"There is still a transaction running!", (txm.getTransaction() == null ? 1 : 0) != 0);
        PersistenceUtil.cleanUp(this.context);
        this.logService.dispose();
    }

    protected static KieBase createKnowledgeBase() {
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        InputStreamReader source = new InputStreamReader(AbstractWorkingMemoryDbLoggerTest.class.getResourceAsStream("/ruleflow.rf"));
        builder.addProcessFromXml((Reader)source);
        source = new InputStreamReader(AbstractWorkingMemoryDbLoggerTest.class.getResourceAsStream("/ruleflow2.rf"));
        builder.addProcessFromXml((Reader)source);
        source = new InputStreamReader(AbstractWorkingMemoryDbLoggerTest.class.getResourceAsStream("/ruleflow3.rf"));
        builder.addProcessFromXml((Reader)source);
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(Arrays.asList(builder.getPackages()));
        return kbase;
    }

    public abstract ProcessInstance startProcess(String var1);

    @Test
    public void testLogger1() {
        int i;
        long processInstanceId = this.startProcess("com.sample.ruleflow").getId();
        logger.debug("Checking process instances for process 'com.sample.ruleflow'");
        List processInstances = this.logService.findProcessInstances("com.sample.ruleflow");
        Assert.assertEquals((long)1L, (long)processInstances.size());
        ProcessInstanceLog processInstance = (ProcessInstanceLog)processInstances.get(0);
        logger.debug("{}", (Object)processInstance);
        Assert.assertNotNull((Object)processInstance.getStart());
        Assert.assertNotNull((Object)processInstance.getEnd());
        Assert.assertEquals((long)processInstanceId, (long)processInstance.getProcessInstanceId());
        Assert.assertEquals((Object)"com.sample.ruleflow", (Object)processInstance.getProcessId());
        List nodeInstances = this.logService.findNodeInstances(processInstanceId);
        Assert.assertEquals((long)6L, (long)nodeInstances.size());
        for (NodeInstanceLog nodeInstance : nodeInstances) {
            logger.debug("{}", (Object)nodeInstance);
            Assert.assertEquals((long)processInstanceId, (long)processInstance.getProcessInstanceId());
            Assert.assertEquals((Object)"com.sample.ruleflow", (Object)processInstance.getProcessId());
            Assert.assertNotNull((Object)nodeInstance.getDate());
        }
        for (i = 1; i < 4; i += 2) {
            Assert.assertTrue((boolean)((NodeInstanceLog)nodeInstances.get(i)).getConnection().equals(((NodeInstanceLog)nodeInstances.get(i + 1)).getNodeId()));
        }
        for (i = 2; i < 6; i += 2) {
            Assert.assertTrue((boolean)((NodeInstanceLog)nodeInstances.get(i)).getConnection().equals(((NodeInstanceLog)nodeInstances.get(i - 1)).getNodeId()));
        }
        this.assertRuleFlowSampleLogsSorting(nodeInstances, processInstanceId);
        this.logService.clear();
    }

    @Test
    public void testLogger2() {
        this.startProcess("com.sample.ruleflow");
        this.startProcess("com.sample.ruleflow");
        logger.debug("Checking process instances for process 'com.sample.ruleflow'");
        List processInstances = this.logService.findProcessInstances("com.sample.ruleflow");
        Assert.assertEquals((long)2L, (long)processInstances.size());
        for (ProcessInstanceLog processInstance : processInstances) {
            logger.debug("{}", (Object)processInstance);
            logger.debug(" -> {} - {}", (Object)processInstance.getStart(), (Object)processInstance.getEnd());
            List nodeInstances = this.logService.findNodeInstances(processInstance.getProcessInstanceId().longValue());
            for (NodeInstanceLog nodeInstance : nodeInstances) {
                logger.debug("{}", (Object)nodeInstance);
                logger.debug(" -> {}", (Object)nodeInstance.getDate());
            }
            Assert.assertEquals((long)6L, (long)nodeInstances.size());
            this.assertRuleFlowSampleLogsSorting(nodeInstances, processInstance.getProcessInstanceId());
        }
        this.logService.clear();
    }

    @Test
    public void testLogger3() {
        long processInstanceId = this.startProcess("com.sample.ruleflow2").getId();
        logger.debug("Checking process instances for process 'com.sample.ruleflow2'");
        List processInstances = this.logService.findProcessInstances("com.sample.ruleflow2");
        Assert.assertEquals((long)1L, (long)processInstances.size());
        ProcessInstanceLog processInstance = (ProcessInstanceLog)processInstances.get(0);
        logger.debug("{}", (Object)processInstance);
        logger.debug(" -> {} - {} ", (Object)processInstance.getStart(), (Object)processInstance.getEnd());
        Assert.assertNotNull((Object)processInstance.getStart());
        Assert.assertNotNull((Object)processInstance.getEnd());
        Assert.assertEquals((long)processInstanceId, (long)processInstance.getProcessInstanceId());
        Assert.assertEquals((Object)"com.sample.ruleflow2", (Object)processInstance.getProcessId());
        List nodeInstances = this.logService.findNodeInstances(processInstanceId);
        for (NodeInstanceLog nodeInstance : nodeInstances) {
            logger.debug("{}", (Object)nodeInstance);
            logger.debug(" -> {}", (Object)nodeInstance.getDate());
            Assert.assertEquals((long)processInstanceId, (long)processInstance.getProcessInstanceId());
            Assert.assertEquals((Object)"com.sample.ruleflow2", (Object)processInstance.getProcessId());
            Assert.assertNotNull((Object)nodeInstance.getDate());
        }
        Assert.assertEquals((long)14L, (long)nodeInstances.size());
        this.logService.clear();
    }

    private void assertRuleFlowSampleLogsSorting(List<NodeInstanceLog> nodeInstanceLogs, long processInstanceId) {
        this.assertLogContent(nodeInstanceLogs.get(0), processInstanceId, "com.sample.ruleflow", 0, "StartNode", "Start");
        this.assertLogContent(nodeInstanceLogs.get(1), processInstanceId, "com.sample.ruleflow", 1, "StartNode", "Start");
        this.assertLogContent(nodeInstanceLogs.get(2), processInstanceId, "com.sample.ruleflow", 0, "WorkItemNode", "Task");
        this.assertLogContent(nodeInstanceLogs.get(3), processInstanceId, "com.sample.ruleflow", 1, "WorkItemNode", "Task");
        this.assertLogContent(nodeInstanceLogs.get(4), processInstanceId, "com.sample.ruleflow", 0, "EndNode", "End");
        this.assertLogContent(nodeInstanceLogs.get(5), processInstanceId, "com.sample.ruleflow", 1, "EndNode", "End");
    }

    private void assertLogContent(NodeInstanceLog log, long nodeInstanceId, String processId, Integer type, String nodeType, String nodeName) {
        Assert.assertEquals((long)nodeInstanceId, (long)log.getProcessInstanceId());
        Assert.assertEquals((Object)processId, (Object)log.getProcessId());
        Assert.assertEquals((Object)type, (Object)log.getType());
        Assert.assertEquals((Object)nodeType, (Object)log.getNodeType());
        Assert.assertEquals((Object)nodeName, (Object)log.getNodeName());
    }
}

