/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.casemgmt.api.CaseNotFoundException;
import org.jbpm.casemgmt.api.model.AdHocFragment;
import org.jbpm.casemgmt.api.model.CaseStatus;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.api.model.instance.CaseInstance;
import org.jbpm.casemgmt.api.model.instance.CaseStageInstance;
import org.jbpm.casemgmt.api.model.instance.StageStatus;
import org.jbpm.casemgmt.impl.CaseRuntimeDataServiceImpl;
import org.jbpm.casemgmt.impl.util.AbstractCaseServicesBaseTest;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.task.impl.model.UserImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.query.QueryFilter;
import org.kie.scanner.MavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseRuntimeDataServiceImplTest
extends AbstractCaseServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(CaseRuntimeDataServiceImplTest.class);
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    public static final String SORT_BY_CASE_DEFINITION_NAME = "CaseName";

    @Before
    public void prepare() {
        this.configureServices();
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("cases/EmptyCase.bpmn2");
        processes.add("cases/UserTaskCase.bpmn2");
        processes.add("cases/UserTaskCaseBoundary.bpmn2");
        processes.add("cases/UserTaskWithStageCase.bpmn2");
        processes.add("cases/CaseWithTwoStages.bpmn2");
        processes.add("cases/CaseWithTwoStagesConditions.bpmn2");
        processes.add("processes/DataVerificationProcess.bpmn2");
        processes.add("processes/UserTaskProcess.bpmn2");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.deployArtifact(releaseId, kJar1, pom);
    }

    @After
    public void cleanup() {
        this.identityProvider.reset();
        CaseRuntimeDataServiceImplTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                this.deploymentService.undeploy(unit);
            }
            this.units.clear();
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartEmptyCaseWithCaseFile() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "my first case");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(deploymentUnit.getIdentifier(), "EmptyCase", data);
        String caseId = this.caseService.startCase(deploymentUnit.getIdentifier(), "EmptyCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertNotNull((Object)cInstance.getCaseFile());
            Assert.assertEquals((Object)"my first case", (Object)cInstance.getCaseFile().getData("name"));
            Collection instances = this.caseRuntimeDataService.getCaseInstances(new QueryContext());
            Assert.assertNotNull((Object)instances);
            Assert.assertEquals((long)1L, (long)instances.size());
            CaseInstance instance = (CaseInstance)instances.iterator().next();
            Assert.assertNotNull((Object)instance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)instance.getCaseId());
            Assert.assertEquals((Object)"EmptyCase", (Object)instance.getCaseDefinitionId());
            Assert.assertEquals((Object)"my first case", (Object)instance.getCaseDescription());
            Assert.assertEquals((Object)"testUser", (Object)instance.getOwner());
            Assert.assertEquals((long)1L, (long)instance.getStatus().intValue());
            Assert.assertEquals((Object)deploymentUnit.getIdentifier(), (Object)instance.getDeploymentId());
            Assert.assertNotNull((Object)instance.getStartedAt());
            HashMap parameters = new HashMap();
            this.caseService.addDynamicTask("CASE-0000000001", this.caseService.newHumanTaskSpec("First task", "test", "john", null, parameters));
            Collection activeNodes = this.caseRuntimeDataService.getActiveNodesForCase("CASE-0000000001", new QueryContext());
            Assert.assertNotNull((Object)activeNodes);
            Assert.assertEquals((long)1L, (long)activeNodes.size());
            NodeInstanceDesc activeNode = (NodeInstanceDesc)activeNodes.iterator().next();
            Assert.assertNotNull((Object)activeNodes);
            Assert.assertEquals((Object)"[Dynamic] First task", (Object)activeNode.getName());
            List tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(caseId, "john", null, new QueryContext());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            TaskSummary task = (TaskSummary)tasks.get(0);
            Assert.assertEquals((Object)"First task", (Object)task.getName());
            Assert.assertEquals((Object)"test", (Object)task.getDescription());
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assert.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserTasksInCase() {
        block9: {
            String caseId2;
            block8: {
                this.identityProvider.setName("john");
                HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
                roleAssignments.put("owner", new UserImpl("john"));
                Assert.assertNotNull((Object)this.deploymentService);
                KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
                this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
                this.units.add((DeploymentUnit)deploymentUnit);
                HashMap data = new HashMap();
                CaseFileInstance caseFile = this.caseService.newCaseFileInstance(deploymentUnit.getIdentifier(), "UserTaskCase", data, roleAssignments);
                caseId2 = null;
                String caseId = this.caseService.startCase(deploymentUnit.getIdentifier(), "UserTaskWithStageCase", caseFile);
                Assert.assertNotNull((Object)caseId);
                Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
                try {
                    CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
                    Assert.assertNotNull((Object)cInstance);
                    Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
                    Assert.assertEquals((Object)deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
                    List tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(caseId, "john", null, new QueryContext());
                    Assert.assertNotNull((Object)tasks);
                    Assert.assertEquals((long)0L, (long)tasks.size());
                    HashMap<String, String> taskInput = new HashMap<String, String>();
                    taskInput.put("ActorId", "john");
                    taskInput.put("Comment", "Need to provide data");
                    this.caseService.triggerAdHocFragment(caseId, "Missing data", taskInput);
                    tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(caseId, "john", null, new QueryContext());
                    Assert.assertNotNull((Object)tasks);
                    Assert.assertEquals((long)1L, (long)tasks.size());
                    TaskSummary task = (TaskSummary)tasks.get(0);
                    Assert.assertEquals((Object)"Missing data", (Object)task.getName());
                    Assert.assertEquals((Object)"Need to provide data", (Object)task.getSubject());
                    caseId2 = this.caseService.startCase(deploymentUnit.getIdentifier(), "UserTaskWithStageCase", caseFile);
                    Assert.assertNotNull((Object)caseId2);
                    Assert.assertEquals((Object)"CASE-0000000002", (Object)caseId2);
                    this.caseService.triggerAdHocFragment(caseId2, "Missing data", taskInput);
                    tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(caseId2, "john", null, new QueryContext());
                    Assert.assertNotNull((Object)tasks);
                    Assert.assertEquals((long)1L, (long)tasks.size());
                    task = (TaskSummary)tasks.get(0);
                    Assert.assertEquals((Object)"Missing data", (Object)task.getName());
                    tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(caseId, "john", null, new QueryContext());
                    Assert.assertNotNull((Object)tasks);
                    Assert.assertEquals((long)1L, (long)tasks.size());
                    task = (TaskSummary)tasks.get(0);
                    Assert.assertEquals((Object)"Missing data", (Object)task.getName());
                    if (caseId == null) break block8;
                }
                catch (Exception e) {
                    logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
                    Assert.fail((String)("Unexpected exception " + e.getMessage()));
                    break block9;
                }
                finally {
                    if (caseId != null) {
                        this.caseService.cancelCase(caseId);
                    }
                    if (caseId2 != null) {
                        this.caseService.cancelCase(caseId2);
                    }
                }
                this.caseService.cancelCase(caseId);
            }
            if (caseId2 != null) {
                this.caseService.cancelCase(caseId2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserTasksInCaseWithSubprocess() {
        this.identityProvider.setName("john");
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(deploymentUnit.getIdentifier(), "UserTaskCase", data, roleAssignments);
        String caseId = this.caseService.startCase(deploymentUnit.getIdentifier(), "UserTaskWithStageCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            List tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(caseId, "john", null, new QueryContext());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)0L, (long)tasks.size());
            HashMap<String, String> taskInput = new HashMap<String, String>();
            taskInput.put("ActorId", "john");
            this.caseService.triggerAdHocFragment(caseId, "Missing data", taskInput);
            tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(caseId, "john", null, new QueryContext());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            TaskSummary task = (TaskSummary)tasks.get(0);
            Assert.assertEquals((Object)"Missing data", (Object)task.getName());
            this.caseService.addDynamicSubprocess(caseId, "UserTask", null);
            tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(caseId, "john", null, new QueryContext());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)2L, (long)tasks.size());
            task = (TaskSummary)tasks.get(0);
            Assert.assertEquals((Object)"Hello", (Object)task.getName());
            task = (TaskSummary)tasks.get(1);
            Assert.assertEquals((Object)"Missing data", (Object)task.getName());
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assert.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserTasksInCaseAdBusinessAdmin() {
        block9: {
            String caseId2;
            block8: {
                this.identityProvider.setName("john");
                HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
                roleAssignments.put("owner", new UserImpl("john"));
                Assert.assertNotNull((Object)this.deploymentService);
                KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
                this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
                this.units.add((DeploymentUnit)deploymentUnit);
                HashMap data = new HashMap();
                CaseFileInstance caseFile = this.caseService.newCaseFileInstance(deploymentUnit.getIdentifier(), "UserTaskCase", data, roleAssignments);
                caseId2 = null;
                String caseId = this.caseService.startCase(deploymentUnit.getIdentifier(), "UserTaskWithStageCase", caseFile);
                Assert.assertNotNull((Object)caseId);
                Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
                try {
                    CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
                    Assert.assertNotNull((Object)cInstance);
                    Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
                    Assert.assertEquals((Object)deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
                    List tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsBusinessAdmin(caseId, "Administrator", null, new QueryContext());
                    Assert.assertNotNull((Object)tasks);
                    Assert.assertEquals((long)0L, (long)tasks.size());
                    HashMap<String, String> taskInput = new HashMap<String, String>();
                    taskInput.put("ActorId", "john");
                    this.caseService.triggerAdHocFragment(caseId, "Missing data", taskInput);
                    tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsBusinessAdmin(caseId, "Administrator", null, new QueryContext());
                    Assert.assertNotNull((Object)tasks);
                    Assert.assertEquals((long)1L, (long)tasks.size());
                    TaskSummary task = (TaskSummary)tasks.get(0);
                    Assert.assertEquals((Object)"Missing data", (Object)task.getName());
                    caseId2 = this.caseService.startCase(deploymentUnit.getIdentifier(), "UserTaskWithStageCase", caseFile);
                    Assert.assertNotNull((Object)caseId2);
                    Assert.assertEquals((Object)"CASE-0000000002", (Object)caseId2);
                    this.caseService.triggerAdHocFragment(caseId2, "Missing data", taskInput);
                    tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsBusinessAdmin(caseId2, "Administrator", null, new QueryContext());
                    Assert.assertNotNull((Object)tasks);
                    Assert.assertEquals((long)1L, (long)tasks.size());
                    task = (TaskSummary)tasks.get(0);
                    Assert.assertEquals((Object)"Missing data", (Object)task.getName());
                    tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsBusinessAdmin(caseId, "Administrator", null, new QueryContext());
                    Assert.assertNotNull((Object)tasks);
                    Assert.assertEquals((long)1L, (long)tasks.size());
                    task = (TaskSummary)tasks.get(0);
                    Assert.assertEquals((Object)"Missing data", (Object)task.getName());
                    if (caseId == null) break block8;
                }
                catch (Exception e) {
                    logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
                    Assert.fail((String)("Unexpected exception " + e.getMessage()));
                    break block9;
                }
                finally {
                    if (caseId != null) {
                        this.caseService.cancelCase(caseId);
                    }
                    if (caseId2 != null) {
                        this.caseService.cancelCase(caseId2);
                    }
                }
                this.caseService.cancelCase(caseId);
            }
            if (caseId2 != null) {
                this.caseService.cancelCase(caseId2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserTasksInCaseAdStakeholder() {
        block9: {
            String caseId2;
            block8: {
                this.identityProvider.setName("john");
                HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
                roleAssignments.put("owner", new UserImpl("john"));
                Assert.assertNotNull((Object)this.deploymentService);
                KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
                this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
                this.units.add((DeploymentUnit)deploymentUnit);
                HashMap data = new HashMap();
                CaseFileInstance caseFile = this.caseService.newCaseFileInstance(deploymentUnit.getIdentifier(), "UserTaskCase", data, roleAssignments);
                caseId2 = null;
                String caseId = this.caseService.startCase(deploymentUnit.getIdentifier(), "UserTaskWithStageCase", caseFile);
                Assert.assertNotNull((Object)caseId);
                Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
                try {
                    CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
                    Assert.assertNotNull((Object)cInstance);
                    Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
                    Assert.assertEquals((Object)deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
                    List tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsStakeholder(caseId, "john", null, new QueryContext());
                    Assert.assertNotNull((Object)tasks);
                    Assert.assertEquals((long)0L, (long)tasks.size());
                    HashMap<String, String> taskInput = new HashMap<String, String>();
                    taskInput.put("ActorId", "mary");
                    taskInput.put("TaskStakeholderId", "john");
                    this.caseService.triggerAdHocFragment(caseId, "Missing data", taskInput);
                    tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsStakeholder(caseId, "john", null, new QueryContext());
                    Assert.assertNotNull((Object)tasks);
                    Assert.assertEquals((long)1L, (long)tasks.size());
                    TaskSummary task = (TaskSummary)tasks.get(0);
                    Assert.assertEquals((Object)"Missing data", (Object)task.getName());
                    caseId2 = this.caseService.startCase(deploymentUnit.getIdentifier(), "UserTaskWithStageCase", caseFile);
                    Assert.assertNotNull((Object)caseId2);
                    Assert.assertEquals((Object)"CASE-0000000002", (Object)caseId2);
                    this.caseService.triggerAdHocFragment(caseId2, "Missing data", taskInput);
                    tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsStakeholder(caseId2, "john", null, new QueryContext());
                    Assert.assertNotNull((Object)tasks);
                    Assert.assertEquals((long)1L, (long)tasks.size());
                    task = (TaskSummary)tasks.get(0);
                    Assert.assertEquals((Object)"Missing data", (Object)task.getName());
                    tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsStakeholder(caseId, "john", null, new QueryContext());
                    Assert.assertNotNull((Object)tasks);
                    Assert.assertEquals((long)1L, (long)tasks.size());
                    task = (TaskSummary)tasks.get(0);
                    Assert.assertEquals((Object)"Missing data", (Object)task.getName());
                    if (caseId == null) break block8;
                }
                catch (Exception e) {
                    logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
                    Assert.fail((String)("Unexpected exception " + e.getMessage()));
                    break block9;
                }
                finally {
                    if (caseId != null) {
                        this.caseService.cancelCase(caseId);
                    }
                    if (caseId2 != null) {
                        this.caseService.cancelCase(caseId2);
                    }
                }
                this.caseService.cancelCase(caseId);
            }
            if (caseId2 != null) {
                this.caseService.cancelCase(caseId2);
            }
        }
    }

    @Test
    public void testGetProcessDefinitions() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Collection processes = this.caseRuntimeDataService.getProcessDefinitions(new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)2L, (long)processes.size());
        Map<String, ProcessDefinition> mappedProcesses = this.mapProcesses(processes);
        Assert.assertTrue((boolean)mappedProcesses.containsKey("UserTask"));
        Assert.assertTrue((boolean)mappedProcesses.containsKey("DataVerification"));
        processes = this.caseRuntimeDataService.getProcessDefinitions("User", new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.size());
        mappedProcesses = this.mapProcesses(processes);
        Assert.assertTrue((boolean)mappedProcesses.containsKey("UserTask"));
        processes = this.caseRuntimeDataService.getProcessDefinitionsByDeployment(deploymentUnit.getIdentifier(), new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)2L, (long)processes.size());
        mappedProcesses = this.mapProcesses(processes);
        Assert.assertTrue((boolean)mappedProcesses.containsKey("UserTask"));
        Assert.assertTrue((boolean)mappedProcesses.containsKey("DataVerification"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransitionBetweenStagesInCase() {
        this.identityProvider.setName("john");
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(deploymentUnit.getIdentifier(), "CaseWithTwoStages", data, roleAssignments);
        String caseId = this.caseService.startCase(deploymentUnit.getIdentifier(), "CaseWithTwoStages", caseFile);
        Assert.assertNotNull((Object)caseId);
        try {
            Collection stage = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext(Integer.valueOf(0), Integer.valueOf(1)));
            Assert.assertNotNull((Object)stage);
            Assert.assertEquals((long)1L, (long)stage.size());
            Assert.assertEquals((Object)"Stage One", (Object)((CaseStageInstance)stage.iterator().next()).getName());
            Assert.assertEquals((Object)StageStatus.Active, (Object)((CaseStageInstance)stage.iterator().next()).getStatus());
            Collection adhocTasks = this.caseRuntimeDataService.getAdHocFragmentsForCase(caseId);
            Assert.assertNotNull((Object)adhocTasks);
            Assert.assertEquals((long)1L, (long)adhocTasks.size());
            Assert.assertEquals((Object)"Task 1", (Object)((AdHocFragment)adhocTasks.iterator().next()).getName());
            Collection activeNodes = this.caseRuntimeDataService.getActiveNodesForCase(caseId, new QueryContext(Integer.valueOf(0), Integer.valueOf(10)));
            Assert.assertNotNull((Object)activeNodes);
            Assert.assertEquals((long)1L, (long)activeNodes.size());
            Assert.assertEquals((Object)"Stage One", (Object)((NodeInstanceDesc)activeNodes.iterator().next()).getName());
            Collection completedNodes = this.caseRuntimeDataService.getCompletedNodesForCase(caseId, new QueryContext(Integer.valueOf(0), Integer.valueOf(10)));
            Assert.assertNotNull((Object)completedNodes);
            Assert.assertEquals((long)0L, (long)completedNodes.size());
            this.caseService.addDataToCaseFile(caseId, "customData", (Object)"nextStagePlease");
            stage = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext(Integer.valueOf(0), Integer.valueOf(1)));
            Assert.assertNotNull((Object)stage);
            Assert.assertEquals((long)1L, (long)stage.size());
            Assert.assertEquals((Object)"Stage Two", (Object)((CaseStageInstance)stage.iterator().next()).getName());
            Assert.assertEquals((Object)StageStatus.Active, (Object)((CaseStageInstance)stage.iterator().next()).getStatus());
            adhocTasks = this.caseRuntimeDataService.getAdHocFragmentsForCase(caseId);
            Assert.assertNotNull((Object)adhocTasks);
            Assert.assertEquals((long)1L, (long)adhocTasks.size());
            Assert.assertEquals((Object)"Task 2", (Object)((AdHocFragment)adhocTasks.iterator().next()).getName());
            activeNodes = this.caseRuntimeDataService.getActiveNodesForCase(caseId, new QueryContext(Integer.valueOf(0), Integer.valueOf(10)));
            Assert.assertNotNull((Object)activeNodes);
            Assert.assertEquals((long)1L, (long)activeNodes.size());
            Assert.assertEquals((Object)"Stage Two", (Object)((NodeInstanceDesc)activeNodes.iterator().next()).getName());
            completedNodes = this.caseRuntimeDataService.getCompletedNodesForCase(caseId, new QueryContext(Integer.valueOf(0), Integer.valueOf(10)));
            Assert.assertNotNull((Object)completedNodes);
            Assert.assertEquals((long)1L, (long)completedNodes.size());
            Assert.assertEquals((Object)"Stage One", (Object)((NodeInstanceDesc)completedNodes.iterator().next()).getName());
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assert.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddSubprocessToEmptyCaseCheckCaseNodes() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "my first case");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(deploymentUnit.getIdentifier(), "EmptyCase", data);
        String caseId = this.caseService.startCase(deploymentUnit.getIdentifier(), "EmptyCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Collection activeNodes = this.caseRuntimeDataService.getActiveNodesForCase(caseId, new QueryContext(Integer.valueOf(0), Integer.valueOf(10)));
            Assert.assertNotNull((Object)activeNodes);
            Assert.assertEquals((long)0L, (long)activeNodes.size());
            Collection completedNodes = this.caseRuntimeDataService.getCompletedNodesForCase(caseId, new QueryContext(Integer.valueOf(0), Integer.valueOf(10)));
            Assert.assertNotNull((Object)completedNodes);
            Assert.assertEquals((long)0L, (long)completedNodes.size());
            HashMap parameters = new HashMap();
            this.caseService.addDynamicSubprocess(caseId, "UserTask", parameters);
            Collection caseProcessInstances = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, new QueryContext());
            Assert.assertNotNull((Object)caseProcessInstances);
            Assert.assertEquals((long)2L, (long)caseProcessInstances.size());
            activeNodes = this.caseRuntimeDataService.getActiveNodesForCase(caseId, new QueryContext(Integer.valueOf(0), Integer.valueOf(10)));
            Assert.assertNotNull((Object)activeNodes);
            Assert.assertEquals((long)2L, (long)activeNodes.size());
            Map<String, NodeInstanceDesc> mappedNodes = this.mapNodeInstances(activeNodes);
            Assert.assertEquals((Object)"HumanTaskNode", (Object)mappedNodes.get("Hello").getNodeType());
            Assert.assertEquals((Object)"SubProcessNode", (Object)mappedNodes.get("[Dynamic] Sub Process").getNodeType());
            completedNodes = this.caseRuntimeDataService.getCompletedNodesForCase(caseId, new QueryContext(Integer.valueOf(0), Integer.valueOf(10)));
            Assert.assertNotNull((Object)completedNodes);
            Assert.assertEquals((long)0L, (long)completedNodes.size());
            List tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(caseId, "john", null, new QueryContext());
            Assert.assertEquals((long)1L, (long)tasks.size());
            this.userTaskService.completeAutoProgress(((TaskSummary)tasks.get(0)).getId(), "john", null);
            activeNodes = this.caseRuntimeDataService.getActiveNodesForCase(caseId, new QueryContext(Integer.valueOf(0), Integer.valueOf(10)));
            Assert.assertNotNull((Object)activeNodes);
            Assert.assertEquals((long)0L, (long)activeNodes.size());
            completedNodes = this.caseRuntimeDataService.getCompletedNodesForCase(caseId, new QueryContext(Integer.valueOf(0), Integer.valueOf(10)));
            Assert.assertNotNull((Object)completedNodes);
            Assert.assertEquals((long)2L, (long)completedNodes.size());
            Assert.assertEquals((Object)"HumanTaskNode", (Object)mappedNodes.get("Hello").getNodeType());
            Assert.assertEquals((Object)"SubProcessNode", (Object)mappedNodes.get("[Dynamic] Sub Process").getNodeType());
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assert.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransitionBetweenStagesWithConditionsInCase() {
        this.identityProvider.setName("john");
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("customData", "none");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(deploymentUnit.getIdentifier(), "CaseWithTwoStagesConditions", data, roleAssignments);
        String caseId = this.caseService.startCase(deploymentUnit.getIdentifier(), "CaseWithTwoStagesConditions", caseFile);
        Assert.assertNotNull((Object)caseId);
        try {
            Collection stage = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext(Integer.valueOf(0), Integer.valueOf(1)));
            Assert.assertNotNull((Object)stage);
            Assert.assertEquals((long)1L, (long)stage.size());
            Assert.assertEquals((Object)"Stage One", (Object)((CaseStageInstance)stage.iterator().next()).getName());
            Assert.assertEquals((Object)StageStatus.Active, (Object)((CaseStageInstance)stage.iterator().next()).getStatus());
            Collection adhocTasks = this.caseRuntimeDataService.getAdHocFragmentsForCase(caseId);
            Assert.assertNotNull((Object)adhocTasks);
            Assert.assertEquals((long)1L, (long)adhocTasks.size());
            Assert.assertEquals((Object)"Task 1", (Object)((AdHocFragment)adhocTasks.iterator().next()).getName());
            this.caseService.triggerAdHocFragment(caseId, "Task 1", null);
            List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            this.assertTask((TaskSummary)tasks.get(0), "john", "Task 1", Status.Reserved);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("myData", "nextStage");
            this.userTaskService.completeAutoProgress(((TaskSummary)tasks.get(0)).getId(), "john", params);
            stage = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext(Integer.valueOf(0), Integer.valueOf(1)));
            Assert.assertNotNull((Object)stage);
            Assert.assertEquals((long)1L, (long)stage.size());
            Assert.assertEquals((Object)"Stage Two", (Object)((CaseStageInstance)stage.iterator().next()).getName());
            Assert.assertEquals((Object)StageStatus.Active, (Object)((CaseStageInstance)stage.iterator().next()).getStatus());
            adhocTasks = this.caseRuntimeDataService.getAdHocFragmentsForCase(caseId);
            Assert.assertNotNull((Object)adhocTasks);
            Assert.assertEquals((long)1L, (long)adhocTasks.size());
            Assert.assertEquals((Object)"Task 2", (Object)((AdHocFragment)adhocTasks.iterator().next()).getName());
            this.caseService.triggerAdHocFragment(caseId, "Task 2", null);
            tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            this.assertTask((TaskSummary)tasks.get(0), "john", "Task 2", Status.Reserved);
            params = new HashMap();
            params.put("myData", "none");
            this.userTaskService.completeAutoProgress(((TaskSummary)tasks.get(0)).getId(), "john", params);
            try {
                this.caseService.getCaseInstance(caseId);
                Assert.fail((String)"Case should already be finished");
            }
            catch (CaseNotFoundException e) {
                caseId = null;
            }
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assert.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransitionBetweenStagesInCaseWithActiveElements() {
        this.identityProvider.setName("john");
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(deploymentUnit.getIdentifier(), "CaseWithTwoStages", data, roleAssignments);
        String caseId = this.caseService.startCase(deploymentUnit.getIdentifier(), "CaseWithTwoStages", caseFile);
        Assert.assertNotNull((Object)caseId);
        try {
            Collection stage = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext(Integer.valueOf(0), Integer.valueOf(1)));
            Assert.assertNotNull((Object)stage);
            Assert.assertEquals((long)1L, (long)stage.size());
            CaseStageInstance stageInstance = (CaseStageInstance)stage.iterator().next();
            Assert.assertEquals((Object)"Stage One", (Object)stageInstance.getName());
            Assert.assertEquals((Object)StageStatus.Active, (Object)stageInstance.getStatus());
            Collection activeNodes = stageInstance.getActiveNodes();
            Assert.assertNotNull((Object)activeNodes);
            Assert.assertEquals((long)0L, (long)activeNodes.size());
            this.caseService.triggerAdHocFragment(caseId, "Task 1", data);
            stage = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext(Integer.valueOf(0), Integer.valueOf(1)));
            Assert.assertNotNull((Object)stage);
            Assert.assertEquals((long)1L, (long)stage.size());
            stageInstance = (CaseStageInstance)stage.iterator().next();
            Assert.assertEquals((Object)"Stage One", (Object)stageInstance.getName());
            Assert.assertEquals((Object)StageStatus.Active, (Object)stageInstance.getStatus());
            activeNodes = stageInstance.getActiveNodes();
            Assert.assertNotNull((Object)activeNodes);
            Assert.assertEquals((long)1L, (long)activeNodes.size());
            Assert.assertEquals((Object)"Task 1", (Object)((NodeInstanceDesc)activeNodes.iterator().next()).getName());
            this.caseService.addDataToCaseFile(caseId, "customData", (Object)"nextStagePlease");
            stage = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext(Integer.valueOf(0), Integer.valueOf(1)));
            Assert.assertNotNull((Object)stage);
            Assert.assertEquals((long)1L, (long)stage.size());
            Assert.assertEquals((Object)"Stage Two", (Object)((CaseStageInstance)stage.iterator().next()).getName());
            Assert.assertEquals((Object)StageStatus.Active, (Object)((CaseStageInstance)stage.iterator().next()).getStatus());
            stage = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext(Integer.valueOf(0), Integer.valueOf(1)));
            Assert.assertNotNull((Object)stage);
            Assert.assertEquals((long)1L, (long)stage.size());
            stageInstance = (CaseStageInstance)stage.iterator().next();
            Assert.assertEquals((Object)"Stage Two", (Object)stageInstance.getName());
            Assert.assertEquals((Object)StageStatus.Active, (Object)stageInstance.getStatus());
            activeNodes = stageInstance.getActiveNodes();
            Assert.assertNotNull((Object)activeNodes);
            Assert.assertEquals((long)0L, (long)activeNodes.size());
            this.caseService.triggerAdHocFragment(caseId, "Task 2", data);
            stage = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext(Integer.valueOf(0), Integer.valueOf(1)));
            Assert.assertNotNull((Object)stage);
            Assert.assertEquals((long)1L, (long)stage.size());
            stageInstance = (CaseStageInstance)stage.iterator().next();
            Assert.assertEquals((Object)"Stage Two", (Object)stageInstance.getName());
            Assert.assertEquals((Object)StageStatus.Active, (Object)stageInstance.getStatus());
            activeNodes = stageInstance.getActiveNodes();
            Assert.assertNotNull((Object)activeNodes);
            Assert.assertEquals((long)1L, (long)activeNodes.size());
            Assert.assertEquals((Object)"Task 2", (Object)((NodeInstanceDesc)activeNodes.iterator().next()).getName());
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assert.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    @Test
    public void testResolveCaseStatuses() {
        List<CaseStatus> testStatuses = Arrays.asList(CaseStatus.CANCELLED, CaseStatus.CLOSED, CaseStatus.OPEN);
        List resolvedTestStatuses = ((CaseRuntimeDataServiceImpl)this.caseRuntimeDataService).resolveCaseStatuses(testStatuses);
        List<Integer> resultStatuses = Arrays.asList(3, 2, 1);
        List<Integer> invalidResultStatuses = Arrays.asList(1, 2, 3);
        Assert.assertTrue((boolean)resolvedTestStatuses.equals(resultStatuses));
        Assert.assertFalse((boolean)resolvedTestStatuses.equals(invalidResultStatuses));
    }

    @Test
    public void testCaseStatusCreation() {
        List<Integer> testStatuses = Arrays.asList(1);
        List<String> testStatusesString = Arrays.asList("open");
        List testCaseStatusesFromIds = CaseStatus.fromIdList(testStatuses);
        List testCaseStatusesFromNames = CaseStatus.fromNameList(testStatusesString);
        Assert.assertNotNull((Object)testCaseStatusesFromIds);
        Assert.assertNotNull((Object)testCaseStatusesFromNames);
        Assert.assertEquals((long)1L, (long)testCaseStatusesFromIds.size());
        Assert.assertEquals((long)1L, (long)testCaseStatusesFromNames.size());
        Assert.assertTrue((boolean)testCaseStatusesFromIds.contains(CaseStatus.OPEN));
        Assert.assertTrue((boolean)testCaseStatusesFromNames.contains(CaseStatus.OPEN));
        testStatuses = Arrays.asList(1, 2);
        testStatusesString = Arrays.asList("open", "closed");
        testCaseStatusesFromIds = CaseStatus.fromIdList(testStatuses);
        testCaseStatusesFromNames = CaseStatus.fromNameList(testStatusesString);
        Assert.assertNotNull((Object)testCaseStatusesFromIds);
        Assert.assertNotNull((Object)testCaseStatusesFromNames);
        Assert.assertEquals((long)2L, (long)testCaseStatusesFromIds.size());
        Assert.assertEquals((long)2L, (long)testCaseStatusesFromNames.size());
        Assert.assertTrue((boolean)testCaseStatusesFromIds.contains(CaseStatus.OPEN));
        Assert.assertTrue((boolean)testCaseStatusesFromIds.contains(CaseStatus.CLOSED));
        Assert.assertTrue((boolean)testCaseStatusesFromNames.contains(CaseStatus.OPEN));
        Assert.assertTrue((boolean)testCaseStatusesFromNames.contains(CaseStatus.CLOSED));
        testStatuses = Arrays.asList(1, 2, 3);
        testStatusesString = Arrays.asList("open", "closed", "cancelled");
        testCaseStatusesFromIds = CaseStatus.fromIdList(testStatuses);
        testCaseStatusesFromNames = CaseStatus.fromNameList(testStatusesString);
        Assert.assertNotNull((Object)testCaseStatusesFromIds);
        Assert.assertNotNull((Object)testCaseStatusesFromNames);
        Assert.assertEquals((long)3L, (long)testCaseStatusesFromIds.size());
        Assert.assertEquals((long)3L, (long)testCaseStatusesFromNames.size());
        Assert.assertTrue((boolean)testCaseStatusesFromIds.contains(CaseStatus.OPEN));
        Assert.assertTrue((boolean)testCaseStatusesFromIds.contains(CaseStatus.CLOSED));
        Assert.assertTrue((boolean)testCaseStatusesFromIds.contains(CaseStatus.CANCELLED));
        Assert.assertTrue((boolean)testCaseStatusesFromNames.contains(CaseStatus.OPEN));
        Assert.assertTrue((boolean)testCaseStatusesFromNames.contains(CaseStatus.CLOSED));
        Assert.assertTrue((boolean)testCaseStatusesFromNames.contains(CaseStatus.CANCELLED));
    }
}

