/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.expressioneditor;

import junit.framework.Assert;
import org.jbpm.designer.expressioneditor.marshalling.ExpressionEditorMessageJSONMarshaller;
import org.jbpm.designer.expressioneditor.marshalling.ExpressionEditorMessageJSONUnmarshaller;
import org.jbpm.designer.expressioneditor.model.Condition;
import org.jbpm.designer.expressioneditor.model.ConditionExpression;
import org.jbpm.designer.expressioneditor.model.ExpressionEditorMessage;
import org.junit.Test;

public class ExpressionEditorMessageMarshallingTest {
    @Test
    public void testUnmarshalling() throws Exception {
        ExpressionEditorMessageJSONUnmarshaller unmarshaller = new ExpressionEditorMessageJSONUnmarshaller();
        ExpressionEditorMessage message = unmarshaller.unmarshall(ExpressionEditorMessageMarshallingTest.class.getResourceAsStream("condition_editor_message.json"));
        Assert.assertNotNull((String)"json message was not marshalled", (Object)message);
        Assert.assertNotNull((String)"condition expression was not marshalled", (Object)message.getExpression());
        Assert.assertEquals((String)"OR", (String)message.getExpression().getOperator());
        Assert.assertEquals((int)2, (int)message.getExpression().getConditions().size());
        Assert.assertEquals((String)"isEquals", (String)((Condition)message.getExpression().getConditions().get(0)).getFunction());
        Assert.assertEquals((String)"variableName1", (String)((String)((Condition)message.getExpression().getConditions().get(0)).getParameters().get(0)));
        Assert.assertEquals((String)"param1.1", (String)((String)((Condition)message.getExpression().getConditions().get(0)).getParameters().get(1)));
        Assert.assertEquals((String)"isBetween", (String)((Condition)message.getExpression().getConditions().get(1)).getFunction());
        Assert.assertEquals((String)"variableName2", (String)((String)((Condition)message.getExpression().getConditions().get(1)).getParameters().get(0)));
        Assert.assertEquals((String)"param2.1", (String)((String)((Condition)message.getExpression().getConditions().get(1)).getParameters().get(1)));
        Assert.assertEquals((String)"param2.2", (String)((String)((Condition)message.getExpression().getConditions().get(1)).getParameters().get(2)));
        Assert.assertEquals((String)"return true;", (String)message.getScript());
        Assert.assertEquals((String)"The error code", (String)message.getErrorCode());
        Assert.assertEquals((String)"The error message", (String)message.getErrorMessage());
    }

    @Test
    public void testMarshalling() throws Exception {
        ExpressionEditorMessageJSONMarshaller marshaller = new ExpressionEditorMessageJSONMarshaller();
        ExpressionEditorMessage message = new ExpressionEditorMessage();
        ConditionExpression expression = new ConditionExpression("OR");
        message.setExpression(expression);
        Condition condition1 = new Condition();
        condition1.setFunction("isEquals");
        condition1.getParameters().add("variableName1");
        condition1.getParameters().add("param1.1");
        expression.getConditions().add(condition1);
        Condition condition2 = new Condition();
        condition2.setFunction("isBetween");
        condition2.getParameters().add("variableName2");
        condition2.getParameters().add("param2.1");
        condition2.getParameters().add("param2.2");
        expression.getConditions().add(condition2);
        message.setScript("return true;");
        message.setErrorCode("The error code");
        message.setErrorMessage("The error message");
        String expectedResult = "{\"operator\":\"OR\",\"conditions\":[{\"condition\":\"isEquals\",\"parameters\":[\"variableName1\",\"param1.1\"]},{\"condition\":\"isBetween\",\"parameters\":[\"variableName2\",\"param2.1\",\"param2.2\"]}],\"script\":\"return true;\",\"errorCode\":\"The error code\",\"errorMessage\":\"The error message\"}";
        String result = marshaller.marshall(message);
        Assert.assertEquals((String)expectedResult, (String)result);
    }
}

