/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.services.api.model.DeployedAsset;
import org.jbpm.services.api.model.DeployedUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.kie.api.runtime.manager.RuntimeManager;

public class DeployedUnitImpl
implements DeployedUnit {
    private DeploymentUnit unit;
    private RuntimeManager manager;
    private Map<String, DeployedAsset> assets = new HashMap<String, DeployedAsset>();
    private Set<Class<?>> classes = new CopyOnWriteArraySet();

    public DeployedUnitImpl(DeploymentUnit unit) {
        this.unit = unit;
    }

    public DeploymentUnit getDeploymentUnit() {
        return this.unit;
    }

    public String getDeployedAssetLocation(String assetId) {
        return this.assets.get(assetId).getOriginalPath();
    }

    public RuntimeManager getRuntimeManager() {
        return this.manager;
    }

    public void addAssetLocation(String assetId, ProcessAssetDesc processAsset) {
        this.assets.put(assetId, (DeployedAsset)processAsset);
    }

    public void addClass(Class<?> kModuleClass) {
        this.classes.add(kModuleClass);
    }

    public void setRuntimeManager(RuntimeManager manager) {
        if (this.manager != null) {
            throw new IllegalStateException("RuntimeManager already exists");
        }
        this.manager = manager;
    }

    public Collection<DeployedAsset> getDeployedAssets() {
        return Collections.unmodifiableCollection(this.assets.values());
    }

    public Collection<Class<?>> getDeployedClasses() {
        return Collections.unmodifiableCollection(this.classes);
    }
}

