/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.bpmn2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.BPMN2ProcessFactory;
import org.drools.compiler.compiler.BPMN2ProcessProvider;
import org.drools.core.io.impl.ByteArrayResource;
import org.drools.core.util.StringUtils;
import org.drools.core.xml.SemanticModule;
import org.jbpm.bpmn2.xml.BPMNDISemanticModule;
import org.jbpm.bpmn2.xml.BPMNExtensionsSemanticModule;
import org.jbpm.kie.services.impl.bpmn2.BPMN2DataServiceSemanticModule;
import org.jbpm.kie.services.impl.bpmn2.ProcessDescRepoHelper;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.api.model.UserTaskDefinition;
import org.kie.api.definition.process.Process;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.definition.KnowledgePackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BPMN2DataServiceImpl
implements DefinitionService {
    private static final Logger logger = LoggerFactory.getLogger(BPMN2DataServiceImpl.class);
    private ConcurrentHashMap<String, Map<String, ProcessDescRepoHelper>> definitionCache = new ConcurrentHashMap();

    public BPMN2ProcessProvider getProvider(final BPMN2DataServiceSemanticModule module) {
        return new BPMN2ProcessProvider(){

            public void configurePackageBuilder(KnowledgeBuilder packageBuilder) {
                KnowledgeBuilderConfigurationImpl conf = ((KnowledgeBuilderImpl)packageBuilder).getBuilderConfiguration();
                if (conf.getSemanticModules().getSemanticModule("http://www.jboss.org/bpmn2-data-services") == null) {
                    conf.addSemanticModule((SemanticModule)module);
                }
                conf.addSemanticModule((SemanticModule)new BPMNExtensionsSemanticModule());
                conf.addSemanticModule((SemanticModule)new BPMNDISemanticModule());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessDefinition buildProcessDefinition(String deploymentId, String bpmn2Content, ClassLoader classLoader, boolean cache) throws IllegalArgumentException {
        if (StringUtils.isEmpty((CharSequence)bpmn2Content)) {
            return null;
        }
        BPMN2DataServiceSemanticModule module = new BPMN2DataServiceSemanticModule();
        BPMN2ProcessProvider provider = this.getProvider(module);
        BPMN2ProcessProvider originalProvider = BPMN2ProcessFactory.getBPMN2ProcessProvider();
        if (originalProvider != provider) {
            BPMN2ProcessFactory.setBPMN2ProcessProvider((BPMN2ProcessProvider)provider);
        }
        KnowledgeBuilder kbuilder = null;
        if (classLoader != null) {
            KnowledgeBuilderConfigurationImpl pconf = new KnowledgeBuilderConfigurationImpl(new ClassLoader[]{classLoader});
            kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)pconf);
        } else {
            kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        }
        kbuilder.add((Resource)new ByteArrayResource(bpmn2Content.getBytes()), ResourceType.BPMN2);
        if (kbuilder.hasErrors()) {
            for (KnowledgeBuilderError error : kbuilder.getErrors()) {
                logger.error("Error: {}", (Object)error.getMessage());
            }
            logger.debug("Process Cannot be Parsed! \n {} \n", (Object)bpmn2Content);
            return null;
        }
        BPMN2ProcessFactory.setBPMN2ProcessProvider((BPMN2ProcessProvider)originalProvider);
        KnowledgePackage pckg = (KnowledgePackage)kbuilder.getKnowledgePackages().iterator().next();
        Process process = (Process)pckg.getProcesses().iterator().next();
        ProcessAssetDesc definition = new ProcessAssetDesc(process.getId(), process.getName(), process.getVersion(), process.getPackageName(), process.getType(), process.getKnowledgeType().name(), process.getNamespace(), "");
        ProcessDescRepoHelper helper = module.getRepo().removeProcessDescription(process.getId());
        definition.setAssociatedEntities(helper.getTaskAssignments());
        definition.setProcessVariables(helper.getInputs());
        definition.setReusableSubProcesses(helper.getReusableSubProcesses());
        definition.setServiceTasks(helper.getServiceTasks());
        if (cache) {
            Map<String, ProcessDescRepoHelper> definitions = null;
            ConcurrentHashMap<String, Map<String, ProcessDescRepoHelper>> concurrentHashMap = this.definitionCache;
            synchronized (concurrentHashMap) {
                definitions = this.definitionCache.get(deploymentId);
                if (definitions == null) {
                    definitions = new ConcurrentHashMap<String, ProcessDescRepoHelper>();
                    this.definitionCache.put(deploymentId, definitions);
                }
                definitions.put(process.getId(), helper);
            }
        }
        return definition;
    }

    public Map<String, String> getServiceTasks(String deploymentId, String processId) {
        if (StringUtils.isEmpty((CharSequence)deploymentId) || StringUtils.isEmpty((CharSequence)processId)) {
            throw new IllegalStateException("The Deployment id and Process id cannot be Empty!");
        }
        if (this.definitionCache.containsKey(deploymentId)) {
            ProcessDescRepoHelper helper = this.definitionCache.get(deploymentId).get(processId);
            if (helper == null) {
                throw new IllegalStateException("No process available with given id : " + processId);
            }
            return Collections.unmodifiableMap(helper.getServiceTasks());
        }
        return Collections.emptyMap();
    }

    public ProcessDefinition getProcessDefinition(String deploymentId, String processId) {
        if (StringUtils.isEmpty((CharSequence)deploymentId) || StringUtils.isEmpty((CharSequence)processId)) {
            throw new IllegalStateException("The Process id cannot be Empty!");
        }
        if (this.definitionCache.containsKey(deploymentId)) {
            ProcessDescRepoHelper helper = this.definitionCache.get(deploymentId).get(processId);
            if (helper == null) {
                throw new IllegalStateException("No process available with given id : " + processId);
            }
            return helper.getProcess();
        }
        return null;
    }

    public Collection<String> getReusableSubProcesses(String deploymentId, String processId) {
        if (StringUtils.isEmpty((CharSequence)deploymentId) || StringUtils.isEmpty((CharSequence)processId)) {
            throw new IllegalStateException("The Process id cannot be Empty!");
        }
        if (this.definitionCache.containsKey(deploymentId)) {
            ProcessDescRepoHelper helper = this.definitionCache.get(deploymentId).get(processId);
            if (helper == null) {
                throw new IllegalStateException("No process available with given id : " + processId);
            }
            if (helper.getReusableSubProcesses() != null) {
                return new ArrayList<String>(helper.getReusableSubProcesses());
            }
        }
        return Collections.emptyList();
    }

    public Map<String, String> getProcessVariables(String deploymentId, String processId) {
        if (StringUtils.isEmpty((CharSequence)deploymentId) || StringUtils.isEmpty((CharSequence)processId)) {
            throw new IllegalStateException("The Process id cannot be Empty!");
        }
        if (this.definitionCache.containsKey(deploymentId)) {
            ProcessDescRepoHelper helper = this.definitionCache.get(deploymentId).get(processId);
            if (helper == null) {
                throw new IllegalStateException("No process available with given id : " + processId);
            }
            if (helper.getInputs() != null) {
                return Collections.unmodifiableMap(helper.getInputs());
            }
        }
        return Collections.emptyMap();
    }

    public Map<String, Collection<String>> getAssociatedEntities(String deploymentId, String processId) {
        if (StringUtils.isEmpty((CharSequence)deploymentId) || StringUtils.isEmpty((CharSequence)processId)) {
            throw new IllegalStateException("The Process id cannot be Empty!");
        }
        if (this.definitionCache.containsKey(deploymentId)) {
            ProcessDescRepoHelper helper = this.definitionCache.get(deploymentId).get(processId);
            if (helper == null) {
                throw new IllegalStateException("No process available with given id : " + processId);
            }
            if (helper.getTaskAssignments() != null) {
                return Collections.unmodifiableMap(helper.getTaskAssignments());
            }
        }
        return Collections.emptyMap();
    }

    public Collection<UserTaskDefinition> getTasksDefinitions(String deploymentId, String processId) {
        if (StringUtils.isEmpty((CharSequence)deploymentId) || StringUtils.isEmpty((CharSequence)processId)) {
            throw new IllegalStateException("The Process id cannot be Empty!");
        }
        if (this.definitionCache.containsKey(deploymentId)) {
            ProcessDescRepoHelper helper = this.definitionCache.get(deploymentId).get(processId);
            if (helper == null) {
                throw new IllegalStateException("No process available with given id : " + processId);
            }
            if (helper.getTasks() != null) {
                return new ArrayList<UserTaskDefinition>(helper.getTasks().values());
            }
        }
        return Collections.emptyList();
    }

    public Map<String, String> getTaskInputMappings(String deploymentId, String processId, String taskName) {
        if (StringUtils.isEmpty((CharSequence)deploymentId) || StringUtils.isEmpty((CharSequence)processId) || StringUtils.isEmpty((CharSequence)taskName)) {
            throw new IllegalStateException("The Process id cannot be Empty!");
        }
        if (this.definitionCache.containsKey(deploymentId)) {
            ProcessDescRepoHelper helper = this.definitionCache.get(deploymentId).get(processId);
            if (helper == null) {
                throw new IllegalStateException("No process available with given id : " + processId);
            }
            if (helper.getTaskInputMappings().containsKey(taskName)) {
                return Collections.unmodifiableMap(helper.getTaskInputMappings().get(taskName));
            }
        }
        return Collections.emptyMap();
    }

    public Map<String, String> getTaskOutputMappings(String deploymentId, String processId, String taskName) {
        if (StringUtils.isEmpty((CharSequence)deploymentId) || StringUtils.isEmpty((CharSequence)processId) || StringUtils.isEmpty((CharSequence)taskName)) {
            throw new IllegalStateException("The Process id cannot be Empty!");
        }
        if (this.definitionCache.containsKey(deploymentId)) {
            ProcessDescRepoHelper helper = this.definitionCache.get(deploymentId).get(processId);
            if (helper == null) {
                throw new IllegalStateException("No process available with given id : " + processId);
            }
            if (helper.getTaskOutputMappings().containsKey(taskName)) {
                return Collections.unmodifiableMap(helper.getTaskOutputMappings().get(taskName));
            }
        }
        return Collections.emptyMap();
    }
}

