/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.store;

import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jbpm.kie.services.impl.store.DeploymentSynchronizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentSyncInvoker {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentSyncInvoker.class);
    private ScheduledExecutorService executor;
    private Future<?> future;
    private final DeploymentSynchronizer synchronizer;
    private Long delay = 2L;
    private Long period = Long.parseLong(DeploymentSynchronizer.DEPLOY_SYNC_INTERVAL);
    private TimeUnit timeUnit = TimeUnit.SECONDS;

    public DeploymentSyncInvoker(DeploymentSynchronizer synchronizer) {
        this.synchronizer = synchronizer;
    }

    public DeploymentSyncInvoker(DeploymentSynchronizer synchronizer, Long delay, Long period, TimeUnit timeUnit) {
        this.synchronizer = synchronizer;
        this.delay = delay;
        this.period = period;
        this.timeUnit = timeUnit;
    }

    public void start() {
        logger.info("Starting deployment synchronization (delay {}, period {}, timeunit {})", new Object[]{this.delay, this.period, this.timeUnit});
        this.executor = Executors.newScheduledThreadPool(1);
        this.future = this.executor.scheduleAtFixedRate(new TriggerDeploymentSync(), this.delay, this.period, this.timeUnit);
        logger.info("Deployment synchronization started at {}", (Object)new Date());
    }

    public void stop() {
        logger.info("Shutting down deployment synchronization");
        if (this.executor != null) {
            if (this.future != null) {
                this.future.cancel(true);
            }
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                    this.executor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                logger.debug("Interrupted exception while waiting for executor shutdown");
            }
        }
        logger.info("Deployment synchronization stopped");
    }

    private class TriggerDeploymentSync
    implements Runnable {
        private TriggerDeploymentSync() {
        }

        @Override
        public void run() {
            try {
                DeploymentSyncInvoker.this.synchronizer.synchronize();
            }
            catch (Throwable e) {
                logger.warn("Exception while triggering deployments synchronization", e);
            }
        }
    }
}

