/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.query.jpa.data;

import org.jbpm.query.jpa.data.QueryCriteria;
import org.jbpm.query.jpa.data.QueryWhere;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.task.model.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQuerySerializationTest {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractQuerySerializationTest.class);

    abstract <T> T testRoundTrip(T var1) throws Exception;

    abstract void addSerializableClass(Class var1);

    @Before
    public void before() {
        this.addSerializableClass(Status.class);
    }

    @Test
    public void queryParameterTest() throws Exception {
        int i;
        QueryCriteria criteria = new QueryCriteria();
        criteria.setListId("one");
        criteria.setUnion(Boolean.valueOf(false));
        criteria.setType(QueryWhere.ParameterType.RANGE);
        Thread.sleep(1000L);
        criteria.addParameter((Object)Status.Ready);
        QueryCriteria copyCrit = this.testRoundTrip(criteria);
        Assert.assertEquals((String)"union", (Object)criteria.isUnion(), (Object)copyCrit.isUnion());
        Assert.assertEquals((String)"parameter type", (Object)criteria.getType(), (Object)copyCrit.getType());
        Assert.assertEquals((String)"value list size", (long)criteria.getParameters().size(), (long)copyCrit.getParameters().size());
        for (i = 0; i < criteria.getParameters().size(); ++i) {
            Assert.assertEquals((String)("value " + i), criteria.getParameters().get(i), copyCrit.getParameters().get(i));
        }
        criteria.getParameters().clear();
        criteria.getParameters().add(new Integer(23));
        criteria.getParameters().add(new Integer(42));
        criteria.getParameters().add(new Long(55555L));
        criteria.getParameters().add("ceci ce ne pas un string!");
        copyCrit = this.testRoundTrip(criteria);
        for (i = 0; i < criteria.getParameters().size(); ++i) {
            Assert.assertEquals((String)("value " + i), criteria.getParameters().get(i), copyCrit.getParameters().get(i));
        }
        QueryWhere queryWhere = new QueryWhere();
        queryWhere.addAppropriateParam("test", (Object[])new String[]{"asdf"});
        QueryWhere copyWhere = this.testRoundTrip(queryWhere);
        Assert.assertEquals((String)"union", (Object)queryWhere.isUnion(), (Object)copyWhere.isUnion());
        for (int i2 = 0; i2 < queryWhere.getCriteria().size(); ++i2) {
            QueryCriteria origCrit = (QueryCriteria)queryWhere.getCriteria().get(i2);
            copyCrit = (QueryCriteria)queryWhere.getCriteria().get(i2);
            for (int j = 0; j < origCrit.getParameters().size(); ++j) {
                Assert.assertEquals((String)("value " + i2), origCrit.getParameters().get(i2), copyCrit.getParameters().get(i2));
            }
        }
    }

    @Test
    public void nestedQueryParameterTest() throws Exception {
        QueryCriteria criteria = new QueryCriteria();
        criteria.setListId("one");
        criteria.setUnion(Boolean.valueOf(false));
        criteria.setType(QueryWhere.ParameterType.RANGE);
        QueryCriteria subCrit = new QueryCriteria();
        subCrit.addParameter((Object)Status.Ready);
        subCrit.setUnion(Boolean.valueOf(true));
        subCrit.setListId("sub one");
        criteria.addParameter((Object)subCrit);
        subCrit = new QueryCriteria();
        subCrit.addParameter((Object)Status.Completed);
        subCrit.setUnion(Boolean.valueOf(true));
        subCrit.setListId("sub two");
        criteria.addParameter((Object)subCrit);
        QueryCriteria copyCrit = this.testRoundTrip(criteria);
    }
}

