/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.ejb.test;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ejb.EJB;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.impl.store.DeploymentStore;
import org.jbpm.kie.services.test.objects.CountDownDeploymentListener;
import org.jbpm.services.api.DeploymentEventListener;
import org.jbpm.services.api.model.DeployedUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.ejb.api.DeploymentServiceEJBLocal;
import org.jbpm.services.ejb.impl.tx.TransactionalCommandServiceEJBImpl;
import org.jbpm.services.ejb.test.AbstractTestSupport;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.scanner.KieMavenRepository;

@RunWith(value=Arquillian.class)
public class DeploymentServiceEJBWithSyncIntegrationTest
extends AbstractTestSupport {
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    @EJB
    private DeploymentServiceEJBLocal deploymentService;
    @EJB(beanInterface=TransactionalCommandServiceEJBImpl.class)
    private TransactionalCommandService commandService;

    @After
    public void cleanup() {
        DeploymentServiceEJBWithSyncIntegrationTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                this.deploymentService.undeploy(unit);
            }
            this.units.clear();
        }
    }

    @Deployment
    public static WebArchive createDeployment() {
        File archive = new File("target/sample-war-ejb-app.war");
        if (!archive.exists()) {
            throw new IllegalStateException("There is no archive yet generated, run maven build or mvn assembly:assembly");
        }
        WebArchive war = (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)archive);
        war.addPackage("org.jbpm.services.ejb.test");
        war.addClass("org.jbpm.kie.services.test.objects.CountDownDeploymentListener");
        DeploymentServiceEJBWithSyncIntegrationTest.deployKjar();
        return war;
    }

    protected static void deployKjar() {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("processes/customtask.bpmn");
        processes.add("processes/humanTask.bpmn");
        processes.add("processes/signal.bpmn");
        processes.add("processes/import.bpmn");
        processes.add("processes/callactivity.bpmn");
        InternalKieModule kJar1 = DeploymentServiceEJBWithSyncIntegrationTest.createKieJar(ks, releaseId, processes);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(DeploymentServiceEJBWithSyncIntegrationTest.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.installArtifact((AFReleaseId)releaseId, kJar1, pom);
        ReleaseId releaseIdSupport = ks.newReleaseId("org.jbpm.test", "support", "1.0.0");
        ArrayList<String> processesSupport = new ArrayList<String>();
        processesSupport.add("processes/support.bpmn");
        InternalKieModule kJar2 = DeploymentServiceEJBWithSyncIntegrationTest.createKieJar(ks, releaseIdSupport, processesSupport);
        File pom2 = new File("target/kmodule2", "pom.xml");
        pom2.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom2);
            fs.write(DeploymentServiceEJBWithSyncIntegrationTest.getPom(releaseIdSupport, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        repository.installArtifact((AFReleaseId)releaseIdSupport, kJar2, pom2);
    }

    protected CountDownDeploymentListener configureListener(int threads) {
        CountDownDeploymentListener countDownListener = new CountDownDeploymentListener(threads);
        this.deploymentService.addListener((DeploymentEventListener)countDownListener);
        return countDownListener;
    }

    @Test
    public void testDeploymentOfProcessesBySync() throws Exception {
        CountDownDeploymentListener countDownListener = this.configureListener(1);
        DeploymentStore store = new DeploymentStore();
        store.setCommandService(this.commandService);
        Collection deployed = this.deploymentService.getDeployedUnits();
        Assert.assertNotNull((Object)deployed);
        Assert.assertEquals((long)0L, (long)deployed.size());
        KModuleDeploymentUnit unit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        store.enableDeploymentUnit((DeploymentUnit)unit);
        this.units.add((DeploymentUnit)unit);
        countDownListener.waitTillCompleted(10000L);
        deployed = this.deploymentService.getDeployedUnits();
        Assert.assertNotNull((Object)deployed);
        Assert.assertEquals((long)1L, (long)deployed.size());
    }

    @Test
    public void testUndeploymentOfProcessesBySync() throws Exception {
        CountDownDeploymentListener countDownListener = this.configureListener(2);
        DeploymentStore store = new DeploymentStore();
        store.setCommandService(this.commandService);
        Collection deployed = this.deploymentService.getDeployedUnits();
        Assert.assertNotNull((Object)deployed);
        Assert.assertEquals((long)0L, (long)deployed.size());
        KModuleDeploymentUnit unit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)unit);
        this.units.add((DeploymentUnit)unit);
        deployed = this.deploymentService.getDeployedUnits();
        Assert.assertNotNull((Object)deployed);
        Assert.assertEquals((long)1L, (long)deployed.size());
        countDownListener.waitTillCompleted(1000L);
        store.disableDeploymentUnit((DeploymentUnit)unit);
        countDownListener.waitTillCompleted(10000L);
        deployed = this.deploymentService.getDeployedUnits();
        Assert.assertNotNull((Object)deployed);
        Assert.assertEquals((long)0L, (long)deployed.size());
    }

    @Test
    public void testDeactivateAndActivateOfProcessesBySync() throws Exception {
        CountDownDeploymentListener countDownListener = this.configureListener(2);
        DeploymentStore store = new DeploymentStore();
        store.setCommandService(this.commandService);
        Collection deployed = this.deploymentService.getDeployedUnits();
        Assert.assertNotNull((Object)deployed);
        Assert.assertEquals((long)0L, (long)deployed.size());
        KModuleDeploymentUnit unit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)unit);
        this.units.add((DeploymentUnit)unit);
        deployed = this.deploymentService.getDeployedUnits();
        Assert.assertNotNull((Object)deployed);
        Assert.assertEquals((long)1L, (long)deployed.size());
        Assert.assertTrue((boolean)((DeployedUnit)deployed.iterator().next()).isActive());
        store.deactivateDeploymentUnit((DeploymentUnit)unit);
        countDownListener.waitTillCompleted(10000L);
        deployed = this.deploymentService.getDeployedUnits();
        Assert.assertNotNull((Object)deployed);
        Assert.assertEquals((long)1L, (long)deployed.size());
        Assert.assertFalse((boolean)((DeployedUnit)deployed.iterator().next()).isActive());
        store.activateDeploymentUnit((DeploymentUnit)unit);
        countDownListener.reset(1);
        countDownListener.waitTillCompleted(10000L);
        deployed = this.deploymentService.getDeployedUnits();
        Assert.assertNotNull((Object)deployed);
        Assert.assertEquals((long)1L, (long)deployed.size());
        Assert.assertTrue((boolean)((DeployedUnit)deployed.iterator().next()).isActive());
    }
}

