/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.ejb.test;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.EJBException;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.ejb.api.DefinitionServiceEJBLocal;
import org.jbpm.services.ejb.api.DeploymentServiceEJBLocal;
import org.jbpm.services.ejb.api.ProcessServiceEJBLocal;
import org.jbpm.services.ejb.api.RuntimeDataServiceEJBLocal;
import org.jbpm.services.ejb.test.AbstractTestSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.internal.runtime.manager.SessionNotFoundException;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorImpl;
import org.kie.scanner.KieMavenRepository;

@RunWith(value=Arquillian.class)
public class MultipleDeploymentsProcessServiceEJBIntegrationTest
extends AbstractTestSupport {
    protected static final String ARTIFACT_ID2 = "second-test-module";
    protected static final String GROUP_ID2 = "org.jbpm.test";
    protected static final String VERSION2 = "1.0.0";
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    @EJB
    private DefinitionServiceEJBLocal bpmn2Service;
    @EJB
    private DeploymentServiceEJBLocal deploymentService;
    @EJB
    private ProcessServiceEJBLocal processService;
    @EJB
    private RuntimeDataServiceEJBLocal runtimeDataService;

    @Deployment
    public static WebArchive createDeployment() {
        File archive = new File("target/sample-war-ejb-app.war");
        if (!archive.exists()) {
            throw new IllegalStateException("There is no archive yet generated, run maven build or mvn assembly:assembly");
        }
        WebArchive war = (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)archive);
        war.addPackage("org.jbpm.services.ejb.test");
        MultipleDeploymentsProcessServiceEJBIntegrationTest.deployKjar();
        return war;
    }

    protected static void deployKjar() {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId(GROUP_ID2, "test-module", VERSION2);
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("processes/signal.bpmn");
        processes.add("processes/import.bpmn");
        InternalKieModule kJar1 = MultipleDeploymentsProcessServiceEJBIntegrationTest.createKieJar(ks, releaseId, processes);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(MultipleDeploymentsProcessServiceEJBIntegrationTest.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        ReleaseId releaseId2 = ks.newReleaseId(GROUP_ID2, ARTIFACT_ID2, VERSION2);
        ArrayList<String> processes2 = new ArrayList<String>();
        processes2.add("processes/customtask.bpmn");
        processes2.add("processes/humanTask.bpmn");
        InternalKieModule kJar2 = MultipleDeploymentsProcessServiceEJBIntegrationTest.createKieJar(ks, releaseId2, processes2);
        File pom2 = new File("target/kmodule2", "pom.xml");
        pom2.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom2);
            fs.write(MultipleDeploymentsProcessServiceEJBIntegrationTest.getPom(releaseId2, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.installArtifact((AFReleaseId)releaseId, kJar1, pom);
        repository.installArtifact((AFReleaseId)releaseId2, kJar2, pom2);
    }

    @After
    public void cleanup() {
        MultipleDeploymentsProcessServiceEJBIntegrationTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                this.deploymentService.undeploy(unit);
            }
            this.units.clear();
        }
    }

    @Test
    public void testStartProcessFromDifferentDeployments() {
        block5: {
            KModuleDeploymentUnit deploymentUnit2;
            block4: {
                Assert.assertNotNull((Object)this.deploymentService);
                DeploymentDescriptorImpl customDescriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
                customDescriptor.getBuilder().runtimeStrategy(RuntimeStrategy.PER_PROCESS_INSTANCE);
                KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit(GROUP_ID2, "test-module", VERSION2);
                deploymentUnit.setDeploymentDescriptor((DeploymentDescriptor)customDescriptor);
                this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
                this.units.add((DeploymentUnit)deploymentUnit);
                DeploymentDescriptorImpl customDescriptor2 = new DeploymentDescriptorImpl("org.jbpm.domain");
                customDescriptor.getBuilder().runtimeStrategy(RuntimeStrategy.PER_PROCESS_INSTANCE);
                deploymentUnit2 = new KModuleDeploymentUnit(GROUP_ID2, ARTIFACT_ID2, VERSION2);
                deploymentUnit2.setDeploymentDescriptor((DeploymentDescriptor)customDescriptor2);
                this.deploymentService.deploy((DeploymentUnit)deploymentUnit2);
                this.units.add((DeploymentUnit)deploymentUnit2);
                boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
                Assert.assertTrue((boolean)isDeployed);
                isDeployed = this.deploymentService.isDeployed(deploymentUnit2.getIdentifier());
                Assert.assertTrue((boolean)isDeployed);
                Assert.assertNotNull((Object)this.processService);
                long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "Import");
                Assert.assertNotNull((Object)processInstanceId);
                try {
                    ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
                    Assert.assertNull((Object)pi);
                }
                catch (EJBException e) {
                    if (e.getCause() instanceof SessionNotFoundException) break block4;
                    throw e;
                }
            }
            long processInstanceId2 = this.processService.startProcess(deploymentUnit2.getIdentifier(), "customtask");
            Assert.assertNotNull((Object)processInstanceId2);
            try {
                ProcessInstance pi2 = this.processService.getProcessInstance(Long.valueOf(processInstanceId2));
                Assert.assertNull((Object)pi2);
            }
            catch (EJBException e) {
                if (e.getCause() instanceof SessionNotFoundException) break block5;
                throw e;
            }
        }
    }
}

