/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.ejb.test;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.EJB;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.command.runtime.process.GetProcessInstanceCommand;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.jbpm.services.ejb.api.DefinitionServiceEJBLocal;
import org.jbpm.services.ejb.api.DeploymentServiceEJBLocal;
import org.jbpm.services.ejb.api.ProcessServiceEJBLocal;
import org.jbpm.services.ejb.api.RuntimeDataServiceEJBLocal;
import org.jbpm.services.ejb.test.AbstractTestSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.command.Command;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.query.QueryContext;
import org.kie.internal.KieInternalServices;
import org.kie.internal.process.CorrelationKey;
import org.kie.scanner.KieMavenRepository;

@RunWith(value=Arquillian.class)
public class ProcessServiceEJBIntegrationTest
extends AbstractTestSupport {
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    @EJB
    private DefinitionServiceEJBLocal bpmn2Service;
    @EJB
    private DeploymentServiceEJBLocal deploymentService;
    @EJB
    private ProcessServiceEJBLocal processService;
    @EJB
    private RuntimeDataServiceEJBLocal runtimeDataService;

    @Deployment
    public static WebArchive createDeployment() {
        File archive = new File("target/sample-war-ejb-app.war");
        if (!archive.exists()) {
            throw new IllegalStateException("There is no archive yet generated, run maven build or mvn assembly:assembly");
        }
        WebArchive war = (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)archive);
        war.addPackage("org.jbpm.services.ejb.test");
        ProcessServiceEJBIntegrationTest.deployKjar();
        return war;
    }

    protected static void deployKjar() {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("processes/customtask.bpmn");
        processes.add("processes/humanTask.bpmn");
        processes.add("processes/signal.bpmn");
        processes.add("processes/signalWithExpression.bpmn2");
        processes.add("processes/import.bpmn");
        InternalKieModule kJar1 = ProcessServiceEJBIntegrationTest.createKieJar(ks, releaseId, processes);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(ProcessServiceEJBIntegrationTest.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.installArtifact((AFReleaseId)releaseId, kJar1, pom);
    }

    @After
    public void cleanup() {
        ProcessServiceEJBIntegrationTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                this.deploymentService.undeploy(unit);
            }
            this.units.clear();
        }
    }

    @Test
    public void testStartProcess() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "customtask");
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartProcessWithParms() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", "test");
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "customtask", params);
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartProcessWithCorrelationKey() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
        CorrelationKey key = KieInternalServices.Factory.get().newCorrelationKeyFactory().newCorrelationKey("my business key");
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "customtask", key);
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(key);
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartProcessWithParmsWithCorrelationKey() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", "test");
        CorrelationKey key = KieInternalServices.Factory.get().newCorrelationKeyFactory().newCorrelationKey("my business key");
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "customtask", key, params);
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(key);
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartAndAbortProcess() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)pi);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartAndAbortProcesses() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId1 = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)processInstanceId1);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId1));
        Assert.assertNotNull((Object)pi);
        long processInstanceId2 = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)processInstanceId2);
        ProcessInstance pi2 = this.processService.getProcessInstance(Long.valueOf(processInstanceId2));
        Assert.assertNotNull((Object)pi2);
        ArrayList<Long> instances = new ArrayList<Long>();
        instances.add(processInstanceId1);
        instances.add(processInstanceId2);
        this.processService.abortProcessInstances(instances);
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId1));
        Assert.assertNull((Object)pi);
        pi2 = this.processService.getProcessInstance(Long.valueOf(processInstanceId2));
        Assert.assertNull((Object)pi2);
    }

    @Test
    public void testStartAndSignalProcess() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "signal");
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)pi);
        Collection signals = this.processService.getAvailableSignals(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)signals);
        Assert.assertEquals((long)1L, (long)signals.size());
        Assert.assertTrue((boolean)signals.contains("MySignal"));
        this.processService.signalProcessInstance(Long.valueOf(processInstanceId), "MySignal", null);
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartAndSignalProcesses() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId1 = this.processService.startProcess(deploymentUnit.getIdentifier(), "signal");
        Assert.assertNotNull((Object)processInstanceId1);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId1));
        Assert.assertNotNull((Object)pi);
        long processInstanceId2 = this.processService.startProcess(deploymentUnit.getIdentifier(), "signal");
        Assert.assertNotNull((Object)processInstanceId2);
        ProcessInstance pi2 = this.processService.getProcessInstance(Long.valueOf(processInstanceId2));
        Assert.assertNotNull((Object)pi2);
        ArrayList<Long> instances = new ArrayList<Long>();
        instances.add(processInstanceId1);
        instances.add(processInstanceId2);
        this.processService.signalProcessInstances(instances, "MySignal", null);
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId1));
        Assert.assertNull((Object)pi);
        pi2 = this.processService.getProcessInstance(Long.valueOf(processInstanceId2));
        Assert.assertNull((Object)pi2);
    }

    @Test
    public void testStartAndSignalProcessesWithExpression() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId1 = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.signalWithExpression");
        Assert.assertNotNull((Object)processInstanceId1);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId1));
        Assert.assertNotNull((Object)pi);
        long processInstanceId2 = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.signalWithExpression");
        Assert.assertNotNull((Object)processInstanceId2);
        ProcessInstance pi2 = this.processService.getProcessInstance(Long.valueOf(processInstanceId2));
        Assert.assertNotNull((Object)pi2);
        ArrayList<Long> instances = new ArrayList<Long>();
        instances.add(processInstanceId1);
        instances.add(processInstanceId2);
        this.processService.signalProcessInstances(instances, "MySignal", null);
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId1));
        Assert.assertNull((Object)pi);
        pi2 = this.processService.getProcessInstance(Long.valueOf(processInstanceId2));
        Assert.assertNull((Object)pi2);
    }

    @Test
    public void testStartAndSignal() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "signal");
        Assert.assertNotNull((Object)processInstanceId);
        long processInstanceId2 = this.processService.startProcess(deploymentUnit.getIdentifier(), "signal");
        Assert.assertNotNull((Object)processInstanceId2);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)pi);
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId2));
        Assert.assertNotNull((Object)pi);
        this.processService.signalEvent(deploymentUnit.getIdentifier(), "MySignal", null);
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId2));
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartProcessAndChangeVariables() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "test");
        params.put("approval_reviewComment", "need review");
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)pi);
        Object variableValue = this.processService.getProcessInstanceVariable(Long.valueOf(processInstanceId), "approval_document");
        Assert.assertNotNull((Object)variableValue);
        Assert.assertTrue((boolean)(variableValue instanceof String));
        Assert.assertEquals((Object)"test", (Object)variableValue);
        Map variables = this.processService.getProcessInstanceVariables(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)variables);
        Assert.assertEquals((long)2L, (long)variables.size());
        Assert.assertTrue((boolean)variables.containsKey("approval_document"));
        Assert.assertTrue((boolean)variables.containsKey("approval_reviewComment"));
        Assert.assertEquals((Object)"test", variables.get("approval_document"));
        Assert.assertEquals((Object)"need review", variables.get("approval_reviewComment"));
        this.processService.setProcessVariable(Long.valueOf(processInstanceId), "approval_reviewComment", (Object)"updated review comment");
        variableValue = this.processService.getProcessInstanceVariable(Long.valueOf(processInstanceId), "approval_reviewComment");
        Assert.assertNotNull((Object)variableValue);
        Assert.assertTrue((boolean)(variableValue instanceof String));
        Assert.assertEquals((Object)"updated review comment", (Object)variableValue);
        params = new HashMap();
        params.put("approval_document", "updated document");
        params.put("approval_reviewComment", "final review");
        this.processService.setProcessVariables(Long.valueOf(processInstanceId), params);
        variables = this.processService.getProcessInstanceVariables(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)variables);
        Assert.assertEquals((long)2L, (long)variables.size());
        Assert.assertTrue((boolean)variables.containsKey("approval_document"));
        Assert.assertTrue((boolean)variables.containsKey("approval_reviewComment"));
        Assert.assertEquals((Object)"updated document", variables.get("approval_document"));
        Assert.assertEquals((Object)"final review", variables.get("approval_reviewComment"));
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartProcessAndCompleteWorkItem() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)pi);
        Collection activeNodes = this.runtimeDataService.getProcessInstanceHistoryActive(processInstanceId, new QueryContext());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)1L, (long)activeNodes.size());
        Assert.assertEquals((Object)"Write a Document", (Object)((NodeInstanceDesc)activeNodes.iterator().next()).getName());
        HashMap<String, String> outcome = new HashMap<String, String>();
        outcome.put("Result", "here is my first document");
        this.processService.completeWorkItem(((NodeInstanceDesc)activeNodes.iterator().next()).getWorkItemId(), outcome);
        activeNodes = this.runtimeDataService.getProcessInstanceHistoryActive(processInstanceId, new QueryContext());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)2L, (long)activeNodes.size());
        Object variableValue = this.processService.getProcessInstanceVariable(Long.valueOf(processInstanceId), "approval_document");
        Assert.assertNotNull((Object)variableValue);
        Assert.assertTrue((boolean)(variableValue instanceof String));
        Assert.assertEquals((Object)"here is my first document", (Object)variableValue);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartProcessAndAbortWorkItem() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)pi);
        Collection activeNodes = this.runtimeDataService.getProcessInstanceHistoryActive(processInstanceId, new QueryContext());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)1L, (long)activeNodes.size());
        Assert.assertEquals((Object)"Write a Document", (Object)((NodeInstanceDesc)activeNodes.iterator().next()).getName());
        this.processService.abortWorkItem(((NodeInstanceDesc)activeNodes.iterator().next()).getWorkItemId());
        activeNodes = this.runtimeDataService.getProcessInstanceHistoryActive(processInstanceId, new QueryContext());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)2L, (long)activeNodes.size());
        Object variableValue = this.processService.getProcessInstanceVariable(Long.valueOf(processInstanceId), "approval_document");
        Assert.assertNull((Object)variableValue);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartProcessAndGetWorkItem() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)pi);
        Collection activeNodes = this.runtimeDataService.getProcessInstanceHistoryActive(processInstanceId, new QueryContext());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)1L, (long)activeNodes.size());
        Assert.assertEquals((Object)"Write a Document", (Object)((NodeInstanceDesc)activeNodes.iterator().next()).getName());
        WorkItem wi = this.processService.getWorkItem(((NodeInstanceDesc)activeNodes.iterator().next()).getWorkItemId());
        Assert.assertNotNull((Object)wi);
        Assert.assertEquals((Object)"Human Task", (Object)wi.getName());
        Assert.assertEquals((Object)"Write a Document", (Object)wi.getParameter("NodeName"));
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartProcessAndGetWorkItems() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)pi);
        Collection activeNodes = this.runtimeDataService.getProcessInstanceHistoryActive(processInstanceId, new QueryContext());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)1L, (long)activeNodes.size());
        Assert.assertEquals((Object)"Write a Document", (Object)((NodeInstanceDesc)activeNodes.iterator().next()).getName());
        List wis = this.processService.getWorkItemByProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)wis);
        Assert.assertEquals((long)1L, (long)wis.size());
        Assert.assertEquals((Object)"Human Task", (Object)((WorkItem)wis.get(0)).getName());
        Assert.assertEquals((Object)"Write a Document", (Object)((WorkItem)wis.get(0)).getParameter("NodeName"));
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartProcessAndExecuteCmd() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = (ProcessInstance)this.processService.execute(deploymentUnit.getIdentifier(), (Command)new GetProcessInstanceCommand(Long.valueOf(processInstanceId)));
        Assert.assertNotNull((Object)pi);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
    }

    @Test
    public void testStartProcessAfterDeactivation() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        this.deploymentService.deactivate(deploymentUnit.getIdentifier());
        try {
            this.processService.startProcess(deploymentUnit.getIdentifier(), "customtask");
            Assert.fail((String)"Deployment is deactivated so cannot start new process instances");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"org.jbpm.services.api.DeploymentActiveFoundException: Deployment org.jbpm.test:test-module:1.0.0 is not active", (Object)e.getMessage());
        }
    }

    @Test
    public void testStartProcessAndCompleteWorkItemAfterDeactivation() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        boolean isDeployed = this.deploymentService.isDeployed(deploymentUnit.getIdentifier());
        Assert.assertTrue((boolean)isDeployed);
        Assert.assertNotNull((Object)this.processService);
        long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNotNull((Object)pi);
        this.deploymentService.deactivate(deploymentUnit.getIdentifier());
        Collection activeNodes = this.runtimeDataService.getProcessInstanceHistoryActive(processInstanceId, new QueryContext());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)1L, (long)activeNodes.size());
        Assert.assertEquals((Object)"Write a Document", (Object)((NodeInstanceDesc)activeNodes.iterator().next()).getName());
        HashMap<String, String> outcome = new HashMap<String, String>();
        outcome.put("Result", "here is my first document");
        this.processService.completeWorkItem(((NodeInstanceDesc)activeNodes.iterator().next()).getWorkItemId(), outcome);
        activeNodes = this.runtimeDataService.getProcessInstanceHistoryActive(processInstanceId, new QueryContext());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)2L, (long)activeNodes.size());
        Object variableValue = this.processService.getProcessInstanceVariable(Long.valueOf(processInstanceId), "approval_document");
        Assert.assertNotNull((Object)variableValue);
        Assert.assertTrue((boolean)(variableValue instanceof String));
        Assert.assertEquals((Object)"here is my first document", (Object)variableValue);
        this.processService.abortProcessInstance(Long.valueOf(processInstanceId));
        pi = this.processService.getProcessInstance(Long.valueOf(processInstanceId));
        Assert.assertNull((Object)pi);
    }
}

