/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.ejb.test;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.ejb.EJB;
import javax.inject.Inject;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.jbpm.services.api.model.UserTaskInstanceDesc;
import org.jbpm.services.ejb.api.DeploymentServiceEJBLocal;
import org.jbpm.services.ejb.api.ProcessServiceEJBLocal;
import org.jbpm.services.ejb.api.RuntimeDataServiceEJBLocal;
import org.jbpm.services.ejb.impl.tx.TransactionalCommandServiceEJBImpl;
import org.jbpm.services.ejb.test.AbstractTestSupport;
import org.jbpm.services.ejb.test.identity.TestIdentityProvider;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.shared.services.impl.commands.UpdateStringCommand;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.command.Command;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.model.Status;
import org.kie.internal.KieInternalServices;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.query.QueryFilter;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorImpl;
import org.kie.scanner.KieMavenRepository;

@RunWith(value=Arquillian.class)
public class RuntimeDataServiceImplSecurityTest
extends AbstractTestSupport {
    private Long processInstanceId = null;
    private KModuleDeploymentUnit deploymentUnit = null;
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    @EJB
    private DeploymentServiceEJBLocal deploymentService;
    @EJB
    private ProcessServiceEJBLocal processService;
    @EJB
    private RuntimeDataServiceEJBLocal runtimeDataService;
    @EJB(beanInterface=TransactionalCommandServiceEJBImpl.class)
    private TransactionalCommandService commandService;
    @Inject
    private TestIdentityProvider identityProvider;

    @Deployment
    public static WebArchive createDeployment() {
        File archive = new File("target/sample-war-ejb-app.war");
        if (!archive.exists()) {
            throw new IllegalStateException("There is no archive yet generated, run maven build or mvn assembly:assembly");
        }
        WebArchive war = (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)archive);
        war.addPackage("org.jbpm.services.ejb.test");
        war.addPackage("org.jbpm.services.ejb.test.identity");
        RuntimeDataServiceImplSecurityTest.deployKjar();
        return war;
    }

    @Before
    public void prepare() {
        Assert.assertNotNull((Object)this.deploymentService);
        this.deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0");
        this.deploymentService.deploy((DeploymentUnit)this.deploymentUnit);
        this.units.add((DeploymentUnit)this.deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
    }

    protected static void deployKjar() {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("processes/EmptyHumanTask.bpmn");
        processes.add("processes/humanTask.bpmn");
        processes.add("processes/SimpleHTProcess.bpmn2");
        DeploymentDescriptorImpl customDescriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        customDescriptor.getBuilder().addRequiredRole("view:managers");
        HashMap<String, String> resources = new HashMap<String, String>();
        resources.put("src/main/resources/META-INF/kie-deployment-descriptor.xml", customDescriptor.toXml());
        InternalKieModule kJar1 = RuntimeDataServiceImplSecurityTest.createKieJar(ks, releaseId, processes, resources);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(RuntimeDataServiceImplSecurityTest.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.installArtifact((AFReleaseId)releaseId, kJar1, pom);
    }

    @After
    public void cleanup() {
        if (this.processInstanceId != null) {
            this.processService.abortProcessInstance(this.processInstanceId);
            ProcessInstance pi = this.processService.getProcessInstance(this.processInstanceId);
            Assert.assertNull((Object)pi);
        }
        int deleted = 0;
        deleted += ((Integer)this.commandService.execute((Command)new UpdateStringCommand("delete from  NodeInstanceLog nid"))).intValue();
        deleted += ((Integer)this.commandService.execute((Command)new UpdateStringCommand("delete from  ProcessInstanceLog pid"))).intValue();
        deleted += ((Integer)this.commandService.execute((Command)new UpdateStringCommand("delete from  VariableInstanceLog vsd"))).intValue();
        System.out.println("Deleted " + (deleted += ((Integer)this.commandService.execute((Command)new UpdateStringCommand("delete from  AuditTaskImpl vsd"))).intValue()));
        RuntimeDataServiceImplSecurityTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                this.deploymentService.undeploy(unit);
            }
            this.units.clear();
        }
    }

    @Test
    public void testGetProcessInstances() {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("managers");
        this.identityProvider.setRoles(roles);
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)1L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)3L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
    }

    @Test
    public void testGetProcessInstancesByState() {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("managers");
        this.identityProvider.setRoles(roles);
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(3);
        instances = this.runtimeDataService.getProcessInstances(states, null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstances(states, null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)3L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
    }

    @Test
    public void testGetProcessInstancesByDeploymentIdAndState() {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("managers");
        this.identityProvider.setRoles(roles);
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(3);
        instances = this.runtimeDataService.getProcessInstancesByDeploymentId(this.deploymentUnit.getIdentifier(), states, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstancesByDeploymentId(this.deploymentUnit.getIdentifier(), states, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)3L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
    }

    @Test
    public void testGetProcessInstancesByProcessId() {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("managers");
        this.identityProvider.setRoles(roles);
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        instances = this.runtimeDataService.getProcessInstancesByProcessDefinition("org.jbpm.writedocument", new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        ProcessInstanceDesc instance = (ProcessInstanceDesc)instances.iterator().next();
        Assert.assertEquals((long)1L, (long)instance.getState().intValue());
        Assert.assertEquals((Object)"org.jbpm.writedocument", (Object)instance.getProcessId());
        List taskSummaries = this.runtimeDataService.getTasksAssignedAsPotentialOwner("salaboy", new QueryFilter(0, 10));
        Assert.assertNotNull((Object)taskSummaries);
        Assert.assertEquals((long)1L, (long)taskSummaries.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstancesByProcessDefinition("org.jbpm.writedocument", new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        instance = (ProcessInstanceDesc)instances.iterator().next();
        Assert.assertEquals((long)3L, (long)instance.getState().intValue());
        Assert.assertEquals((Object)"org.jbpm.writedocument", (Object)instance.getProcessId());
    }

    @Test
    public void testGetProcessInstanceById() {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("managers");
        this.identityProvider.setRoles(roles);
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ProcessInstanceDesc instance = this.runtimeDataService.getProcessInstanceById(this.processInstanceId.longValue());
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((long)1L, (long)instance.getState().intValue());
        Assert.assertEquals((Object)"org.jbpm.writedocument", (Object)instance.getProcessId());
        List tasks = instance.getActiveTasks();
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        UserTaskInstanceDesc activeTask = (UserTaskInstanceDesc)tasks.get(0);
        Assert.assertNotNull((Object)activeTask);
        Assert.assertEquals((Object)Status.Reserved.name(), (Object)activeTask.getStatus());
        Assert.assertEquals((Object)instance.getId(), (Object)activeTask.getProcessInstanceId());
        Assert.assertEquals((Object)instance.getProcessId(), (Object)activeTask.getProcessId());
        Assert.assertEquals((Object)"Write a Document", (Object)activeTask.getName());
        Assert.assertEquals((Object)"salaboy", (Object)activeTask.getActualOwner());
        Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)activeTask.getDeploymentId());
        this.processService.abortProcessInstance(this.processInstanceId);
        instance = this.runtimeDataService.getProcessInstanceById(this.processInstanceId.longValue());
        this.processInstanceId = null;
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((long)3L, (long)instance.getState().intValue());
        Assert.assertEquals((Object)"org.jbpm.writedocument", (Object)instance.getProcessId());
    }

    @Test
    public void testGetProcessInstancesByProcessIdAndState() {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("managers");
        this.identityProvider.setRoles(roles);
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(3);
        instances = this.runtimeDataService.getProcessInstancesByProcessId(states, "org.jbpm.writedocument", null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstancesByProcessId(states, "org.jbpm.writedocument", null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)3L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
    }

    @Test
    public void testGetProcessInstancesByPartialProcessIdAndState() {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("managers");
        this.identityProvider.setRoles(roles);
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(3);
        instances = this.runtimeDataService.getProcessInstancesByProcessId(states, "org.jbpm%", null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstancesByProcessId(states, "org.jbpm%", null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)3L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
    }

    @Test
    public void testGetProcessInstancesNoAccess() {
        ArrayList<String> roles = new ArrayList<String>();
        this.identityProvider.setRoles(roles);
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
    }

    @Test
    public void testGetProcessInstancesByStateNoAccess() {
        ArrayList<String> roles = new ArrayList<String>();
        this.identityProvider.setRoles(roles);
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(3);
        instances = this.runtimeDataService.getProcessInstances(states, null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstances(states, null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
    }

    @Test
    public void testGetProcessInstancesByDeploymentIdAndStateNoAccess() {
        ArrayList<String> roles = new ArrayList<String>();
        this.identityProvider.setRoles(roles);
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(3);
        instances = this.runtimeDataService.getProcessInstancesByDeploymentId(this.deploymentUnit.getIdentifier(), states, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstancesByDeploymentId(this.deploymentUnit.getIdentifier(), states, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
    }

    @Test
    public void testGetProcessInstancesByProcessIdNoAccess() {
        ArrayList<String> roles = new ArrayList<String>();
        this.identityProvider.setRoles(roles);
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        instances = this.runtimeDataService.getProcessInstancesByProcessDefinition("org.jbpm.writedocument", new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstancesByProcessDefinition("org.jbpm.writedocument", new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
    }

    @Test
    public void testGetProcessInstanceByIdNoAccess() {
        ArrayList<String> roles = new ArrayList<String>();
        this.identityProvider.setRoles(roles);
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ProcessInstanceDesc instance = this.runtimeDataService.getProcessInstanceById(this.processInstanceId.longValue());
        Assert.assertNotNull((Object)instance);
        this.processService.abortProcessInstance(this.processInstanceId);
        instance = this.runtimeDataService.getProcessInstanceById(this.processInstanceId.longValue());
        this.processInstanceId = null;
        Assert.assertNotNull((Object)instance);
    }

    @Test
    public void testGetProcessInstancesByProcessIdAndStateNoAccess() {
        ArrayList<String> roles = new ArrayList<String>();
        this.identityProvider.setRoles(roles);
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(3);
        instances = this.runtimeDataService.getProcessInstancesByProcessId(states, "org.jbpm.writedocument", null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstancesByProcessId(states, "org.jbpm.writedocument", null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
    }

    @Test
    public void testGetProcessInstancesByPartialProcessIdAndStateNoAccess() {
        ArrayList<String> roles = new ArrayList<String>();
        this.identityProvider.setRoles(roles);
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(3);
        instances = this.runtimeDataService.getProcessInstancesByProcessId(states, "org.jbpm%", null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = this.runtimeDataService.getProcessInstancesByProcessId(states, "org.jbpm%", null, new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
    }

    @Test
    public void testGetProcessInstanceByCorrelationKey() {
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        CorrelationKey key = KieInternalServices.Factory.get().newCorrelationKeyFactory().newCorrelationKey("my business key");
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument", key);
        Assert.assertNotNull((Object)this.processInstanceId);
        ProcessInstanceDesc instance = this.runtimeDataService.getProcessInstanceByCorrelationKey(key);
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((long)1L, (long)instance.getState().intValue());
        Assert.assertEquals((Object)"org.jbpm.writedocument", (Object)instance.getProcessId());
        Assert.assertEquals((Object)"my business key", (Object)instance.getCorrelationKey());
        List tasks = instance.getActiveTasks();
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        UserTaskInstanceDesc activeTask = (UserTaskInstanceDesc)tasks.get(0);
        Assert.assertNotNull((Object)activeTask);
        Assert.assertEquals((Object)Status.Reserved.name(), (Object)activeTask.getStatus());
        Assert.assertEquals((Object)instance.getId(), (Object)activeTask.getProcessInstanceId());
        Assert.assertEquals((Object)instance.getProcessId(), (Object)activeTask.getProcessId());
        Assert.assertEquals((Object)"Write a Document", (Object)activeTask.getName());
        Assert.assertEquals((Object)"salaboy", (Object)activeTask.getActualOwner());
        Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)activeTask.getDeploymentId());
        this.processService.abortProcessInstance(this.processInstanceId);
        instance = this.runtimeDataService.getProcessInstanceByCorrelationKey(key);
        this.processInstanceId = null;
        Assert.assertNull((Object)instance);
    }

    @Test
    public void testGetProcessInstancesByCorrelationKey() {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("managers");
        this.identityProvider.setRoles(roles);
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        CorrelationKey key = KieInternalServices.Factory.get().newCorrelationKeyFactory().newCorrelationKey("my business key");
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument", key);
        Assert.assertNotNull((Object)this.processInstanceId);
        Collection keyedInstances = this.runtimeDataService.getProcessInstancesByCorrelationKey(key, new QueryContext());
        Assert.assertNotNull((Object)keyedInstances);
        Assert.assertEquals((long)1L, (long)keyedInstances.size());
        ProcessInstanceDesc instance = (ProcessInstanceDesc)keyedInstances.iterator().next();
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((long)1L, (long)instance.getState().intValue());
        Assert.assertEquals((Object)"org.jbpm.writedocument", (Object)instance.getProcessId());
        Assert.assertEquals((Object)"my business key", (Object)instance.getCorrelationKey());
        List tasks = instance.getActiveTasks();
        Assert.assertNull((Object)tasks);
        this.processService.abortProcessInstance(this.processInstanceId);
        instance = this.runtimeDataService.getProcessInstanceByCorrelationKey(key);
        this.processInstanceId = null;
        Assert.assertNull((Object)instance);
        keyedInstances = this.runtimeDataService.getProcessInstancesByCorrelationKey(key, new QueryContext());
        Assert.assertNotNull((Object)keyedInstances);
        Assert.assertEquals((long)1L, (long)keyedInstances.size());
        instance = (ProcessInstanceDesc)keyedInstances.iterator().next();
        Assert.assertEquals((long)3L, (long)instance.getState().intValue());
        Assert.assertEquals((Object)"org.jbpm.writedocument", (Object)instance.getProcessId());
        Assert.assertEquals((Object)"my business key", (Object)instance.getCorrelationKey());
    }

    @Test
    public void testGetProcessInstancesByPartialCorrelationKey() {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("managers");
        this.identityProvider.setRoles(roles);
        Collection instances = this.runtimeDataService.getProcessInstances(new QueryContext());
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        ArrayList<String> props = new ArrayList<String>();
        props.add("first");
        props.add("second");
        props.add("third");
        ArrayList<String> partial1props = new ArrayList<String>();
        partial1props.add("first");
        partial1props.add("second");
        ArrayList<String> partial2props = new ArrayList<String>();
        partial2props.add("first");
        CorrelationKey key = KieInternalServices.Factory.get().newCorrelationKeyFactory().newCorrelationKey(props);
        CorrelationKey partialKey1 = KieInternalServices.Factory.get().newCorrelationKeyFactory().newCorrelationKey(partial1props);
        CorrelationKey partialKey2 = KieInternalServices.Factory.get().newCorrelationKeyFactory().newCorrelationKey(partial2props);
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument", key);
        Assert.assertNotNull((Object)this.processInstanceId);
        Collection keyedInstances = this.runtimeDataService.getProcessInstancesByCorrelationKey(key, new QueryContext());
        Assert.assertNotNull((Object)keyedInstances);
        Assert.assertEquals((long)1L, (long)keyedInstances.size());
        ProcessInstanceDesc instance = (ProcessInstanceDesc)keyedInstances.iterator().next();
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((long)1L, (long)instance.getState().intValue());
        Assert.assertEquals((Object)"org.jbpm.writedocument", (Object)instance.getProcessId());
        Assert.assertEquals((Object)"first:second:third", (Object)instance.getCorrelationKey());
        List tasks = instance.getActiveTasks();
        Assert.assertNull((Object)tasks);
        keyedInstances = this.runtimeDataService.getProcessInstancesByCorrelationKey(partialKey1, new QueryContext());
        Assert.assertNotNull((Object)keyedInstances);
        Assert.assertEquals((long)1L, (long)keyedInstances.size());
        instance = (ProcessInstanceDesc)keyedInstances.iterator().next();
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((long)1L, (long)instance.getState().intValue());
        Assert.assertEquals((Object)"org.jbpm.writedocument", (Object)instance.getProcessId());
        Assert.assertEquals((Object)"first:second:third", (Object)instance.getCorrelationKey());
        keyedInstances = this.runtimeDataService.getProcessInstancesByCorrelationKey(partialKey2, new QueryContext());
        Assert.assertNotNull((Object)keyedInstances);
        Assert.assertEquals((long)1L, (long)keyedInstances.size());
        instance = (ProcessInstanceDesc)keyedInstances.iterator().next();
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((long)1L, (long)instance.getState().intValue());
        Assert.assertEquals((Object)"org.jbpm.writedocument", (Object)instance.getProcessId());
        Assert.assertEquals((Object)"first:second:third", (Object)instance.getCorrelationKey());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }
}

